set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '0040030',
      1,
      NULL,
      NULL,
      0,
      NULL,
      3.857924,
      0,
      NULL,
      NULL,
      ' 7-29-1994',
      35,
      NULL,
      5,
      1.936749,
      3.457834,
      '11-17-1999',
      22.874210,
      3,
      NULL,
      103,
      2,
      ' 2-13-2003',
      ' 8-10-1980',
      ' 6- 6-2002',
      NULL,
      3,
      3,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      41.148727,
      NULL,
      13.447055,
      4,
      29,
      NULL,
      2,
      19,
      4,
      2,
      1,
      0,
      2,
      1,
      0.945749,
      0.102452,
      1.195664,
      0.364960,
      0.201300,
      NULL,
      NULL,
      0,
      NULL,
      5,
      4,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      3,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      2,
      1,
      1,
      1.839441,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0.371160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      0,
      0,
      3,
      1,
      0,
      2,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      5,
      1,
      5,
      1,
      1,
      1,
      NULL,
      2,
      5,
      2,
      4,
      3,
      4,
      5,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      2.757828,
      ' 7- 7-2002',
      577,
      ' 2- 6-1984',
      444.518669,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.806108,
      4,
      1,
      0.139793,
      1.425656,
      1,
      NULL,
      0,
      0.973753,
      NULL,
      2.337980,
      1,
      1.708713,
      1,
      0.110729,
      NULL,
      0.143676,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.083887,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.743259,
      NULL,
      2,
      78.815189,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0.981598,
      0,
      0,
      1.551879,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.494287,
      1,
      NULL,
      3,
      0.058704,
      NULL,
      4.694747,
      4.481333,
      8,
      7,
      2,
      1,
      3.123238,
      6,
      1,
      0.794767,
      0,
      1.565144,
      3,
      3.669629,
      NULL,
      38,
      NULL,
      70,
      2,
      5,
      NULL,
      '33144',
      '',
      '',
      1.486287,
      '',
      '',
      '',
      1.210264,
      '',
      '',
      '',
      NULL,
      29.602378,
      29.859910,
      NULL,
      2,
      42.980491,
      21.047798,
      0,
      2,
      NULL,
      0,
      2.094550,
      3.189743,
      1.967832,
      1.044874,
      0.823215,
      NULL,
      NULL,
      3,
      NULL,
      0.544373,
      3.688504,
      0,
      NULL,
      0.153582,
      NULL,
      NULL,
      NULL,
      1.463737,
      1.230421,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      2,
      NULL,
      1,
      0.013402,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.767388,
      NULL,
      NULL,
      0.990359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.527685,
      NULL,
      NULL,
      1.496499,
      NULL,
      NULL,
      0.475391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.549856,
      NULL,
      NULL,
      3,
      1,
      3.308291,
      1.307604,
      NULL,
      NULL,
      7,
      1.660896,
      3,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.420164,
      2.274504,
      0.016347,
      0,
      0.645122,
      NULL,
      NULL,
      1.001003,
      NULL,
      NULL,
      0.146586,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.192392,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      5.400640,
      0,
      2,
      1.292110,
      NULL,
      0.401036,
      NULL,
      1.434080,
      NULL,
      1,
      2,
      NULL,
      3.992935,
      NULL,
      4,
      1.603877,
      3.158335,
      3,
      0,
      3.730265,
      2,
      2.379950,
      2,
      2.672452,
      0,
      NULL,
      3,
      1.540867,
      0.981701,
      6.040101,
      NULL,
      NULL,
      3.237860,
      NULL,
      NULL,
      2,
      0,
      3,
      1,
      0.963073,
      1,
      0,
      1,
      2.915925,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.340340,
      0,
      0,
      0.860805,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      66,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.914471,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.081425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121846,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.427866,
      NULL,
      NULL,
      NULL,
      1.475147,
      NULL,
      NULL,
      NULL,
      1.251168,
      NULL,
      NULL,
      NULL,
      1.228221,
      NULL,
      NULL,
      NULL,
      0.708403,
      1.966079,
      3,
      0,
      3,
      12,
      NULL,
      0.065226,
      NULL,
      2.918368,
      1,
      NULL,
      NULL,
      3.220606,
      NULL,
      0.769361,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      51.149724,
      1,
      0,
      0.728778,
      1,
      0.329966,
      0,
      0.866692,
      0,
      0,
      0.688047,
      0,
      0.733573,
      NULL,
      1,
      1.896125,
      1.953241,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1.993984,
      NULL,
      3,
      2.154463,
      3.477397,
      3,
      1,
      0.455843,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.589210,
      0,
      NULL,
      0.593429,
      0.317271,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.846112,
      1.107481,
      NULL,
      0.434437,
      1.299678,
      NULL,
      0.208308,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.275620,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2.793097,
      NULL,
      0,
      NULL,
      0.640762,
      NULL,
      1,
      NULL,
      1.204119,
      NULL,
      NULL,
      NULL,
      1.374196,
      NULL,
      1.768790,
      NULL,
      0.795035,
      NULL,
      1.176340,
      NULL,
      NULL,
      NULL,
      6,
      0.797971,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.369571,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642204,
      NULL,
      NULL,
      50,
      30,
      0,
      0,
      3,
      '03443',
      '',
      '',
      0.807162,
      '',
      '',
      NULL,
      0.794344,
      '',
      '',
      '');
commit;
end;
/


