set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686355';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '04',
      '14',
      3.232444,
      14,
      '1224304',
      3,
      NULL,
      4,
      0,
      '0430',
      4.362180,
      0,
      NULL,
      NULL,
      ' 1- 9-1988',
      26,
      40,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 5- 5-1998',
      '11-22-1979',
      ' 4- 2-1982',
      2.480830,
      1.249513,
      3,
      2,
      1.922109,
      1.510709,
      2,
      1,
      0.957766,
      5.754230,
      2,
      NULL,
      2.220396,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      1.219161,
      1,
      1,
      2,
      0,
      0,
      0,
      2,
      2,
      4,
      NULL,
      4,
      NULL,
      0,
      0,
      2,
      0,
      2,
      2,
      NULL,
      1,
      4,
      0,
      9.828355,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.605359,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      1.380878,
      1,
      1,
      NULL,
      NULL,
      0.699748,
      1.648307,
      1,
      0.319370,
      2.965394,
      NULL,
      3,
      3,
      1,
      NULL,
      2,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5,
      NULL,
      1,
      0,
      1,
      0,
      0,
      5,
      1,
      6,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.127470,
      1,
      1,
      0,
      2,
      4,
      NULL,
      NULL,
      NULL,
      2,
      2,
      5,
      1,
      NULL,
      4,
      NULL,
      3,
      5,
      NULL,
      2,
      5,
      NULL,
      NULL,
      5,
      0,
      0,
      1.667230,
      0.197529,
      ' 1- 2-2002',
      311.568854,
      ' 0-18-1993',
      10.227534,
      2,
      NULL,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.093949,
      2.401616,
      0.817196,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.658379,
      NULL,
      NULL,
      4.605275,
      4.053015,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.976820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.696292,
      1.214938,
      0,
      NULL,
      0.927234,
      0,
      1,
      3,
      52.111963,
      0.576916,
      1.482114,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      3,
      NULL,
      1.348925,
      3,
      3.272195,
      0.606811,
      1,
      1,
      NULL,
      0.570134,
      0.583304,
      0.771570,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      3,
      0.178901,
      2.081133,
      NULL,
      5,
      NULL,
      0.395805,
      6.768111,
      1,
      2.559496,
      NULL,
      3,
      NULL,
      0.718587,
      28,
      NULL,
      0.405017,
      14,
      NULL,
      43,
      NULL,
      5,
      1.553893,
      7,
      '31021',
      '21044',
      '22033',
      0.888681,
      '',
      '',
      '',
      0.557416,
      '',
      '',
      NULL,
      1,
      8.368284,
      77.902588,
      12.462016,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.992032,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.873538,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.278593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.491479,
      0,
      1,
      1.828086,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      1.381763,
      1,
      0,
      1.362834,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735608,
      NULL,
      NULL,
      3,
      2.500594,
      0.390725,
      2.317441,
      0.193573,
      2,
      NULL,
      NULL,
      NULL,
      1.979639,
      0.412994,
      1.788619,
      NULL,
      3.350838,
      0.799165,
      3,
      0.226503,
      0.007776,
      1,
      0,
      NULL,
      1.930880,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.890298,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410154,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.195978,
      NULL,
      0.923451,
      1,
      5,
      1,
      1,
      NULL,
      4.711209,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.701948,
      3,
      3.297346,
      1.717456,
      3.836721,
      2.363687,
      4,
      4.495118,
      NULL,
      3,
      NULL,
      3.358221,
      NULL,
      0,
      NULL,
      NULL,
      3.987134,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      4.083312,
      NULL,
      1,
      NULL,
      NULL,
      1.413125,
      0,
      NULL,
      0,
      NULL,
      1.394327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.532959,
      NULL,
      1.687728,
      0,
      1,
      1.249101,
      7.506664,
      7,
      NULL,
      NULL,
      NULL,
      4.679489,
      NULL,
      NULL,
      0,
      3.899599,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.340988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421475,
      NULL,
      NULL,
      0.688648,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673605,
      NULL,
      NULL,
      0.222311,
      0,
      NULL,
      NULL,
      0.738180,
      1.889983,
      NULL,
      NULL,
      1.538129,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.975916,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.166058,
      2,
      NULL,
      NULL,
      NULL,
      0.413236,
      NULL,
      NULL,
      3.893101,
      3,
      1.335310,
      NULL,
      NULL,
      NULL,
      2.002180,
      NULL,
      NULL,
      3.763813,
      NULL,
      1.060005,
      NULL,
      NULL,
      NULL,
      0.702378,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.140465,
      NULL,
      NULL,
      0,
      NULL,
      1,
      259.435763,
      3,
      0.823741,
      0.378840,
      NULL,
      1,
      1.730284,
      0,
      NULL,
      0.709536,
      1,
      0,
      1.748591,
      0,
      1.658915,
      1,
      1.072995,
      1.926986,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.652602,
      NULL,
      128.110259,
      NULL,
      0,
      0,
      43.183921,
      0,
      0,
      NULL,
      NULL,
      2.708694,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.053794,
      NULL,
      1,
      NULL,
      0.718709,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.811019,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      NULL,
      1.976364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.619764,
      NULL,
      1.012905,
      NULL,
      3,
      NULL,
      296,
      NULL,
      1,
      NULL,
      2.361898,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.961293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666095,
      1.708362,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      72.371505,
      NULL,
      3,
      NULL,
      3.636039,
      NULL,
      2.031266,
      NULL,
      1.372433,
      NULL,
      203.419340,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      7.981080,
      NULL,
      3,
      NULL,
      1,
      10.902468,
      2.871277,
      0,
      0,
      1,
      1.618175,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      3.551536,
      1.523461,
      0,
      0.324093,
      0,
      NULL,
      3.000087,
      0,
      2,
      NULL,
      2,
      1,
      0,
      1,
      3,
      3,
      0,
      1,
      1.437745,
      2.750815,
      1.957954,
      0.918827,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992167,
      NULL,
      3.402357,
      1.268564,
      NULL,
      0,
      1,
      2.158844,
      0.228587,
      2,
      NULL,
      0,
      0,
      2.735292,
      0.846917,
      0.186296,
      0,
      1,
      0.174939,
      NULL,
      NULL,
      1.056165,
      0,
      1,
      NULL,
      2,
      3,
      NULL,
      2,
      NULL,
      1,
      0.354265,
      3.922173,
      NULL,
      0.374081,
      0,
      1,
      2,
      5,
      1.970718,
      NULL,
      NULL,
      85.019331,
      30,
      3,
      1,
      5,
      '33313',
      '12433',
      '10243',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


