set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611835';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      2.997359,
      1,
      NULL,
      0,
      '3220',
      3.813769,
      0.403469,
      NULL,
      NULL,
      ' 2-29-1996',
      90,
      NULL,
      3,
      0.440165,
      1.782653,
      ' 8-12-1976',
      42,
      5.688137,
      259.632392,
      4.105380,
      1,
      ' 1-11-1987',
      NULL,
      ' 9- 4-1993',
      0,
      0,
      0,
      2.141471,
      0.935727,
      0.025612,
      2,
      NULL,
      1.021620,
      199,
      1,
      3.057322,
      3.269738,
      3.044970,
      NULL,
      2,
      1,
      5,
      2,
      2,
      1,
      3,
      1,
      NULL,
      0.800546,
      0,
      1.330854,
      1.255619,
      0.699688,
      NULL,
      0.981033,
      2,
      NULL,
      4,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      4,
      0,
      1,
      1,
      0,
      7,
      2,
      2,
      0,
      0,
      1.052634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.686652,
      2.397744,
      NULL,
      1.723093,
      NULL,
      1.219452,
      NULL,
      2,
      0.989675,
      1,
      1,
      1.019015,
      1.606030,
      1.954818,
      1,
      NULL,
      2.756540,
      0,
      0,
      3,
      5.458823,
      3,
      2,
      0.209979,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      2,
      3,
      2,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      0,
      0,
      2.421961,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      4,
      0,
      1,
      3,
      5,
      0,
      1,
      0,
      1,
      NULL,
      3,
      NULL,
      4,
      4,
      0,
      NULL,
      5,
      5,
      1,
      7.123123,
      1,
      ' 3-22-1983',
      320.510181,
      ' 2-13-1994',
      118.319022,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.094658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975361,
      0,
      0.323441,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632185,
      0.356620,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597598,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.657080,
      0,
      24,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      3,
      0.337719,
      NULL,
      0,
      NULL,
      NULL,
      1.685048,
      NULL,
      0.297854,
      NULL,
      0.199500,
      1.778899,
      1,
      1.508408,
      0,
      NULL,
      1.259515,
      1.206043,
      0.503580,
      9,
      6.749602,
      2.068961,
      0,
      NULL,
      3.423875,
      NULL,
      5,
      NULL,
      2.929145,
      NULL,
      37.692528,
      NULL,
      0,
      NULL,
      25,
      27,
      36,
      5,
      NULL,
      3,
      '33341',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      224,
      53,
      0.687193,
      11.132696,
      3.530535,
      0.220230,
      2,
      3.248379,
      NULL,
      3.694094,
      0.387577,
      NULL,
      NULL,
      0.578731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.768321,
      2.423409,
      2.128978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.379691,
      NULL,
      NULL,
      1.752961,
      NULL,
      NULL,
      8.286894,
      6.452396,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.351681,
      NULL,
      NULL,
      NULL,
      3.240276,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.309360,
      1,
      1.178230,
      NULL,
      1.061131,
      3,
      1.536109,
      0.772908,
      NULL,
      NULL,
      3,
      0,
      2,
      NULL,
      1.532841,
      1.703771,
      NULL,
      NULL,
      1.572480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.981519,
      7,
      NULL,
      1,
      0.385872,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.419340,
      NULL,
      NULL,
      1.397143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.768226,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.923854,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.766335,
      0,
      0,
      NULL,
      NULL,
      5,
      0,
      1.702853,
      3,
      1,
      5.200957,
      1,
      NULL,
      NULL,
      0.368856,
      NULL,
      NULL,
      1.874124,
      2.204152,
      1.586931,
      0,
      NULL,
      NULL,
      4,
      NULL,
      4.179830,
      NULL,
      NULL,
      1.760710,
      3,
      NULL,
      2.907063,
      1,
      0,
      2.485966,
      3.138265,
      3.414111,
      1,
      5.167261,
      NULL,
      5.823154,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      0,
      NULL,
      1.852027,
      1,
      1.471059,
      1,
      NULL,
      NULL,
      0.642305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.967066,
      NULL,
      NULL,
      1.913514,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.354537,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1.193709,
      1.435118,
      0.167280,
      0.981446,
      3,
      NULL,
      NULL,
      0.014819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.767025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.546041,
      NULL,
      NULL,
      NULL,
      NULL,
      3.731932,
      NULL,
      NULL,
      0.625676,
      0.572456,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.829807,
      NULL,
      NULL,
      0.106482,
      1,
      NULL,
      NULL,
      2,
      0.667763,
      NULL,
      NULL,
      0.770613,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.558902,
      NULL,
      NULL,
      0.026374,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.108001,
      1.925886,
      0.018168,
      NULL,
      1.246132,
      0,
      0.023127,
      1,
      0.449774,
      1,
      1,
      NULL,
      1,
      1,
      1.510388,
      1.872911,
      0,
      1.507731,
      1.127541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      2,
      3,
      0.133601,
      1,
      1,
      0.609536,
      1,
      1.119415,
      1,
      0.869296,
      2,
      1,
      NULL,
      1.153950,
      3,
      2,
      1.460542,
      NULL,
      0.774129,
      1,
      1.369651,
      NULL,
      1,
      0.289511,
      0,
      3,
      0.688143,
      0,
      0.317488,
      1,
      2.558766,
      NULL,
      0.822806,
      1,
      0,
      2,
      NULL,
      1.179321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.932754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      0,
      7,
      3.734520,
      0,
      2,
      35,
      22,
      NULL,
      2,
      NULL,
      '10120',
      '',
      '',
      0.199678,
      NULL,
      '',
      '',
      0.554918,
      '21444',
      '',
      '');
commit;
end;
/


