set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637670';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '44',
      '20',
      1,
      NULL,
      '0140021',
      0,
      1.034905,
      0,
      NULL,
      '0241',
      0.644257,
      1.424146,
      NULL,
      NULL,
      ' 3-28-1979',
      32.796230,
      4.575529,
      NULL,
      NULL,
      0.903370,
      ' 7- 6-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 5- 3-1996',
      ' 1-18-1983',
      '11-17-1974',
      0,
      3.249589,
      2.657214,
      1.129870,
      NULL,
      3.492944,
      0,
      1.788165,
      1,
      97.819044,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      0.182895,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0.107576,
      0,
      0.995757,
      1.050665,
      8,
      2,
      0,
      1,
      4,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      0,
      0,
      8,
      3,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.172023,
      NULL,
      0.820238,
      0,
      0,
      0,
      2,
      1,
      1.105833,
      1.611228,
      1.278851,
      1.701833,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.958923,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      3,
      1,
      4,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0.251856,
      NULL,
      1,
      0,
      1,
      2,
      1,
      4,
      1,
      5,
      NULL,
      4,
      1,
      2,
      1,
      3,
      NULL,
      2,
      2,
      0,
      4,
      2,
      4,
      0,
      0,
      3,
      NULL,
      2.681287,
      ' 3-14-1988',
      1090.673428,
      ' 7-11-1999',
      639,
      0.114848,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.982208,
      0.924012,
      0.222029,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632445,
      0,
      1.581379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2.314127,
      0,
      1.569285,
      0,
      2.901589,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      2,
      0,
      2,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      3.258346,
      3,
      5,
      0,
      NULL,
      4.696425,
      1,
      1.385818,
      NULL,
      0,
      1,
      0.472124,
      1,
      0.496655,
      1,
      1,
      NULL,
      0,
      10.124375,
      2,
      1,
      7,
      11,
      4.505033,
      NULL,
      1.463934,
      6,
      NULL,
      NULL,
      2,
      18,
      NULL,
      1,
      8,
      NULL,
      NULL,
      39.370014,
      2,
      2.903939,
      3,
      '20224',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '20421',
      '',
      '',
      0.551739,
      19,
      60,
      21.095923,
      0,
      NULL,
      2,
      77,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      2.313888,
      0.130044,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.465652,
      NULL,
      NULL,
      1.182965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.127020,
      6,
      7,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.227244,
      NULL,
      NULL,
      NULL,
      1.299521,
      2.172447,
      2.778741,
      0,
      1.953232,
      3,
      2.253587,
      0.657299,
      0.158368,
      NULL,
      1,
      2.604937,
      3,
      0.450773,
      0,
      NULL,
      0,
      1,
      0,
      2,
      0.691487,
      3,
      1,
      0.102781,
      3,
      1.860032,
      NULL,
      NULL,
      1.792573,
      NULL,
      NULL,
      0.418577,
      NULL,
      NULL,
      NULL,
      4,
      2.768862,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.565361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489721,
      2.696344,
      3,
      1.403779,
      2,
      3,
      NULL,
      NULL,
      NULL,
      6,
      3,
      5.103659,
      NULL,
      0.004198,
      1,
      0.196280,
      NULL,
      NULL,
      4,
      NULL,
      5,
      1.319616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487227,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.396632,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.254233,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      5.041324,
      1,
      NULL,
      NULL,
      2.781817,
      2,
      3,
      0,
      3,
      NULL,
      2.263962,
      0,
      2,
      8,
      1,
      5,
      NULL,
      NULL,
      NULL,
      0.667000,
      NULL,
      2,
      1,
      0,
      3.108722,
      2,
      NULL,
      NULL,
      7.525847,
      0.893497,
      1,
      NULL,
      0,
      6,
      NULL,
      3,
      4,
      1,
      0.029906,
      0.553737,
      0.090034,
      0.275742,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.567163,
      NULL,
      NULL,
      0.272342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.901677,
      1,
      1,
      1,
      NULL,
      0,
      1.800495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.136905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.810589,
      NULL,
      NULL,
      NULL,
      1.782831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.175221,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      87,
      513964,
      0.220819,
      49.143770,
      2514.440118,
      0.740663,
      NULL,
      NULL,
      NULL,
      118.586277,
      NULL,
      1,
      NULL,
      NULL,
      2.682553,
      35.950425,
      10372.121769,
      1.362996,
      NULL,
      1,
      51,
      1462.580270,
      0,
      NULL,
      NULL,
      1,
      1.882489,
      1.894461,
      1,
      0,
      NULL,
      1.892364,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.943781,
      1,
      0.013060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      1.523543,
      NULL,
      5,
      0,
      NULL,
      1.449076,
      NULL,
      3,
      1,
      NULL,
      1.893438,
      NULL,
      0.447281,
      3.318010,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.214919,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.288922,
      1.350737,
      NULL,
      0,
      0,
      NULL,
      2.906716,
      2.171830,
      NULL,
      1,
      NULL,
      NULL,
      2.409277,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.238323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328464,
      NULL,
      0,
      NULL,
      1.017354,
      NULL,
      NULL,
      1,
      NULL,
      3.401016,
      1,
      0.826836,
      10,
      24,
      NULL,
      3,
      0.885679,
      '40342',
      '',
      '',
      0,
      '',
      '',
      '',
      1.601820,
      '00303',
      '',
      '');
commit;
end;
/


