set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410455';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '0031412',
      0.095175,
      1.653080,
      3,
      2,
      '0423',
      0.048804,
      NULL,
      NULL,
      NULL,
      ' 7-15-1979',
      60.660801,
      NULL,
      NULL,
      3.064401,
      NULL,
      '11-16-1976',
      33,
      4.775264,
      299,
      160,
      NULL,
      ' 0- 3-1983',
      ' 9- 5-2001',
      ' 6-21-1987',
      2.483224,
      0.693343,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      58.264270,
      2,
      8,
      2.070069,
      15.766283,
      NULL,
      NULL,
      12,
      2,
      3,
      3.142725,
      0,
      0,
      0,
      1.436549,
      1.063374,
      1.895761,
      0,
      NULL,
      0,
      0.253896,
      1.494524,
      1,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      2,
      0,
      1,
      0,
      3,
      1,
      9.225104,
      1,
      NULL,
      2,
      0,
      1.481467,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      2,
      1,
      2,
      1.370159,
      0.490674,
      0.022888,
      1,
      NULL,
      NULL,
      1,
      1.632761,
      0.744566,
      1,
      NULL,
      1,
      NULL,
      3,
      0.432681,
      NULL,
      1,
      2,
      6.598957,
      0,
      2,
      0,
      0.325862,
      NULL,
      NULL,
      1.148289,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      2.467604,
      0,
      NULL,
      0,
      0,
      0.691192,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      2,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      5,
      0,
      NULL,
      3,
      0,
      3,
      1,
      1,
      ' 7-19-2003',
      33,
      ' 3-13-1989',
      1.946738,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1.668803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      1.134090,
      5,
      1,
      2.712830,
      0,
      1.066419,
      3.902349,
      1,
      1,
      3,
      2,
      NULL,
      NULL,
      1,
      1.747843,
      NULL,
      2,
      5,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.307056,
      1.455886,
      NULL,
      1,
      5,
      2,
      NULL,
      NULL,
      27.624547,
      ' 3-10-1985',
      5.804649,
      NULL,
      1,
      0.472942,
      NULL,
      3,
      0.271579,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.656783,
      NULL,
      1,
      2,
      0,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      0.735788,
      0.207459,
      0.330088,
      NULL,
      1.568464,
      0.206200,
      3,
      NULL,
      0.052170,
      1.571808,
      0,
      1,
      1,
      1.691764,
      NULL,
      0,
      1,
      3.769253,
      NULL,
      5,
      7,
      6.444861,
      0,
      8.737619,
      3.199819,
      NULL,
      0,
      NULL,
      1.123086,
      1.390736,
      0.025443,
      34.293851,
      0,
      NULL,
      NULL,
      57,
      27,
      31,
      1,
      0,
      2,
      '0131',
      '33220',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.714495,
      29,
      48,
      48,
      0.193887,
      1.096166,
      7,
      3,
      4,
      3,
      3.548378,
      NULL,
      1,
      NULL,
      NULL,
      0.043479,
      0,
      0,
      1.328730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223911,
      0,
      3,
      2,
      2.678314,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      5,
      1.125221,
      3.102946,
      1,
      0.101291,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.874368,
      2.951924,
      NULL,
      1.713475,
      0,
      NULL,
      NULL,
      0,
      0.634213,
      1,
      2.212909,
      0,
      0.118448,
      2,
      NULL,
      0.821969,
      1.808167,
      3,
      1,
      1.602499,
      0.831898,
      2.459194,
      1,
      1.950570,
      NULL,
      3,
      0.532721,
      NULL,
      NULL,
      0.544968,
      0.190995,
      1.109877,
      1,
      3,
      3,
      0,
      0.977437,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.751400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579893,
      NULL,
      NULL,
      0.115530,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.131746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.105320,
      NULL,
      NULL,
      0.222513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.172885,
      0,
      1.187716,
      1.436839,
      1,
      1.922661,
      1,
      3.057020,
      NULL,
      3,
      2,
      2.845621,
      1.144973,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.678891,
      0,
      0,
      NULL,
      4.707735,
      NULL,
      3.316316,
      1,
      3,
      1,
      4,
      4,
      1.436733,
      0,
      0,
      NULL,
      1.337928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.865102,
      1,
      1.878421,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      2.132407,
      257,
      NULL,
      NULL,
      2,
      0.038988,
      NULL,
      NULL,
      1.859581,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.307392,
      NULL,
      NULL,
      NULL,
      0.856618,
      NULL,
      NULL,
      2.612226,
      0.066718,
      NULL,
      NULL,
      3.994385,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.645153,
      1,
      NULL,
      NULL,
      0,
      2.399832,
      NULL,
      NULL,
      0.613330,
      1.615805,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      0.640531,
      NULL,
      NULL,
      NULL,
      0.184009,
      0,
      NULL,
      NULL,
      NULL,
      1.639691,
      NULL,
      NULL,
      2.958146,
      3,
      NULL,
      NULL,
      3.954154,
      3.356638,
      NULL,
      NULL,
      12.549902,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63.687424,
      584.214798,
      3.523668,
      79,
      177,
      NULL,
      0.842338,
      344.738072,
      2.108371,
      4,
      453.515255,
      3,
      NULL,
      379,
      2.814441,
      14.628981,
      76.913410,
      1,
      9,
      1,
      7,
      NULL,
      0.597187,
      0,
      1.465894,
      1,
      0,
      1.887189,
      1,
      1,
      1,
      NULL,
      NULL,
      1.993257,
      1.309671,
      1,
      1.004766,
      0,
      0,
      0.860509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      3,
      1,
      0.336771,
      NULL,
      3,
      4,
      1.549346,
      NULL,
      NULL,
      0,
      NULL,
      1.774871,
      NULL,
      2.446095,
      NULL,
      NULL,
      3.939138,
      2.445093,
      1,
      0,
      NULL,
      0,
      1.621883,
      1.687165,
      1,
      0.411276,
      1.719968,
      1,
      1.332411,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      3.775783,
      2,
      1.437895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.996598,
      0,
      2,
      1.763181,
      NULL,
      0.315612,
      2.736562,
      1.249695,
      0.105403,
      1.638627,
      2.055800,
      NULL,
      0,
      1,
      2,
      0.120497,
      1.434015,
      NULL,
      3.211069,
      2.861326,
      2,
      0,
      3,
      2.255050,
      0.952958,
      1,
      0.094736,
      16.463030,
      2.795540,
      NULL,
      1,
      1,
      NULL,
      3,
      1,
      0,
      1,
      1,
      0,
      0.074843,
      NULL,
      NULL,
      35.811208,
      59,
      2,
      1,
      1,
      '0342',
      '30341',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


