set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7713617';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '0321013',
      0.079619,
      0,
      1,
      1,
      '3102',
      0,
      0,
      NULL,
      NULL,
      ' 2-13-1994',
      4,
      NULL,
      NULL,
      2.942260,
      0,
      ' 1-24-1977',
      55.125022,
      1,
      154,
      NULL,
      NULL,
      ' 2- 3-1974',
      ' 4-13-1974',
      ' 7-22-1995',
      1,
      NULL,
      2,
      NULL,
      0.645433,
      3.913778,
      4,
      0,
      NULL,
      72.502096,
      NULL,
      NULL,
      2.643860,
      34.201216,
      188.681147,
      2,
      NULL,
      NULL,
      3,
      2.057726,
      0,
      NULL,
      NULL,
      1.421889,
      1.782855,
      1.800402,
      1.709427,
      1,
      0,
      NULL,
      105,
      2,
      3,
      7,
      0.658713,
      3,
      1,
      1,
      2,
      1,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      0,
      7.451887,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.965468,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      0,
      0.957773,
      0.836579,
      3.621212,
      1,
      0.159219,
      NULL,
      1.899873,
      2,
      0,
      3.275228,
      NULL,
      NULL,
      0.358003,
      0.927807,
      NULL,
      0,
      0,
      6.589692,
      0,
      0,
      1,
      1.674102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      0,
      0,
      4,
      0,
      0,
      NULL,
      2,
      NULL,
      0,
      2,
      3,
      NULL,
      0,
      1,
      0,
      NULL,
      2.785665,
      0,
      ' 6-25-1977',
      138,
      ' 4-11-1977',
      52,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.577819,
      1,
      0,
      1.766217,
      0.159657,
      1,
      1.759586,
      NULL,
      NULL,
      NULL,
      1.856082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.858480,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.829847,
      0,
      550,
      0,
      0.847690,
      NULL,
      NULL,
      NULL,
      3,
      0.653709,
      0,
      3,
      NULL,
      NULL,
      0,
      3,
      2,
      3,
      1,
      3,
      0,
      NULL,
      16.390214,
      18.783898,
      185.633862,
      NULL,
      12,
      191,
      NULL,
      103.556797,
      1,
      0.043263,
      NULL,
      1.995069,
      0.621252,
      0,
      NULL,
      2.205026,
      4,
      1.609674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      67,
      4,
      0.128041,
      1,
      '42210',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.058160,
      '',
      '',
      '',
      0.846593,
      NULL,
      137,
      3.773922,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.760375,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.445170,
      1,
      0.880566,
      NULL,
      NULL,
      NULL,
      1.907081,
      NULL,
      NULL,
      1.737188,
      NULL,
      NULL,
      0.484831,
      NULL,
      NULL,
      0.018909,
      NULL,
      NULL,
      8.898921,
      1.251317,
      NULL,
      NULL,
      1.667243,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752166,
      0.058005,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      NULL,
      0.601480,
      2,
      2,
      1.736322,
      NULL,
      NULL,
      0.406306,
      1,
      NULL,
      0,
      1,
      2,
      1.031369,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      9,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.994354,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.110345,
      0,
      NULL,
      NULL,
      3,
      5,
      5.842401,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403379,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.676250,
      NULL,
      NULL,
      0.053811,
      NULL,
      NULL,
      1.028016,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.417602,
      NULL,
      1.523223,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.238059,
      3.779535,
      0,
      2.486732,
      3.028243,
      NULL,
      5.859842,
      1,
      2.120103,
      3,
      1,
      NULL,
      0,
      0.331457,
      NULL,
      NULL,
      0,
      2.065249,
      2.924647,
      0.563040,
      4,
      0,
      0,
      NULL,
      7.383798,
      2.824438,
      0,
      3,
      NULL,
      0.069280,
      0,
      1,
      NULL,
      0.269259,
      2,
      NULL,
      NULL,
      3.106342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.320499,
      NULL,
      NULL,
      1.405343,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.900699,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487840,
      NULL,
      NULL,
      NULL,
      1,
      0.718866,
      1.340859,
      0,
      2,
      0.031016,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.500330,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.114626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144679,
      NULL,
      NULL,
      NULL,
      0.696010,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      16.562096,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      16.040690,
      116.610782,
      0,
      NULL,
      NULL,
      1.977223,
      NULL,
      NULL,
      0.504212,
      NULL,
      NULL,
      1.296620,
      NULL,
      NULL,
      0.323147,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      15797.324585,
      181,
      0.061150,
      0,
      0.672793,
      1.399043,
      1.246008,
      1.746692,
      0.311329,
      0,
      NULL,
      0,
      NULL,
      1.793703,
      0,
      NULL,
      1.688532,
      1,
      0.413780,
      0.456985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      7,
      3,
      1.890753,
      1.226076,
      0,
      14,
      0.650213,
      3.874989,
      0,
      17,
      17,
      NULL,
      7.528973,
      16.873932,
      NULL,
      3.510188,
      7.765297,
      NULL,
      NULL,
      4,
      NULL,
      18,
      NULL,
      NULL,
      0.208487,
      10.883382,
      NULL,
      12,
      17.194108,
      NULL,
      16,
      NULL,
      NULL,
      16.414784,
      14,
      NULL,
      13,
      9,
      NULL,
      4,
      NULL,
      NULL,
      2,
      0.111302,
      1.043417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.416963,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      20.632424,
      55.527293,
      0,
      NULL,
      NULL,
      '00022',
      '',
      '',
      0.440841,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


