set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7713617';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      '34',
      13.853567,
      NULL,
      '0212342',
      NULL,
      0,
      NULL,
      1,
      '1122',
      0.598264,
      0,
      NULL,
      NULL,
      ' 5- 7-1996',
      104.924346,
      8,
      NULL,
      3.700615,
      0,
      ' 7-10-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 0- 9-1977',
      ' 6- 1-1992',
      ' 4-27-1982',
      0.986013,
      0.985831,
      2,
      1.636595,
      NULL,
      1.568780,
      4,
      0,
      1,
      15,
      2,
      15.902256,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.432374,
      0,
      0.894649,
      0.026058,
      1,
      1,
      1,
      NULL,
      4,
      4,
      NULL,
      0.841423,
      4,
      1,
      0,
      1,
      0,
      NULL,
      4,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      7.088214,
      NULL,
      1.216337,
      1,
      0,
      2,
      NULL,
      NULL,
      1,
      0,
      2,
      3.019236,
      0,
      3,
      3.351995,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.835962,
      1,
      2,
      2.181848,
      1,
      NULL,
      NULL,
      1.959113,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      2.815938,
      0,
      0,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      0,
      3,
      3,
      0,
      NULL,
      0,
      3,
      5,
      NULL,
      5,
      0,
      1,
      NULL,
      5,
      0,
      NULL,
      5,
      5.497344,
      0,
      ' 1- 5-1986',
      2261,
      ' 2-12-1984',
      2868,
      1.755570,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0.548330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      1.167408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073568,
      2.371066,
      3.898745,
      2.283474,
      1.500118,
      1.893069,
      3.270020,
      0,
      0.434034,
      3,
      3,
      1.859787,
      NULL,
      NULL,
      NULL,
      0.067561,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578641,
      NULL,
      NULL,
      NULL,
      1.596993,
      NULL,
      0,
      NULL,
      9877.664793,
      1.968371,
      1.652066,
      NULL,
      NULL,
      NULL,
      3,
      1.518884,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      2,
      3,
      3,
      1,
      NULL,
      5.979414,
      NULL,
      NULL,
      0,
      1.548663,
      NULL,
      0.336350,
      1,
      NULL,
      1.106007,
      NULL,
      0,
      1.167694,
      0.937004,
      1,
      0,
      NULL,
      NULL,
      1,
      1.161317,
      10.516716,
      4,
      0.226363,
      1.340284,
      5.939924,
      NULL,
      NULL,
      1.997889,
      1,
      0,
      NULL,
      46.304394,
      2,
      2.373517,
      58,
      NULL,
      5,
      13,
      NULL,
      4,
      1,
      '30244',
      '',
      '',
      1.885628,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      12,
      NULL,
      40.313395,
      3,
      15.958730,
      3.505631,
      358,
      1,
      1.581575,
      2,
      1.477909,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.356447,
      0.407878,
      NULL,
      NULL,
      0.247244,
      1.715438,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.800136,
      0.814986,
      1.783075,
      1.754658,
      1.627403,
      3.403125,
      0,
      NULL,
      0.128309,
      0.998823,
      0,
      8,
      3.599634,
      6,
      NULL,
      1.785368,
      NULL,
      NULL,
      NULL,
      1.939021,
      NULL,
      NULL,
      NULL,
      3,
      0.238034,
      2.969640,
      NULL,
      NULL,
      0.054682,
      NULL,
      3,
      1.666991,
      NULL,
      NULL,
      1.018766,
      NULL,
      NULL,
      0.531964,
      3.341501,
      0.187877,
      NULL,
      1,
      2,
      2.202998,
      1.468231,
      3,
      0,
      0.839862,
      1,
      0,
      1,
      3,
      0,
      0.283110,
      3,
      3,
      0,
      9.595107,
      0,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.889060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.473852,
      NULL,
      NULL,
      NULL,
      5.203419,
      1,
      1,
      NULL,
      NULL,
      0.892756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480365,
      NULL,
      NULL,
      0.053131,
      NULL,
      NULL,
      0.777768,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.504242,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.449256,
      NULL,
      NULL,
      1.119852,
      1,
      2,
      NULL,
      1.596043,
      3,
      3,
      2.042818,
      0,
      NULL,
      NULL,
      2.779915,
      2.753043,
      NULL,
      2,
      NULL,
      1.079799,
      0,
      0.943618,
      NULL,
      3,
      1.174324,
      2.360819,
      3,
      6.950045,
      7,
      6,
      3.041200,
      3,
      6.092897,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.074142,
      2,
      NULL,
      NULL,
      3.115839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.155639,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.070227,
      NULL,
      NULL,
      0.269404,
      NULL,
      NULL,
      2.581979,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.474617,
      1,
      NULL,
      3.500379,
      0,
      NULL,
      NULL,
      2.614207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.040225,
      NULL,
      NULL,
      NULL,
      2.261540,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.067340,
      NULL,
      NULL,
      NULL,
      1.005024,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015352,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      3.275268,
      7,
      6,
      1,
      2.111766,
      485.636603,
      98,
      0.921098,
      142,
      2.406192,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.489238,
      NULL,
      NULL,
      1.663090,
      NULL,
      NULL,
      0.642360,
      46,
      1,
      420.252738,
      64,
      1.452752,
      0,
      NULL,
      0.400812,
      NULL,
      0.492866,
      1,
      1.313842,
      0.999614,
      0.384859,
      0.938422,
      1,
      0.748634,
      NULL,
      NULL,
      1,
      1,
      1.603645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      NULL,
      2.211818,
      NULL,
      4,
      3,
      15,
      0.532496,
      3,
      NULL,
      1.415368,
      0,
      NULL,
      0,
      3.730190,
      NULL,
      NULL,
      3,
      NULL,
      0.871277,
      0.609919,
      NULL,
      1.883184,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.320865,
      NULL,
      0.197080,
      0,
      NULL,
      1.607801,
      NULL,
      NULL,
      1,
      1.475174,
      NULL,
      1,
      1,
      NULL,
      3.346428,
      1.658237,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.719234,
      NULL,
      0.961624,
      NULL,
      0,
      5,
      6,
      1,
      1.760961,
      1.333071,
      3,
      NULL,
      3,
      4.636909,
      2,
      '31140',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.632664,
      '',
      '',
      '');
commit;
end;
/


