set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      1.430380,
      1.594685,
      1,
      3,
      '2334',
      0,
      0.707508,
      NULL,
      NULL,
      ' 0- 6-1987',
      23,
      NULL,
      4,
      2.204533,
      NULL,
      ' 2-19-1985',
      45.513225,
      0.157704,
      62,
      41.520621,
      NULL,
      ' 0-23-1992',
      ' 1-22-1995',
      ' 6-14-1996',
      0,
      0,
      1.764306,
      1,
      1.947272,
      1.064889,
      3,
      1,
      0.602884,
      78,
      7,
      5,
      0,
      7,
      25,
      2,
      19,
      2,
      2,
      8,
      1.694120,
      3,
      0,
      1,
      1,
      1.429215,
      1,
      0.041884,
      1.879257,
      NULL,
      0,
      0,
      2,
      NULL,
      1.958542,
      0,
      0,
      NULL,
      3,
      1,
      0,
      2,
      2,
      2,
      4,
      2,
      2,
      6,
      0,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      4,
      NULL,
      1.441248,
      1.159878,
      1,
      3,
      3.547420,
      2,
      3,
      NULL,
      NULL,
      1,
      1,
      1.904805,
      1,
      1.195098,
      3,
      NULL,
      0,
      1,
      2,
      6.018916,
      NULL,
      0,
      1.864962,
      NULL,
      NULL,
      NULL,
      0.410917,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      2,
      1,
      1,
      0,
      0,
      5,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      2,
      4,
      1,
      4,
      2,
      1,
      4,
      1,
      NULL,
      0,
      4,
      0,
      0,
      NULL,
      NULL,
      4,
      5,
      0,
      5,
      3,
      NULL,
      1.852282,
      ' 4-22-1982',
      190.523778,
      '10-25-1975',
      1158.406260,
      3.904465,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1.890474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.946126,
      6,
      1,
      1,
      NULL,
      0.348125,
      NULL,
      NULL,
      NULL,
      1.573525,
      1.663643,
      0.397275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416449,
      1,
      0,
      1,
      NULL,
      0.870918,
      1,
      3,
      NULL,
      1.888381,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.903130,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      1,
      2.250954,
      NULL,
      0,
      0.869986,
      1.569721,
      1,
      1.522832,
      1.964440,
      0,
      1.622130,
      1.575925,
      NULL,
      NULL,
      NULL,
      1.897091,
      0.296988,
      9.275040,
      4,
      0.774527,
      6.507975,
      6.662624,
      1,
      2,
      3,
      NULL,
      0.442438,
      NULL,
      2.162984,
      65,
      2,
      0.393440,
      NULL,
      6,
      12,
      22.370681,
      NULL,
      1.322756,
      0.412426,
      NULL,
      '',
      '',
      1.358963,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1.569737,
      13,
      93.507605,
      72.742155,
      NULL,
      NULL,
      4,
      2,
      5,
      3,
      3.456978,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.220311,
      NULL,
      NULL,
      0.899592,
      NULL,
      NULL,
      2.456846,
      1.564600,
      1.289842,
      1.217924,
      NULL,
      3.478126,
      1.053783,
      0.086427,
      1.261919,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.858479,
      NULL,
      1.544330,
      NULL,
      NULL,
      NULL,
      0,
      1.155387,
      1,
      0.365235,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.044125,
      2.131800,
      1.745031,
      1,
      2,
      0,
      1,
      2.257528,
      1,
      1,
      3.890080,
      1,
      2.127614,
      2,
      2,
      1.939730,
      NULL,
      1,
      1,
      0.742753,
      2,
      NULL,
      3,
      NULL,
      NULL,
      1.858303,
      1.640264,
      NULL,
      NULL,
      0,
      NULL,
      0.043199,
      8.043001,
      1.052036,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.625633,
      NULL,
      NULL,
      1.297105,
      NULL,
      NULL,
      0.832764,
      NULL,
      NULL,
      0.269475,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.099308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562072,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.862301,
      NULL,
      NULL,
      0.140735,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.721572,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.839605,
      1.236138,
      0.212947,
      NULL,
      NULL,
      0,
      NULL,
      4,
      8.171772,
      0.666370,
      3.135844,
      0,
      NULL,
      NULL,
      1.018899,
      NULL,
      NULL,
      0.613265,
      NULL,
      NULL,
      2.348429,
      NULL,
      NULL,
      2,
      3.111305,
      1,
      0.359964,
      3.851395,
      2,
      3,
      1,
      1.100891,
      0,
      NULL,
      0,
      1.617692,
      0,
      NULL,
      5,
      9.263447,
      3,
      0.227006,
      NULL,
      2,
      3,
      2,
      3,
      0.982971,
      1,
      1.341150,
      1.313886,
      1.047884,
      NULL,
      NULL,
      NULL,
      1.233044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.292420,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.490214,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.174620,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.145069,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.233426,
      NULL,
      NULL,
      NULL,
      0.282894,
      NULL,
      NULL,
      NULL,
      1.659204,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.490739,
      NULL,
      NULL,
      NULL,
      1.758429,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.623889,
      NULL,
      NULL,
      NULL,
      0.636374,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      6.108807,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7,
      NULL,
      3.018912,
      8.475504,
      3.231761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.350915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409493,
      NULL,
      1,
      31.064493,
      0,
      0,
      0,
      1,
      1,
      0.022349,
      NULL,
      0.664824,
      0,
      1.268631,
      NULL,
      0.936943,
      0.224374,
      0.573447,
      0,
      1.478316,
      0.578891,
      0.171308,
      1.010330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.074014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1,
      NULL,
      3,
      0,
      1.366671,
      3,
      NULL,
      2,
      NULL,
      0,
      1.125512,
      0,
      NULL,
      0,
      0,
      NULL,
      1.719552,
      1,
      NULL,
      1,
      1.226507,
      NULL,
      1,
      0.665209,
      NULL,
      3.046144,
      0.779506,
      NULL,
      NULL,
      NULL,
      NULL,
      2.519666,
      NULL,
      NULL,
      0,
      1.805361,
      NULL,
      0.189950,
      0.281727,
      NULL,
      0.061365,
      0,
      NULL,
      2,
      NULL,
      0.328219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.128377,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      0.300770,
      0.654496,
      19.348878,
      83.400426,
      2,
      1,
      0,
      '10341',
      '',
      '',
      0,
      '',
      '',
      '',
      0.078429,
      '',
      '',
      '');
commit;
end;
/


