set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '2011324',
      NULL,
      NULL,
      0,
      2,
      '3100',
      3,
      1,
      NULL,
      NULL,
      ' 5-11-1975',
      45,
      NULL,
      4,
      0,
      1.791338,
      ' 6-25-1979',
      63.197428,
      2,
      10,
      193.964175,
      2,
      ' 0- 3-1982',
      NULL,
      ' 2- 6-1975',
      1,
      2,
      1.046816,
      0.557767,
      0,
      NULL,
      1,
      0,
      0.104340,
      365.986618,
      2,
      NULL,
      NULL,
      5.123283,
      7,
      3,
      NULL,
      3,
      3,
      1.638638,
      0,
      3,
      0,
      0,
      1,
      1.748426,
      NULL,
      0.841662,
      NULL,
      1.287210,
      0,
      2,
      1,
      2,
      3.569551,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      5,
      2,
      NULL,
      2,
      3,
      2,
      6,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      2,
      6.397588,
      3.766460,
      1.736708,
      0,
      NULL,
      3.601904,
      NULL,
      0,
      1,
      0,
      0.494008,
      3,
      1,
      1.298487,
      0,
      0.276824,
      NULL,
      0,
      1,
      0,
      9.753788,
      1,
      2,
      3.790886,
      0.254161,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4,
      1,
      NULL,
      4,
      2,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      0.900571,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      2.558500,
      5,
      1,
      1,
      2,
      0,
      NULL,
      2,
      NULL,
      5,
      2,
      0,
      0,
      5,
      1,
      2,
      NULL,
      NULL,
      1,
      2,
      2,
      4,
      4,
      NULL,
      3,
      NULL,
      0,
      1.676177,
      ' 5-22-2003',
      1096,
      ' 7- 5-1976',
      317,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      1.001855,
      0,
      1.295116,
      0.345547,
      1,
      1.419716,
      1.191014,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      9.380651,
      11,
      7.617554,
      4,
      7,
      3.589126,
      NULL,
      NULL,
      NULL,
      1,
      1.525616,
      0.916791,
      0,
      0,
      NULL,
      NULL,
      '11-26-1978',
      21.581399,
      NULL,
      NULL,
      0.752182,
      NULL,
      0.476260,
      1,
      0,
      1.954759,
      1,
      0,
      1.124485,
      1,
      1.474654,
      26.425467,
      3.774418,
      1.770228,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      0,
      2,
      2,
      NULL,
      3,
      0,
      NULL,
      3,
      1,
      1,
      2,
      3.066293,
      2,
      1,
      1.216469,
      1,
      NULL,
      1.572970,
      1,
      0.766725,
      0,
      0,
      0,
      0.797067,
      0,
      1,
      3.505286,
      1,
      7.323414,
      NULL,
      1.334966,
      4,
      3.403237,
      NULL,
      NULL,
      3,
      0,
      0.367680,
      NULL,
      3.820284,
      NULL,
      1,
      2,
      NULL,
      9,
      9,
      27,
      NULL,
      0,
      NULL,
      '03004',
      '',
      '',
      1,
      '',
      '',
      '',
      0.092027,
      '',
      '',
      '',
      2,
      20,
      NULL,
      63.231586,
      1,
      28,
      NULL,
      1.384934,
      0,
      3.881092,
      1.213874,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.652115,
      1.438726,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.150083,
      0,
      0.849564,
      2.658520,
      NULL,
      0,
      NULL,
      0.504156,
      1.419534,
      3.029400,
      NULL,
      0,
      1,
      1.675859,
      NULL,
      NULL,
      0.322442,
      0.388324,
      2,
      NULL,
      1,
      7.411607,
      3.846653,
      5,
      1,
      1.393443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.230515,
      0.354018,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      1.809434,
      3.629319,
      2,
      0,
      0,
      0,
      NULL,
      0.485487,
      0,
      3,
      0,
      1,
      2.293779,
      2,
      1,
      1.280271,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      6.162694,
      NULL,
      1.944891,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.817688,
      NULL,
      NULL,
      NULL,
      1.228638,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473206,
      3,
      1,
      0,
      1,
      1,
      NULL,
      2.164385,
      1,
      0.516566,
      0,
      1.649443,
      0.375123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129148,
      NULL,
      NULL,
      1.060774,
      NULL,
      NULL,
      0.109169,
      NULL,
      NULL,
      2,
      2.514757,
      0.214274,
      1,
      NULL,
      NULL,
      5,
      1,
      1,
      2.201745,
      5.110426,
      5,
      NULL,
      NULL,
      NULL,
      0.270027,
      NULL,
      NULL,
      1,
      2.121655,
      NULL,
      1.514541,
      3,
      NULL,
      NULL,
      3,
      3.243797,
      NULL,
      2.069334,
      1.623786,
      3,
      0,
      NULL,
      3.809501,
      2,
      2.171875,
      2.860624,
      NULL,
      0.524579,
      5.029884,
      1.441176,
      6,
      7,
      2,
      NULL,
      NULL,
      NULL,
      4,
      1.971442,
      1,
      1.149482,
      NULL,
      0.542575,
      0,
      NULL,
      NULL,
      0.657618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871356,
      NULL,
      NULL,
      1.389763,
      NULL,
      NULL,
      1.779512,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.720753,
      1,
      1,
      0.571675,
      0,
      NULL,
      NULL,
      NULL,
      2.969254,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      1.557802,
      NULL,
      NULL,
      NULL,
      0.227203,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.403790,
      NULL,
      NULL,
      NULL,
      1.881362,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.960274,
      NULL,
      NULL,
      NULL,
      3.380940,
      NULL,
      NULL,
      NULL,
      3.404352,
      NULL,
      NULL,
      NULL,
      3.481305,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.867364,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      5,
      NULL,
      NULL,
      16.020955,
      0.055258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.228661,
      NULL,
      1.725987,
      84,
      0,
      0,
      NULL,
      0,
      0.469599,
      0,
      0,
      0,
      1.249842,
      1,
      0,
      1,
      1.488248,
      1.578769,
      NULL,
      NULL,
      0,
      0.493464,
      1.674633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      12.998172,
      3.320529,
      NULL,
      NULL,
      3,
      19,
      NULL,
      NULL,
      1.243594,
      NULL,
      0,
      NULL,
      1,
      0.539918,
      NULL,
      2.224538,
      0,
      NULL,
      0.913144,
      0.113474,
      NULL,
      0.124413,
      NULL,
      NULL,
      2.781937,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.816527,
      3.600475,
      NULL,
      1,
      1,
      NULL,
      0.738081,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966722,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3,
      5,
      1,
      NULL,
      NULL,
      49.264708,
      31.812216,
      NULL,
      NULL,
      1.167699,
      '04031',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0.173980,
      '',
      NULL,
      '');
commit;
end;
/


