set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8524126';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3402120',
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.600006,
      NULL,
      NULL,
      ' 8-29-1986',
      2.369200,
      NULL,
      3,
      0,
      0.831653,
      ' 5- 9-1979',
      55.672758,
      2.162108,
      71,
      99,
      0,
      '10-17-1998',
      NULL,
      '10-11-1999',
      0,
      0,
      NULL,
      0.132780,
      0.771850,
      0,
      NULL,
      NULL,
      0.628367,
      80,
      0,
      18.284846,
      17.301112,
      191.352640,
      63,
      1,
      NULL,
      2,
      3,
      1,
      1,
      1,
      0,
      0.708369,
      1,
      0.933822,
      0.407298,
      NULL,
      NULL,
      1.510633,
      NULL,
      0,
      4,
      3,
      2.665348,
      4,
      0,
      1,
      2,
      1,
      1,
      2,
      1,
      2,
      1,
      0,
      1,
      1.804652,
      0,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      0,
      0.618033,
      0,
      1,
      3.934176,
      3.277948,
      2.420978,
      2.892348,
      2.166862,
      NULL,
      NULL,
      0,
      1.028494,
      1,
      NULL,
      1.723657,
      1.607003,
      NULL,
      0,
      1,
      2,
      1,
      0,
      3.084213,
      1.516081,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      1,
      3,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0.265987,
      NULL,
      NULL,
      3,
      5,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      3,
      NULL,
      NULL,
      4,
      NULL,
      3,
      3,
      0,
      NULL,
      2,
      1,
      NULL,
      3,
      1,
      0,
      0,
      NULL,
      1,
      ' 5-10-1976',
      NULL,
      ' 4-20-2002',
      475,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0.297292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632007,
      0,
      0,
      NULL,
      0.790093,
      1,
      0.431345,
      NULL,
      NULL,
      NULL,
      0.455160,
      3.069830,
      0.032677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.984712,
      1.073811,
      1,
      NULL,
      NULL,
      0.204528,
      0,
      3.375099,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412984,
      NULL,
      7,
      6.033203,
      11.163909,
      NULL,
      2.797215,
      1,
      0,
      7,
      2.227431,
      1.923897,
      2,
      17.632668,
      0,
      3,
      NULL,
      41,
      44,
      47.701462,
      1,
      NULL,
      1.663434,
      '33243',
      '44333',
      '12122',
      1.057435,
      '',
      NULL,
      '',
      3.023048,
      '421',
      '',
      NULL,
      3,
      13.195109,
      NULL,
      NULL,
      0,
      24,
      13.832034,
      1,
      0,
      NULL,
      2,
      3.346371,
      1.239936,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      12,
      1.982944,
      1.028412,
      NULL,
      NULL,
      1.129688,
      NULL,
      NULL,
      NULL,
      1.480260,
      2.081993,
      1.902446,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.040830,
      NULL,
      NULL,
      1.257315,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.509938,
      NULL,
      4.436636,
      1,
      1.339112,
      NULL,
      NULL,
      NULL,
      0.374495,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.607576,
      1,
      NULL,
      1,
      1,
      1.751026,
      NULL,
      3.802126,
      0,
      1.320556,
      2.503528,
      NULL,
      1,
      0,
      3.415593,
      0.874166,
      NULL,
      3.553273,
      0,
      1.143165,
      NULL,
      NULL,
      1.039646,
      NULL,
      17.335795,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.633900,
      8.118148,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150429,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.704101,
      0.126116,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339237,
      NULL,
      NULL,
      7.252555,
      7,
      NULL,
      0,
      3.440792,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5.944286,
      3.592444,
      1.914536,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.244025,
      NULL,
      NULL,
      0.017820,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.506825,
      2,
      3,
      3,
      2,
      1.019818,
      5,
      NULL,
      NULL,
      NULL,
      1.402612,
      3.668946,
      NULL,
      NULL,
      0,
      1,
      1.689715,
      NULL,
      NULL,
      NULL,
      0.865471,
      NULL,
      NULL,
      NULL,
      2,
      9,
      0.383159,
      1,
      3.966236,
      NULL,
      0,
      1.122632,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      10,
      NULL,
      5.470897,
      2.742276,
      NULL,
      NULL,
      1.123554,
      4,
      4,
      0,
      0.203195,
      NULL,
      0.032028,
      1,
      0.029500,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.390134,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.910871,
      NULL,
      NULL,
      1.919101,
      NULL,
      NULL,
      1.623391,
      NULL,
      NULL,
      0.550869,
      1,
      0.491419,
      0.421458,
      NULL,
      0.507403,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.288269,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.264637,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.397123,
      NULL,
      NULL,
      NULL,
      0,
      213,
      64.700556,
      NULL,
      363,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.912654,
      1791,
      1389.455178,
      0.562254,
      1018.124913,
      1148.083469,
      0,
      NULL,
      0.826236,
      8853.413839,
      1987.755807,
      1,
      2.317612,
      1.955652,
      0.677647,
      1.370943,
      0,
      0.625339,
      NULL,
      NULL,
      NULL,
      1,
      0.445891,
      1.519353,
      0.158027,
      1.925423,
      NULL,
      1.317252,
      1,
      NULL,
      1,
      NULL,
      1.971727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695850,
      NULL,
      62,
      NULL,
      3,
      17,
      NULL,
      0.977961,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.391810,
      NULL,
      1.031454,
      NULL,
      0.588129,
      NULL,
      NULL,
      NULL,
      0.943239,
      NULL,
      NULL,
      NULL,
      1.161611,
      NULL,
      0,
      NULL,
      1.255384,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.999376,
      3,
      0,
      0.441096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874496,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.271314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.525921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.914456,
      NULL,
      NULL,
      NULL,
      1.461641,
      NULL,
      1.375752,
      NULL,
      2.535675,
      NULL,
      2,
      NULL,
      242,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3,
      1,
      3,
      21.266300,
      40.720923,
      1.771346,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      3.893274,
      NULL,
      NULL,
      2,
      10.988190,
      1,
      1.208641,
      NULL,
      11,
      17,
      NULL,
      0.104135,
      NULL,
      NULL,
      12.950767,
      5,
      NULL,
      4,
      14,
      NULL,
      11.751501,
      11.033341,
      NULL,
      NULL,
      NULL,
      NULL,
      7.807810,
      3,
      NULL,
      15.612642,
      NULL,
      NULL,
      17.692321,
      9.716911,
      NULL,
      NULL,
      1.605835,
      NULL,
      15.306543,
      NULL,
      NULL,
      2.836428,
      0,
      0.560285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.942212,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0,
      2,
      9,
      NULL,
      2,
      1.321036,
      NULL,
      '34032',
      NULL,
      '42232',
      1,
      '',
      '',
      '',
      0.761270,
      '314',
      '',
      '');
commit;
end;
/


