set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '3200120',
      1.463200,
      1,
      NULL,
      2,
      '2114',
      1,
      1.495045,
      NULL,
      NULL,
      NULL,
      1.265369,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      309.074284,
      66.644239,
      3,
      ' 2-19-2000',
      ' 7-23-1983',
      ' 2- 8-1991',
      NULL,
      2,
      3.996532,
      3,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      24.029312,
      5,
      NULL,
      9,
      0,
      3,
      0,
      0,
      1,
      0.663226,
      0.104499,
      1,
      1.053099,
      NULL,
      NULL,
      2,
      5,
      NULL,
      NULL,
      1,
      1,
      0,
      4,
      5,
      1,
      NULL,
      3,
      4,
      0,
      3,
      5,
      8.055094,
      1,
      0,
      2,
      NULL,
      1.578124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      3.412768,
      0.647076,
      2,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.740947,
      1,
      1,
      1.061138,
      NULL,
      4,
      5,
      0,
      1,
      1,
      2.224281,
      0,
      NULL,
      NULL,
      0.295926,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      3,
      3,
      5,
      0,
      0,
      1,
      0,
      1,
      1,
      7,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      3,
      5,
      5,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      5,
      2,
      5,
      5,
      NULL,
      1.911069,
      ' 4-12-1987',
      369.716165,
      NULL,
      39.404309,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0.718260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.264955,
      2,
      NULL,
      1,
      NULL,
      5,
      7,
      4.563821,
      3.601299,
      1.807690,
      0.286055,
      NULL,
      NULL,
      NULL,
      2.942682,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      23.813163,
      0.110904,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.290269,
      1.276062,
      0,
      0,
      1,
      1,
      1,
      2,
      2,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.673892,
      1,
      0,
      NULL,
      1,
      1,
      1.280384,
      1,
      NULL,
      1.148372,
      0.699783,
      NULL,
      1,
      1.773638,
      0.598329,
      0,
      1.294521,
      7.874033,
      NULL,
      0.089894,
      8.018383,
      NULL,
      3,
      3.390386,
      NULL,
      NULL,
      0,
      1,
      24.979921,
      2,
      0.902298,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.071576,
      '34022',
      '',
      '',
      1.260263,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      0,
      14.783327,
      NULL,
      14,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108095,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.513141,
      NULL,
      NULL,
      0.889081,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.308253,
      NULL,
      NULL,
      1.168797,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.215296,
      NULL,
      NULL,
      1.426153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.578978,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.497434,
      NULL,
      NULL,
      0.287137,
      NULL,
      NULL,
      0.654893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.593753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.120754,
      NULL,
      NULL,
      0.258274,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.788438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886007,
      NULL,
      NULL,
      0.228639,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0.813068,
      3.426347,
      4.497285,
      5.942750,
      1.258410,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      2,
      2,
      2.269678,
      1,
      2,
      4,
      6,
      2,
      2,
      2.083527,
      0.765035,
      3,
      3.414047,
      1.557209,
      NULL,
      3.757404,
      3,
      0.738790,
      0.808219,
      4.320596,
      NULL,
      NULL,
      NULL,
      3,
      0.294520,
      1,
      NULL,
      NULL,
      0.933310,
      NULL,
      1.279129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742076,
      1,
      NULL,
      0,
      1.434907,
      1.363766,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.856336,
      3,
      0,
      3,
      NULL,
      NULL,
      1.495569,
      0.582835,
      NULL,
      NULL,
      1.166052,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      353,
      NULL,
      1,
      1,
      1,
      0.292412,
      0,
      NULL,
      0,
      1.347402,
      NULL,
      1.151874,
      0,
      0.465044,
      0.213850,
      1,
      1,
      1.873660,
      0,
      1.747132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      3.117501,
      1.045928,
      2,
      NULL,
      1,
      2.886062,
      0.946668,
      0,
      NULL,
      0,
      NULL,
      1.946890,
      1.600301,
      NULL,
      1,
      1.735252,
      NULL,
      1.028733,
      NULL,
      NULL,
      1.721918,
      NULL,
      NULL,
      0.224230,
      3,
      NULL,
      0.081022,
      0,
      NULL,
      1,
      1.247134,
      NULL,
      0.762610,
      NULL,
      NULL,
      3.446910,
      0,
      NULL,
      1,
      1.220941,
      NULL,
      NULL,
      1,
      0.695885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      20,
      39.215040,
      0,
      NULL,
      NULL,
      '41230',
      NULL,
      '',
      0.337467,
      NULL,
      NULL,
      '',
      0.660371,
      '',
      '',
      '');
commit;
end;
/


