set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1,
      1,
      NULL,
      0,
      1.518755,
      0,
      3.904393,
      '244',
      '31111121',
      21,
      66,
      '3321444',
      0.399036,
      NULL,
      6,
      2,
      '2110',
      NULL,
      1,
      NULL,
      NULL,
      ' 1-15-1986',
      150,
      61,
      NULL,
      2.132548,
      NULL,
      ' 2- 4-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2.533415,
      NULL,
      2,
      3.183069,
      1.525397,
      2.350775,
      1,
      1,
      NULL,
      4.150410,
      NULL,
      1.018931,
      3.697750,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      2.904679,
      0,
      0,
      5,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      5.738783,
      NULL,
      1,
      NULL,
      0,
      0.357446,
      NULL,
      NULL,
      1.194073,
      NULL,
      NULL,
      4,
      1,
      4.971854,
      NULL,
      1,
      0,
      1,
      2.363385,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      3.520247,
      0.881691,
      1,
      0,
      1,
      4,
      0,
      1,
      5,
      0,
      2,
      NULL,
      1.152133,
      NULL,
      NULL,
      1.096783,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      5,
      3,
      NULL,
      2,
      2,
      1,
      0,
      1,
      4,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      1,
      0,
      4,
      NULL,
      3,
      0,
      3,
      3,
      0,
      3,
      3,
      3,
      4,
      4,
      2,
      6,
      0.214694,
      ' 2-23-1998',
      24,
      ' 4-26-1980',
      41,
      2.368562,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.166380,
      NULL,
      3.380858,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      0.586165,
      4,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.687303,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716947,
      1,
      0.782300,
      1,
      1,
      0.814981,
      1.075533,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.787850,
      0.622999,
      NULL,
      2,
      NULL,
      3,
      0,
      2,
      2,
      2,
      0,
      3,
      1.311386,
      1.515952,
      2.758534,
      1,
      0.063646,
      1.293522,
      3,
      1,
      0,
      NULL,
      0,
      1,
      1.274593,
      0.388095,
      0.840194,
      0,
      1.788188,
      0,
      0,
      NULL,
      10.128408,
      6.914235,
      2,
      NULL,
      NULL,
      1.202145,
      3.866454,
      NULL,
      1,
      NULL,
      3.224900,
      50.538009,
      NULL,
      0.217064,
      53,
      NULL,
      NULL,
      NULL,
      5,
      3,
      2,
      '34441',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.911613,
      NULL,
      '',
      NULL,
      0,
      NULL,
      NULL,
      30.807067,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.277705,
      1,
      NULL,
      3,
      0,
      1,
      2.039651,
      0.248048,
      0,
      0,
      1.498099,
      0.879726,
      0,
      NULL,
      1,
      0,
      0,
      0.253865,
      2,
      1,
      1.187452,
      1,
      NULL,
      NULL,
      2,
      0.539730,
      1,
      0.100802,
      1.702608,
      1.027224,
      6,
      0.664106,
      1.520919,
      0,
      1.902833,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.593819,
      1.428640,
      1.605389,
      2,
      1.810765,
      1.024111,
      3.817404,
      NULL,
      NULL,
      3.695557,
      1.037996,
      NULL,
      1,
      1.804907,
      0.031617,
      NULL,
      2,
      0,
      2,
      NULL,
      0.231490,
      3.664192,
      3.799974,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.254411,
      1,
      1.608353,
      1.362622,
      10,
      NULL,
      0.275531,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.635354,
      1.112175,
      0,
      NULL,
      NULL,
      1.210786,
      1.544045,
      NULL,
      NULL,
      NULL,
      1,
      0.869382,
      NULL,
      NULL,
      NULL,
      3.655936,
      1,
      0.628201,
      1.620779,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.184056,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.737765,
      NULL,
      NULL,
      1.565907,
      NULL,
      NULL,
      3.644789,
      3,
      1.599545,
      1.080465,
      NULL,
      NULL,
      6,
      1.934895,
      3.423691,
      9.982841,
      1,
      1,
      8.163967,
      0.231107,
      NULL,
      3,
      0.213050,
      NULL,
      1.659819,
      NULL,
      3,
      3,
      3.199031,
      3.765803,
      3.686185,
      6,
      6.419124,
      2.585483,
      1.952931,
      3,
      NULL,
      NULL,
      2,
      1.724760,
      0,
      0,
      3,
      3.291982,
      0,
      8.806543,
      1,
      1,
      0.124358,
      3.454322,
      4,
      2.464254,
      NULL,
      1,
      1.088990,
      NULL,
      0.894359,
      0.130428,
      0.893303,
      NULL,
      NULL,
      NULL,
      0.739457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058973,
      NULL,
      NULL,
      1.572605,
      NULL,
      NULL,
      3.433228,
      NULL,
      NULL,
      0.259509,
      1,
      1,
      NULL,
      0,
      0.830319,
      2.509891,
      NULL,
      NULL,
      2,
      0.825672,
      NULL,
      NULL,
      29.376288,
      1.573890,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.593178,
      1.897171,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.150715,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.892676,
      0.404786,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.627006,
      NULL,
      NULL,
      1,
      1.323090,
      NULL,
      NULL,
      NULL,
      1.230804,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.440380,
      1.810786,
      NULL,
      NULL,
      7.706764,
      1.547867,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.284632,
      NULL,
      24,
      0.148789,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.956517,
      9.672996,
      NULL,
      NULL,
      1.009087,
      NULL,
      0,
      0,
      0,
      NULL,
      1.044996,
      1,
      NULL,
      0.081042,
      1,
      0.995835,
      0.091387,
      0.785720,
      1.870858,
      1.780259,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      2.216582,
      0,
      0,
      2.816543,
      1,
      7.950538,
      0.004674,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.367058,
      0,
      3.834247,
      3,
      1,
      1.171906,
      1.346407,
      2,
      2.641837,
      3,
      0,
      1.943532,
      3.032461,
      NULL,
      3.458359,
      3.900269,
      1.378605,
      3.498182,
      3,
      0.389206,
      2,
      0.125858,
      NULL,
      1,
      0.826444,
      0,
      2.650373,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539539,
      0,
      1.874481,
      0.578032,
      1.334018,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      64.356473,
      65.601849,
      1,
      3,
      1.589283,
      '33402',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.783300,
      '',
      '',
      '');
commit;
end;
/


