set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9716837';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.309631,
      0,
      4,
      0,
      1.115559,
      0,
      2.054405,
      0.395849,
      '034',
      '10040204',
      NULL,
      19.125683,
      '2224102',
      2.710277,
      0,
      0,
      0,
      '3300',
      5.146339,
      NULL,
      NULL,
      NULL,
      '11- 5-1991',
      136,
      NULL,
      NULL,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 3-21-2002',
      ' 4-11-1978',
      NULL,
      0,
      NULL,
      3.725177,
      2,
      0.113974,
      3,
      2,
      1,
      1.371056,
      37,
      2,
      0,
      9.471680,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      7,
      3,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      3,
      4,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      0,
      2.324794,
      3,
      0,
      0,
      3,
      NULL,
      1.241135,
      3,
      1,
      3,
      1,
      NULL,
      3.463601,
      0.276715,
      2.348106,
      1,
      3,
      3,
      0,
      5,
      NULL,
      0,
      0,
      3.774168,
      0,
      NULL,
      NULL,
      3.270555,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      4,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      0.251211,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      0,
      3,
      3,
      0,
      4,
      3,
      0,
      2,
      NULL,
      1,
      0,
      4,
      3,
      1,
      5,
      4,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      3.833842,
      ' 6-29-1980',
      958,
      ' 4-12-1996',
      724.264413,
      1,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.389984,
      0.150711,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.897592,
      NULL,
      NULL,
      NULL,
      0,
      1.704511,
      6,
      7,
      4.300306,
      0.871729,
      2,
      0.873118,
      2.047026,
      1,
      NULL,
      5,
      1,
      2,
      1,
      1,
      1.789222,
      NULL,
      2,
      NULL,
      0.641642,
      0,
      1,
      0.988424,
      1.727181,
      0.686727,
      NULL,
      2,
      0,
      1,
      1.773532,
      3,
      17.710042,
      3.296158,
      0.626276,
      NULL,
      NULL,
      NULL,
      2,
      1.018162,
      3,
      2,
      0,
      2,
      3,
      2,
      1,
      0,
      0,
      0,
      NULL,
      1.264432,
      2,
      2,
      4.873323,
      1.055228,
      0,
      6,
      NULL,
      1,
      0,
      1,
      NULL,
      1.322542,
      1.100080,
      1.866244,
      1,
      1.607695,
      0.468052,
      1,
      11.257104,
      11.265165,
      0,
      11.660384,
      NULL,
      5.263100,
      NULL,
      0.204224,
      5,
      NULL,
      NULL,
      3.646092,
      9.159273,
      2,
      3.386703,
      3,
      NULL,
      27,
      NULL,
      4,
      NULL,
      1,
      NULL,
      '',
      '',
      0.199772,
      '',
      '',
      '',
      3,
      '14202',
      '',
      '',
      NULL,
      17.058595,
      8.755511,
      32,
      2.018477,
      20,
      6,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      1,
      0.139355,
      NULL,
      NULL,
      0.292839,
      1,
      1.850954,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.495592,
      0,
      1,
      2,
      1,
      2,
      NULL,
      NULL,
      0.855200,
      3.730058,
      NULL,
      2.522044,
      8.892437,
      NULL,
      5.750148,
      0,
      0.638619,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666480,
      0,
      3.571591,
      2,
      2.592177,
      3.711877,
      3.672518,
      0,
      3.511881,
      2.409538,
      0,
      2.392297,
      1.816220,
      0.973077,
      NULL,
      0,
      0.987096,
      0.206529,
      NULL,
      0.347168,
      NULL,
      1.341014,
      1.021713,
      0,
      2.484141,
      1,
      2,
      0.020622,
      1,
      1,
      1.044050,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      6.213483,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.221072,
      0.745162,
      3.607550,
      1,
      NULL,
      NULL,
      0.715403,
      NULL,
      NULL,
      NULL,
      1.027993,
      1.543361,
      0.874823,
      1,
      0.270481,
      4.818937,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.214292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149681,
      1,
      1.740576,
      1.592127,
      NULL,
      NULL,
      2.155183,
      1,
      NULL,
      5.014337,
      4.370952,
      3.825637,
      1.410648,
      NULL,
      NULL,
      0,
      3.003100,
      2,
      1.831483,
      NULL,
      0.620143,
      1.855529,
      NULL,
      1,
      4,
      0.378909,
      1,
      NULL,
      0.293663,
      2.807247,
      3,
      0.650237,
      NULL,
      3,
      3.480693,
      2,
      0.705652,
      1.740152,
      NULL,
      5,
      3.084849,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      1.113892,
      0,
      NULL,
      1,
      0,
      2.809334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.926428,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.733818,
      NULL,
      NULL,
      1.649825,
      NULL,
      NULL,
      2,
      2.883891,
      NULL,
      0,
      1,
      2.501794,
      0.571310,
      NULL,
      1,
      2.746957,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      0.696563,
      2.426176,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.548530,
      NULL,
      NULL,
      0.790018,
      NULL,
      NULL,
      NULL,
      1,
      0.858880,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.916809,
      NULL,
      NULL,
      NULL,
      1.177273,
      1.104320,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1,
      3.367992,
      NULL,
      NULL,
      3.124464,
      0,
      NULL,
      NULL,
      1,
      2.565292,
      NULL,
      NULL,
      1,
      0.327114,
      NULL,
      NULL,
      12.129711,
      3.841894,
      NULL,
      NULL,
      1,
      1.615508,
      5.447192,
      0,
      4,
      NULL,
      NULL,
      9,
      3,
      25,
      6.870444,
      NULL,
      NULL,
      NULL,
      1.787051,
      29,
      2,
      0,
      NULL,
      NULL,
      1.773053,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437374,
      21,
      13.705908,
      0,
      2.388911,
      0,
      3,
      1.443626,
      NULL,
      0,
      1,
      0,
      0,
      1.961517,
      NULL,
      0,
      3,
      NULL,
      1,
      1.442612,
      3.470318,
      NULL,
      1.426377,
      NULL,
      2.837209,
      NULL,
      0,
      NULL,
      1.379158,
      NULL,
      3.167895,
      NULL,
      139.598113,
      NULL,
      3.726052,
      21,
      25.050020,
      0.153960,
      3,
      1,
      NULL,
      1.072572,
      NULL,
      0,
      NULL,
      0.707642,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.236441,
      NULL,
      0.079830,
      NULL,
      1.349504,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.176124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392716,
      1.749467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399571,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.143878,
      NULL,
      0.412450,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.510187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      767.037862,
      NULL,
      2.459936,
      NULL,
      0.065370,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.711787,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080100,
      1,
      1,
      NULL,
      1.984361,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.177102,
      1.912733,
      NULL,
      NULL,
      2.964216,
      NULL,
      2.524184,
      NULL,
      901.113148,
      NULL,
      3,
      NULL,
      0.105481,
      NULL,
      NULL,
      1.961874,
      1.105279,
      NULL,
      5,
      0.776211,
      1.753970,
      3.261164,
      3.390980,
      0,
      NULL,
      NULL,
      3.628574,
      1.808357,
      0.119160,
      2,
      NULL,
      6,
      0,
      3,
      1,
      1.035178,
      1.064079,
      NULL,
      1.459430,
      0.890342,
      NULL,
      1.308809,
      2,
      NULL,
      1,
      2.634962,
      NULL,
      0,
      0,
      NULL,
      1.046790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538288,
      1,
      NULL,
      0.212973,
      1,
      NULL,
      0.357886,
      0,
      NULL,
      0.165228,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      4,
      6,
      1.139291,
      1,
      1,
      NULL,
      62,
      0,
      0,
      3,
      '02344',
      '43243',
      '',
      NULL,
      '',
      '',
      '',
      2,
      '03214',
      '',
      '');
commit;
end;
/


