set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9630675';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.730260,
      0.176072,
      6.170837,
      NULL,
      NULL,
      2,
      3,
      0,
      '212',
      '04124100',
      20,
      67,
      '1114014',
      2.051621,
      0,
      0,
      3,
      '2412',
      3.233402,
      0,
      NULL,
      NULL,
      ' 7- 7-1998',
      10,
      6.032136,
      NULL,
      3.740096,
      0,
      ' 9-24-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 2- 2-2003',
      ' 5- 8-1983',
      ' 2- 0-2001',
      NULL,
      1.310380,
      2,
      1,
      NULL,
      1.758460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      3,
      0,
      1.214997,
      NULL,
      0,
      1,
      0.862279,
      1.816237,
      0.267225,
      0,
      1,
      0,
      1,
      3,
      3,
      1,
      4,
      1,
      4,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      5,
      2,
      1,
      1.884026,
      0.004437,
      NULL,
      NULL,
      0.917535,
      NULL,
      NULL,
      5,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      4,
      1,
      1,
      0,
      NULL,
      0.283308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      5,
      0,
      1,
      1,
      1,
      3,
      2,
      0,
      1,
      2,
      3,
      NULL,
      0,
      3,
      0,
      3,
      NULL,
      3,
      2,
      0,
      NULL,
      '10-11-1985',
      3,
      ' 5-29-1979',
      9,
      1.023051,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.771514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0,
      NULL,
      0.991950,
      2.138657,
      0,
      0,
      NULL,
      2,
      3,
      3.704451,
      4,
      NULL,
      1.682118,
      1.976072,
      0.337070,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.729044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.880238,
      0,
      2.875393,
      0,
      1.728288,
      1,
      NULL,
      7,
      0.567146,
      0.667694,
      NULL,
      NULL,
      NULL,
      0,
      1.018258,
      3,
      1,
      NULL,
      0,
      3,
      2,
      NULL,
      0,
      0,
      3,
      1,
      3.026028,
      2.513067,
      NULL,
      3,
      1,
      1,
      0.203060,
      0,
      1,
      1,
      0.713868,
      0.348783,
      0,
      NULL,
      1,
      0,
      2.531046,
      2.714031,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      36,
      NULL,
      22,
      36,
      0,
      2,
      7,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      27.057313,
      1.691873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.290515,
      1.674932,
      1,
      3,
      0,
      0,
      1.159107,
      NULL,
      NULL,
      3.182849,
      0,
      1.510059,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.364698,
      NULL,
      0.499905,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.270374,
      0.831360,
      0,
      NULL,
      NULL,
      NULL,
      1.905114,
      1.801076,
      1,
      0.718784,
      0.690112,
      0,
      1,
      0.176285,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      20.706205,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.264494,
      1.330883,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034750,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.027281,
      NULL,
      0.726212,
      NULL,
      1,
      NULL,
      0.288471,
      NULL,
      1.111069,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.448750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.621850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.378670,
      1.799987,
      2.392777,
      NULL,
      0.051499,
      NULL,
      65,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0.794573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354337,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.839136,
      NULL,
      1,
      NULL,
      2.270078,
      NULL,
      340,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      0,
      2.692743,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      2,
      NULL,
      0.417578,
      1.546173,
      0,
      0.880962,
      0.764003,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.973212,
      NULL,
      1,
      1.683372,
      NULL,
      1.736450,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.213810,
      NULL,
      NULL,
      1.467813,
      NULL,
      NULL,
      0.289597,
      1.789872,
      NULL,
      1,
      1.569835,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.917106,
      NULL,
      3,
      NULL,
      0.604052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0.904055,
      NULL,
      NULL,
      93.905093,
      NULL,
      2,
      NULL,
      0.414671,
      NULL,
      '20120',
      '01010',
      NULL,
      '',
      '',
      '',
      2.970075,
      '24224',
      '',
      '');
commit;
end;
/


