set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921975';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      1.658974,
      1,
      3,
      0,
      '2214',
      3.522701,
      NULL,
      2,
      12.803906,
      '10-11-1974',
      38,
      NULL,
      1,
      NULL,
      1.406584,
      NULL,
      7,
      1.107073,
      366.416620,
      37.526054,
      2,
      NULL,
      NULL,
      ' 3- 6-2001',
      0.471294,
      NULL,
      NULL,
      1.979070,
      NULL,
      NULL,
      3,
      1,
      0,
      30,
      5,
      NULL,
      3.764462,
      18,
      18.677556,
      4,
      18.986953,
      2,
      0,
      8,
      1,
      1,
      0,
      0.612584,
      1,
      NULL,
      1,
      0,
      1,
      0,
      124.761161,
      NULL,
      5,
      3,
      3,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      3,
      3,
      1,
      1.340347,
      2,
      0,
      0,
      1,
      0.121563,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      1,
      0,
      0.013403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      1.685692,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      4,
      1,
      NULL,
      2,
      1,
      1,
      NULL,
      4,
      NULL,
      5,
      3,
      2,
      NULL,
      0,
      4,
      NULL,
      1,
      1,
      NULL,
      0,
      5,
      1,
      '10-16-1991',
      209.587106,
      ' 4-17-1977',
      48,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      1.297832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959667,
      0,
      NULL,
      NULL,
      NULL,
      0.485090,
      9.640253,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.216813,
      1.773624,
      NULL,
      NULL,
      9.769624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232169,
      2,
      1,
      2,
      3,
      NULL,
      ' 6- 1-1988',
      NULL,
      ' 6- 4-1998',
      5.148159,
      NULL,
      1,
      1,
      NULL,
      1.051475,
      1.151230,
      3.508986,
      1,
      0,
      NULL,
      3.063972,
      230.090528,
      1.258812,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.983690,
      2,
      0,
      1,
      0,
      1,
      1,
      2,
      0,
      1,
      0,
      0,
      NULL,
      2,
      1.631115,
      NULL,
      0,
      1.839835,
      NULL,
      0,
      3,
      1,
      NULL,
      1,
      NULL,
      1,
      0.736369,
      NULL,
      3.980471,
      0,
      1,
      NULL,
      11,
      3,
      NULL,
      7,
      3,
      NULL,
      0.789374,
      2.847375,
      1.325906,
      3.485966,
      NULL,
      43.136318,
      1,
      1,
      NULL,
      18,
      33,
      NULL,
      2,
      1,
      NULL,
      '04432',
      '',
      '',
      1.134728,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      0.059783,
      NULL,
      164.902616,
      36.541626,
      1,
      37.789329,
      5.887594,
      40,
      5,
      0.186619,
      NULL,
      1.075715,
      NULL,
      1.037961,
      1.153194,
      NULL,
      NULL,
      NULL,
      3.691646,
      0,
      NULL,
      1.596725,
      NULL,
      NULL,
      3.048972,
      2.441028,
      1,
      2.841962,
      1.775599,
      0,
      2,
      0,
      0,
      1.513406,
      0.864131,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643532,
      2.763293,
      3.121828,
      0.725327,
      3.753504,
      2,
      3.813974,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.769289,
      1.376295,
      NULL,
      0,
      NULL,
      0.343971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.791912,
      0,
      2.720323,
      0.177898,
      1.324174,
      1.006091,
      1.944521,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.953654,
      0,
      0.035219,
      17,
      1.868766,
      NULL,
      NULL,
      1.852261,
      0.756514,
      1.287845,
      3.509278,
      1.033449,
      NULL,
      0.079819,
      1.690186,
      1,
      0.833368,
      3,
      1.398815,
      2,
      1,
      1.107419,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.724515,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.436963,
      4.257580,
      1,
      2,
      NULL,
      NULL,
      0.516839,
      NULL,
      1,
      0.747689,
      NULL,
      NULL,
      NULL,
      1.090666,
      NULL,
      6.410594,
      5,
      2.360217,
      NULL,
      0.469711,
      1,
      2.382229,
      1,
      0,
      1.229779,
      3.760040,
      1.756451,
      NULL,
      0.822927,
      0.148723,
      7,
      9,
      10.390623,
      1,
      NULL,
      NULL,
      2.958951,
      0.658269,
      0.358116,
      0.718152,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.277149,
      0.232589,
      1,
      4,
      0,
      0.161122,
      1.742756,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223467,
      NULL,
      3,
      0,
      NULL,
      3.379318,
      1.759737,
      5,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.151394,
      NULL,
      0.627705,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.245689,
      NULL,
      NULL,
      NULL,
      2.487668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.659481,
      NULL,
      1.514838,
      NULL,
      1.827637,
      NULL,
      0.215221,
      NULL,
      3.555666,
      NULL,
      NULL,
      NULL,
      0.814636,
      NULL,
      1,
      NULL,
      3.057203,
      NULL,
      1.285762,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.822346,
      NULL,
      1.708530,
      NULL,
      2.195389,
      NULL,
      2,
      NULL,
      13.503994,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      2.777994,
      NULL,
      3,
      NULL,
      5.719773,
      NULL,
      0,
      5,
      0,
      2,
      2.738850,
      40.993814,
      12,
      3.276391,
      19,
      0.155783,
      NULL,
      NULL,
      NULL,
      2.229600,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.528012,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.770933,
      NULL,
      1,
      1.188666,
      0,
      1,
      0,
      0.338642,
      1.557700,
      NULL,
      1,
      0.791943,
      0.844924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.009288,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      5.776386,
      6.723025,
      1,
      2,
      12.408651,
      3,
      2.536780,
      3.750194,
      1.423155,
      NULL,
      NULL,
      NULL,
      1.808367,
      3,
      1.334069,
      NULL,
      NULL,
      1,
      NULL,
      0.237231,
      NULL,
      3.339867,
      1.211975,
      NULL,
      1,
      0,
      NULL,
      0.420141,
      0.428045,
      0.255567,
      1,
      0.964399,
      2.100307,
      3,
      3.037390,
      0.793776,
      0,
      0.425138,
      0.441499,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.544897,
      0.406023,
      1,
      1.086350,
      2.719719,
      0.814205,
      NULL,
      3,
      0,
      0.705755,
      NULL,
      0.788886,
      1,
      NULL,
      0.751057,
      1,
      1,
      0.881565,
      0,
      1,
      0.907244,
      0.984477,
      0,
      2,
      1,
      NULL,
      NULL,
      30.620049,
      0,
      6,
      1.407711,
      1.763758,
      3.682362,
      1.807035,
      0.872410,
      0.000446,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3,
      34,
      15.455607,
      NULL,
      0,
      3,
      '23344',
      '',
      '',
      0.691750,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


