set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7323049';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '4403044',
      NULL,
      0.331033,
      3,
      3,
      '4341',
      2.231942,
      1.345712,
      NULL,
      NULL,
      ' 7- 1-1982',
      4.266630,
      NULL,
      1,
      3.973887,
      0.385762,
      '10- 1-2001',
      33,
      2.382824,
      94.847628,
      NULL,
      2,
      '11- 6-1990',
      NULL,
      ' 4-17-1983',
      2.728749,
      2,
      1.952139,
      1,
      0,
      0.435338,
      3,
      0,
      1.155310,
      105,
      NULL,
      15.204697,
      5.225503,
      27.414582,
      NULL,
      NULL,
      20,
      4,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      3,
      0,
      0,
      NULL,
      0,
      2,
      5,
      0,
      5,
      0,
      NULL,
      NULL,
      3.698501,
      0,
      1,
      0,
      0,
      1.041830,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      4,
      NULL,
      5,
      0,
      1,
      2,
      2,
      0,
      1,
      1,
      3,
      1,
      1,
      0,
      1,
      0,
      0.193790,
      ' 0-25-1997',
      855,
      '10- 4-1999',
      1086.944101,
      2,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.423608,
      NULL,
      1,
      NULL,
      0.364465,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682080,
      NULL,
      0,
      0.233491,
      NULL,
      1,
      1,
      NULL,
      23.924713,
      3,
      1.063111,
      4.083931,
      133,
      40,
      2,
      0.829650,
      NULL,
      1,
      1,
      2,
      2,
      1,
      2,
      NULL,
      0,
      2,
      0,
      NULL,
      1.288874,
      NULL,
      NULL,
      0.382323,
      0.602095,
      3.670759,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4.331728,
      3.536106,
      2,
      8.338534,
      11,
      5,
      5,
      0.103741,
      7,
      0.529340,
      1.670712,
      0,
      21.719132,
      0,
      2.472632,
      NULL,
      19,
      13,
      15,
      4,
      0,
      3,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.599832,
      49,
      80.435148,
      12.041195,
      2.042573,
      23,
      2,
      5,
      2,
      2.697906,
      0.383626,
      0.322786,
      0.169820,
      NULL,
      NULL,
      1.050442,
      NULL,
      NULL,
      2.893403,
      3.321908,
      3,
      1,
      NULL,
      NULL,
      2.506109,
      1,
      2,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.973236,
      3,
      2,
      0,
      NULL,
      NULL,
      2.881401,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.827240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867430,
      NULL,
      NULL,
      0.881971,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1.607390,
      0,
      0.224480,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.818882,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.838780,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.410505,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.045163,
      1.067918,
      NULL,
      0.146997,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      0,
      1,
      3.785741,
      0,
      NULL,
      4,
      7,
      2.783876,
      1.715602,
      0.428860,
      0.207785,
      3.532207,
      0.507783,
      3,
      3.123130,
      1,
      1,
      0.498222,
      1.018647,
      3.722587,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0.843087,
      1,
      NULL,
      0,
      1.389336,
      3.466698,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869766,
      NULL,
      NULL,
      1.408576,
      NULL,
      NULL,
      0.683529,
      NULL,
      NULL,
      0.259806,
      NULL,
      NULL,
      1.502391,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445540,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.345523,
      NULL,
      1.439935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.898030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.960142,
      NULL,
      NULL,
      NULL,
      1.836956,
      NULL,
      NULL,
      NULL,
      4.086673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.760661,
      126.504147,
      126.984314,
      2.911264,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      29,
      2,
      1,
      NULL,
      NULL,
      1.315946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1118,
      12,
      0,
      0,
      0.673757,
      0.329275,
      NULL,
      1,
      1.544670,
      1,
      1.505642,
      0.850921,
      0,
      0.100743,
      1,
      0,
      1.910306,
      0.180264,
      0,
      1,
      NULL,
      1.756826,
      NULL,
      1.889404,
      NULL,
      1,
      NULL,
      0.076836,
      NULL,
      NULL,
      NULL,
      49.899559,
      NULL,
      NULL,
      56,
      16.065421,
      0,
      0.227717,
      NULL,
      NULL,
      0.640222,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.447464,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.860091,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.189027,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.468437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.256683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398753,
      NULL,
      0.506306,
      NULL,
      0.424668,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.389896,
      NULL,
      0,
      NULL,
      0.244695,
      0.629654,
      NULL,
      NULL,
      0,
      NULL,
      1.112438,
      NULL,
      NULL,
      NULL,
      0,
      0.408453,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.616263,
      3,
      NULL,
      1.707630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.497605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.758061,
      3,
      3,
      7.029986,
      0,
      1.039102,
      0,
      NULL,
      0,
      NULL,
      0,
      3.862161,
      NULL,
      1.027771,
      NULL,
      NULL,
      NULL,
      1.093934,
      NULL,
      0.364163,
      1.473379,
      NULL,
      0,
      1,
      NULL,
      3,
      1.217376,
      NULL,
      1.951345,
      0.045444,
      NULL,
      NULL,
      0,
      NULL,
      0.466028,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.473810,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.756235,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.321244,
      NULL,
      2.440321,
      NULL,
      NULL,
      NULL,
      0.655733,
      NULL,
      3.458279,
      NULL,
      0.258549,
      NULL,
      2.288431,
      NULL,
      0,
      NULL,
      1.801431,
      NULL,
      NULL,
      NULL,
      41,
      0.874225,
      NULL,
      0,
      NULL,
      1.491451,
      NULL,
      1,
      NULL,
      4,
      3,
      4,
      1,
      0.906884,
      2.205925,
      34.141523,
      75,
      5,
      1.229529,
      5,
      '23001',
      '44212',
      NULL,
      1.227458,
      '',
      '',
      '',
      0.865787,
      '',
      '',
      '');
commit;
end;
/


