set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9776020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      1,
      NULL,
      2.642559,
      NULL,
      NULL,
      3,
      3.027442,
      '002',
      '22100234',
      NULL,
      17.149114,
      '3314123',
      1.855368,
      0.429169,
      3,
      2,
      '3414',
      2.181072,
      0.239486,
      NULL,
      NULL,
      ' 1-27-1978',
      93.630870,
      140.392903,
      NULL,
      NULL,
      5.353768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 5-15-1986',
      ' 2-29-1991',
      ' 5- 8-1997',
      NULL,
      3.147122,
      2.535891,
      0,
      1,
      NULL,
      NULL,
      0,
      1.451232,
      116,
      0,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7,
      0.833787,
      0,
      1,
      1,
      1,
      0,
      1,
      3,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.465511,
      NULL,
      NULL,
      2,
      0,
      1.823251,
      3.218731,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.390962,
      1,
      0,
      1,
      2,
      0.199001,
      3,
      2.011724,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0.841393,
      0.383738,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      5,
      3,
      0,
      5,
      1,
      0,
      2,
      1,
      0,
      0,
      5,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0.716379,
      NULL,
      NULL,
      3,
      1,
      5,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      4,
      0,
      5,
      NULL,
      2,
      2,
      4,
      3,
      2,
      0,
      1,
      4,
      1,
      ' 7- 9-1986',
      274,
      ' 4-23-1994',
      20,
      0.323720,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      19,
      0.102154,
      0.954383,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      1.802853,
      1,
      2.028652,
      0,
      NULL,
      NULL,
      NULL,
      1.793715,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.374756,
      NULL,
      0.779959,
      1,
      1.530827,
      1.637876,
      NULL,
      124.864627,
      3,
      1.414577,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.545124,
      1,
      1,
      3,
      0,
      0,
      0,
      NULL,
      0,
      2,
      1,
      0,
      0,
      1,
      7,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.113418,
      1.371661,
      1.817538,
      0.654446,
      NULL,
      NULL,
      0,
      3.316697,
      0,
      NULL,
      9,
      5.598515,
      3.689832,
      7,
      5,
      3,
      1,
      3.127119,
      3,
      2,
      1,
      22,
      NULL,
      3.245619,
      20,
      NULL,
      NULL,
      21.134351,
      2,
      4.707440,
      NULL,
      NULL,
      '31022',
      '',
      0,
      NULL,
      '',
      '',
      1.790070,
      '',
      '',
      '',
      3.596612,
      4.563446,
      70,
      67.275098,
      3.616998,
      84,
      NULL,
      1,
      3,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.630967,
      1.484763,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.087160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      3.730470,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.681093,
      3.396748,
      3,
      NULL,
      1.005034,
      0.786719,
      3.027551,
      2,
      1,
      2,
      1.726107,
      NULL,
      1.410556,
      0.164361,
      NULL,
      0.431551,
      2,
      1.534154,
      3,
      2,
      3.040880,
      2,
      3.850556,
      1,
      0.469652,
      NULL,
      NULL,
      NULL,
      1.649145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.144118,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248491,
      NULL,
      NULL,
      0.459085,
      NULL,
      NULL,
      3.041394,
      0.005842,
      0.648734,
      0,
      3.888567,
      3.099478,
      8.321054,
      0.137333,
      2,
      0.137236,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.050477,
      NULL,
      NULL,
      1.582287,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      1.408251,
      5.549631,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      0.732037,
      1,
      2.112858,
      0,
      0,
      3,
      2.620026,
      2.180894,
      NULL,
      7.086601,
      7,
      2,
      NULL,
      2,
      0.566669,
      NULL,
      3,
      1,
      2,
      1.282126,
      3.642876,
      1.738543,
      3,
      4,
      NULL,
      4.775226,
      4.013690,
      0.316635,
      NULL,
      3.479538,
      1,
      NULL,
      0,
      0,
      0,
      1.586111,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.206619,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.101627,
      1.226057,
      NULL,
      0.636743,
      0.424502,
      3.539940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.681527,
      NULL,
      NULL,
      NULL,
      1.859093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733153,
      NULL,
      NULL,
      NULL,
      1.682048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425534,
      3.013956,
      NULL,
      2.731393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.454262,
      NULL,
      1,
      1.518870,
      1.143477,
      1,
      1.584854,
      1,
      0.925548,
      1,
      NULL,
      0.239950,
      0.460551,
      1,
      NULL,
      0,
      1.492971,
      0,
      1.606602,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      3.562277,
      1,
      1.605379,
      2.995034,
      3,
      7.455058,
      NULL,
      3.900137,
      0.175841,
      NULL,
      1,
      NULL,
      0.438902,
      1.518947,
      NULL,
      1,
      0,
      NULL,
      1.712078,
      2,
      NULL,
      0.245437,
      2,
      NULL,
      3,
      0.233582,
      NULL,
      0.681834,
      0,
      NULL,
      NULL,
      3.003991,
      NULL,
      NULL,
      3.521481,
      NULL,
      2.488170,
      0.759759,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1.330889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.171524,
      NULL,
      3,
      NULL,
      3,
      0.725123,
      NULL,
      NULL,
      50.078584,
      NULL,
      NULL,
      1.602572,
      NULL,
      '40421',
      '01031',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


