set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9407664';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      '02',
      36,
      25.197071,
      NULL,
      3,
      1,
      5,
      NULL,
      '1320',
      4,
      0.176369,
      NULL,
      NULL,
      NULL,
      99.652379,
      68.911524,
      NULL,
      0.245379,
      3,
      ' 9-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11- 2-1983',
      ' 7-16-1994',
      NULL,
      3,
      1.059510,
      NULL,
      NULL,
      0.321454,
      1,
      2,
      3.234534,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      NULL,
      0.929375,
      NULL,
      0,
      1.113227,
      0.485550,
      NULL,
      0,
      2,
      1.850282,
      1,
      NULL,
      3,
      5,
      3,
      0,
      5,
      1,
      NULL,
      1,
      2,
      NULL,
      5,
      0,
      1,
      1,
      NULL,
      NULL,
      0.633165,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      5,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      3.008813,
      1,
      0,
      0,
      1,
      0.976266,
      NULL,
      0.638786,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      3,
      5,
      1,
      1,
      5,
      2,
      4,
      2,
      NULL,
      4,
      2,
      3,
      NULL,
      1.674591,
      ' 0- 5-1994',
      2.712037,
      '10- 7-1982',
      2,
      1.796257,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      4,
      NULL,
      1.947794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.229176,
      1.637689,
      0.307596,
      0.555137,
      1.768885,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.842216,
      NULL,
      0.547449,
      NULL,
      NULL,
      1,
      0,
      0.165272,
      21.901176,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.329720,
      2.411941,
      2,
      2,
      2,
      0,
      1,
      2,
      1,
      3,
      2,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      0.774019,
      0,
      NULL,
      0.519834,
      NULL,
      1.712587,
      NULL,
      1.079960,
      NULL,
      0.934303,
      0,
      0,
      1.220550,
      1.788960,
      7,
      5.860566,
      6,
      11.286431,
      9,
      NULL,
      4,
      1.851922,
      NULL,
      1.910471,
      1.254774,
      NULL,
      49,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      35,
      2,
      NULL,
      NULL,
      '12333',
      '23122',
      '03330',
      NULL,
      '00234',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      1,
      30,
      22,
      6,
      0,
      NULL,
      3.343702,
      1.616396,
      5,
      0,
      2.324216,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008223,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.646944,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.627017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869106,
      NULL,
      NULL,
      0.892209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441774,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.464439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224418,
      NULL,
      NULL,
      0.913888,
      3,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.450886,
      NULL,
      NULL,
      NULL,
      2.712061,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.329923,
      NULL,
      NULL,
      1.410531,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.651019,
      NULL,
      NULL,
      2.894747,
      2.478472,
      NULL,
      1,
      3.459854,
      0,
      0.979095,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.789376,
      1.371495,
      2.483806,
      1.930759,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.941442,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.585438,
      NULL,
      0.623321,
      3.910775,
      0,
      4,
      3,
      3.811497,
      NULL,
      3.445045,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0.916179,
      1,
      1,
      0.660648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.725340,
      2.235391,
      1.717421,
      1,
      1.717880,
      1.118049,
      0.908831,
      8.605451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.742717,
      NULL,
      NULL,
      NULL,
      1.618337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.425426,
      NULL,
      NULL,
      NULL,
      0.033124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.193872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.180189,
      NULL,
      NULL,
      NULL,
      0.510575,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.618563,
      1,
      0.133026,
      NULL,
      1,
      2.133005,
      0.738899,
      NULL,
      NULL,
      0.173462,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.240679,
      NULL,
      NULL,
      1.042851,
      NULL,
      0.225965,
      104,
      NULL,
      NULL,
      0.139856,
      1.433122,
      1.117580,
      0.294809,
      0.201438,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.693504,
      1.871430,
      1.347300,
      1.523752,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331858,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.420566,
      5,
      13.911059,
      0,
      1.991495,
      NULL,
      NULL,
      0.387002,
      NULL,
      0,
      NULL,
      0.083175,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.324406,
      NULL,
      0,
      NULL,
      1.997981,
      NULL,
      0.231945,
      NULL,
      1,
      NULL,
      1.605526,
      NULL,
      1.309913,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.239986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463755,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824384,
      0.282014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550505,
      0.948583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.552512,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      6,
      NULL,
      3.925567,
      NULL,
      0,
      NULL,
      0.037062,
      0,
      2.795908,
      32.802186,
      35,
      0.864312,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      5.891194,
      0.954116,
      NULL,
      3.154499,
      3,
      16.506947,
      3,
      0.149147,
      NULL,
      1.811098,
      0,
      1.230278,
      NULL,
      1,
      0.550751,
      1.094480,
      0.930483,
      NULL,
      1,
      1,
      NULL,
      3.199191,
      3,
      3.906102,
      3.488854,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      0.280098,
      0.644955,
      1,
      NULL,
      NULL,
      3,
      0.831864,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053825,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      4,
      4,
      3.880110,
      1.583450,
      1.784175,
      33.590270,
      61,
      4,
      0,
      NULL,
      '033',
      '12402',
      '13001',
      1.966198,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


