set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8134602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.060580,
      3.954992,
      0,
      2.271734,
      NULL,
      3.302116,
      5,
      2.057672,
      '112',
      '13410140',
      0,
      39.556320,
      '2104203',
      2.010614,
      1,
      2,
      0,
      '0231',
      0,
      0.613037,
      NULL,
      NULL,
      '11- 0-1976',
      2,
      5,
      NULL,
      0.985734,
      2.760634,
      ' 8-17-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 9-18-1980',
      ' 7-16-1999',
      ' 3- 0-1980',
      3,
      2.918439,
      3,
      2.289427,
      0,
      1,
      2,
      NULL,
      NULL,
      1.263581,
      8,
      14.515032,
      9.908348,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0.271020,
      0.487285,
      1,
      3,
      2,
      2,
      2,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      0,
      NULL,
      2.302528,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1.683848,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.940286,
      2.056943,
      3.834745,
      3.922225,
      1.126948,
      3,
      1.302759,
      1,
      1.985102,
      NULL,
      1,
      0,
      2.462086,
      2,
      1,
      0,
      0,
      6,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      4,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0.729113,
      NULL,
      1.940999,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      5,
      NULL,
      1,
      4,
      0,
      2,
      5,
      NULL,
      0,
      NULL,
      5,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      0.087441,
      ' 9-27-2001',
      654.217796,
      ' 8-26-1976',
      9.455243,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.189463,
      0.377907,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.445282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.958952,
      0.327807,
      1,
      1.635326,
      1,
      1.195843,
      NULL,
      0.348406,
      NULL,
      0.967129,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107561,
      2,
      2,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      3,
      3.041033,
      0,
      NULL,
      NULL,
      0.893145,
      1,
      7,
      NULL,
      0,
      1.289438,
      1,
      1,
      1,
      0.366293,
      0,
      NULL,
      0,
      1.531921,
      1.041774,
      9,
      7.702713,
      6,
      8.541400,
      3,
      4.166132,
      2.133167,
      2.604933,
      4,
      3,
      NULL,
      0,
      38,
      2,
      1.409320,
      47,
      NULL,
      17,
      79,
      2,
      0.822654,
      0,
      '22023',
      NULL,
      NULL,
      0.050234,
      '',
      NULL,
      '',
      1.684259,
      NULL,
      '',
      '',
      0,
      46.695455,
      80.319372,
      14.428825,
      1.706026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.926772,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.118315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500416,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.157228,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099827,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.255612,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.235160,
      0.226316,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.359084,
      1.491171,
      0.523393,
      NULL,
      NULL,
      NULL,
      0.349846,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.867629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.333926,
      1,
      3,
      0,
      NULL,
      NULL,
      2.337514,
      NULL,
      1,
      2,
      0.263803,
      2.336485,
      3,
      1.584890,
      1,
      3,
      1,
      2,
      3,
      0.909856,
      1.199066,
      NULL,
      0.732679,
      2.319455,
      2,
      NULL,
      NULL,
      2,
      NULL,
      3.664120,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631256,
      0.659793,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002162,
      1,
      0,
      NULL,
      0.921772,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735387,
      NULL,
      NULL,
      NULL,
      0,
      1.464761,
      1.557112,
      0,
      NULL,
      NULL,
      0.091150,
      NULL,
      NULL,
      0.570336,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.129057,
      NULL,
      NULL,
      1,
      NULL,
      1,
      657.953201,
      5,
      1,
      0,
      0.451661,
      0.248513,
      NULL,
      0,
      1.681374,
      1.195612,
      NULL,
      1,
      0,
      1,
      1.589577,
      0.290697,
      0,
      1,
      0.074712,
      0.867883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378618,
      0.101486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762527,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340021,
      1.690720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.366846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.513511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.467455,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      2,
      1,
      1,
      2,
      3,
      1,
      1.036457,
      1.211280,
      NULL,
      NULL,
      0.648903,
      NULL,
      NULL,
      0,
      NULL,
      1.700075,
      3.129501,
      NULL,
      1,
      0,
      NULL,
      0.092859,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.149508,
      NULL,
      0.512126,
      0.932345,
      NULL,
      1,
      0.404976,
      NULL,
      0.785870,
      0.390694,
      NULL,
      NULL,
      0,
      NULL,
      2.345688,
      1.243903,
      1.061866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152613,
      NULL,
      1.411873,
      NULL,
      0.383316,
      NULL,
      1,
      5,
      5,
      0,
      NULL,
      NULL,
      NULL,
      51,
      NULL,
      1,
      3.796391,
      '04022',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


