set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      NULL,
      43,
      41.941195,
      '4432243',
      1.949268,
      NULL,
      NULL,
      2,
      NULL,
      4.701593,
      1,
      NULL,
      NULL,
      ' 4-14-1986',
      NULL,
      12.657736,
      NULL,
      NULL,
      1.489369,
      '10- 4-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 8- 8-1977',
      ' 9-29-1976',
      ' 8-24-1997',
      0,
      3,
      2.276801,
      2,
      0,
      NULL,
      0,
      0.610638,
      1,
      4,
      NULL,
      5.638550,
      0.190493,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      0.308891,
      1,
      0,
      0.816799,
      1,
      1,
      0.215482,
      0.026048,
      1,
      1,
      1,
      NULL,
      4,
      0,
      1,
      0,
      NULL,
      5,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      4.584811,
      NULL,
      0,
      1.348469,
      2,
      2,
      NULL,
      0,
      0,
      1.697197,
      NULL,
      2,
      0.676557,
      1.193101,
      2,
      1.579314,
      3,
      2,
      NULL,
      4,
      6,
      1,
      NULL,
      1.918195,
      NULL,
      NULL,
      NULL,
      0.261044,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      4,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      0.711599,
      1,
      0,
      1,
      0,
      0.571375,
      NULL,
      1.095055,
      4,
      1,
      2,
      5,
      1,
      4,
      2,
      0,
      0,
      5,
      2,
      NULL,
      5,
      0,
      5,
      NULL,
      3,
      2,
      NULL,
      1,
      5,
      3,
      4,
      2,
      2,
      0,
      1.815987,
      '10-20-1985',
      64,
      ' 4-28-1989',
      32,
      0,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      3.815469,
      1.279661,
      1,
      1.635726,
      2.292148,
      8.920472,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      7.138396,
      0.125827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.738896,
      0.533711,
      0.836922,
      1.241370,
      1.623171,
      0.585975,
      0,
      2.940034,
      47,
      0.768078,
      1.838979,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      1,
      0,
      3,
      1,
      0,
      0,
      0,
      0,
      2,
      3.448466,
      0.895037,
      1,
      NULL,
      NULL,
      1,
      7.091277,
      0.005473,
      0,
      1,
      0,
      0,
      1.634924,
      1,
      1,
      0,
      1,
      1,
      1.686195,
      2.475734,
      2,
      6.527944,
      4.330101,
      NULL,
      NULL,
      4,
      2.520600,
      5,
      NULL,
      3,
      1,
      14.272246,
      0,
      0,
      35,
      NULL,
      25,
      NULL,
      5,
      3,
      0.212511,
      '44324',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.971775,
      '',
      '',
      NULL,
      0.848174,
      NULL,
      NULL,
      NULL,
      1.138944,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.539365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.827631,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      0.853243,
      3,
      0,
      NULL,
      NULL,
      1.099669,
      1.272127,
      0.768473,
      1.597346,
      1,
      3,
      3,
      0.049925,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      2.231113,
      3,
      3,
      NULL,
      1.931294,
      1.047080,
      2,
      2,
      0.512857,
      0,
      1.240292,
      0.968541,
      3.269954,
      1,
      0.125415,
      1,
      NULL,
      1.878319,
      3.600307,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      3,
      3.803962,
      1.367995,
      8.547061,
      NULL,
      0,
      1,
      0.315511,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.099448,
      NULL,
      NULL,
      0.689995,
      5.942179,
      4.837167,
      1.213416,
      NULL,
      NULL,
      0.651894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.089090,
      NULL,
      NULL,
      1.838010,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.743319,
      NULL,
      NULL,
      7.105947,
      5,
      1.822910,
      0.707412,
      NULL,
      4.618482,
      NULL,
      NULL,
      NULL,
      0.336838,
      0.961054,
      3,
      1,
      NULL,
      2,
      NULL,
      3.617048,
      0,
      8.968657,
      0,
      5.224207,
      2,
      NULL,
      NULL,
      3.561148,
      1,
      1.925949,
      1,
      3,
      3,
      0.966771,
      0,
      NULL,
      NULL,
      NULL,
      7,
      2.022810,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.596822,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026166,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.696429,
      0.222511,
      0.838008,
      0.020453,
      NULL,
      2.381203,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.857231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.252483,
      NULL,
      NULL,
      NULL,
      1.117420,
      NULL,
      NULL,
      NULL,
      0.277693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.177054,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      3.912422,
      3,
      1,
      0,
      3.709342,
      2.851440,
      0.663999,
      0.138469,
      NULL,
      NULL,
      1.732034,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392755,
      NULL,
      0.287943,
      NULL,
      4.360617,
      0.161457,
      NULL,
      1.987161,
      1.570806,
      1,
      2,
      0.103934,
      NULL,
      0.491148,
      0,
      0.468702,
      3,
      NULL,
      0.309890,
      0.662855,
      1,
      0.627463,
      1.587486,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.292418,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      46,
      NULL,
      NULL,
      13,
      23,
      2.936523,
      3.454453,
      2,
      NULL,
      0.384779,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.786337,
      NULL,
      NULL,
      NULL,
      0.507672,
      NULL,
      0,
      NULL,
      NULL,
      1.887394,
      1.954283,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820471,
      NULL,
      1.801673,
      NULL,
      0.382421,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.731299,
      NULL,
      0.516173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.507773,
      NULL,
      NULL,
      NULL,
      71.609272,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.017431,
      NULL,
      NULL,
      NULL,
      1.204343,
      0,
      2.007524,
      1.354048,
      0,
      1.412953,
      NULL,
      NULL,
      NULL,
      1,
      3.492952,
      1.453668,
      0.200832,
      1.805280,
      0.377557,
      0.400375,
      1.373535,
      13.853923,
      32,
      1.728772,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      3,
      3,
      NULL,
      9,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.935313,
      3,
      NULL,
      1,
      2.488921,
      NULL,
      1.950230,
      0.826287,
      NULL,
      NULL,
      0.401749,
      NULL,
      1.410732,
      1,
      NULL,
      0,
      0.576200,
      NULL,
      0.108865,
      0.921511,
      NULL,
      0.233304,
      0,
      NULL,
      3.556812,
      3,
      NULL,
      1.101692,
      NULL,
      NULL,
      NULL,
      0.970651,
      0.044863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781836,
      NULL,
      NULL,
      NULL,
      0.302224,
      NULL,
      3,
      5,
      7,
      0.729564,
      NULL,
      NULL,
      78.404857,
      NULL,
      NULL,
      2,
      7,
      '33320',
      '21210',
      '40032',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


