set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '0334330',
      3,
      1.295888,
      5,
      NULL,
      '2330',
      2.834426,
      0.663958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      ' 8- 2-1999',
      42.253108,
      5,
      332,
      NULL,
      0,
      ' 7- 8-1993',
      ' 8-15-2000',
      ' 9-11-1999',
      2.703014,
      0.666395,
      NULL,
      3.662017,
      0.183466,
      0.757938,
      2,
      1.456230,
      1,
      19.894906,
      3,
      NULL,
      1.247018,
      33,
      NULL,
      0,
      8,
      4,
      NULL,
      7,
      1.219411,
      0,
      3,
      1,
      1,
      NULL,
      1,
      0.932489,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      3,
      2,
      5,
      1,
      NULL,
      NULL,
      2,
      2,
      4,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      11.469895,
      2.938475,
      NULL,
      NULL,
      1,
      NULL,
      1.275958,
      NULL,
      0.329618,
      3,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.758523,
      0.939209,
      5,
      1,
      1,
      NULL,
      0,
      0,
      1.378148,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.563520,
      NULL,
      0,
      3,
      1,
      1,
      0,
      3,
      2,
      1,
      1,
      1,
      0,
      1,
      2,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      5,
      2,
      2,
      1,
      ' 2-26-1981',
      236,
      ' 0- 8-1974',
      8.795366,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.925759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.807277,
      0,
      1.882098,
      NULL,
      3,
      5,
      3.727782,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604123,
      8.732646,
      1,
      1,
      8,
      1.774509,
      NULL,
      NULL,
      NULL,
      1.234296,
      2,
      1.554114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.816312,
      1,
      0,
      NULL,
      0,
      35,
      1.621239,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      0.728110,
      NULL,
      2.188224,
      0.054057,
      1,
      1,
      NULL,
      1,
      0.703893,
      0,
      0,
      1.949818,
      1,
      0,
      1,
      1.663868,
      3,
      0,
      0,
      10,
      NULL,
      3.363867,
      2,
      3,
      5.072150,
      3.155826,
      5,
      1.122426,
      1.442583,
      2,
      21.412682,
      2,
      1.613676,
      NULL,
      NULL,
      31,
      14.667510,
      5,
      1.030764,
      0,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      0.394006,
      '',
      NULL,
      '',
      2,
      1.318402,
      211.453641,
      22,
      0.924305,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.448310,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.536261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.212926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.113553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.061804,
      0.558903,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.740974,
      3,
      0.354458,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769389,
      NULL,
      NULL,
      1.876863,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.224409,
      NULL,
      NULL,
      0.793465,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.795349,
      1.992488,
      3.881704,
      0.624208,
      0.383702,
      0,
      6,
      0.742965,
      0.706116,
      6.778388,
      NULL,
      1.330130,
      2,
      NULL,
      NULL,
      3.770239,
      0,
      NULL,
      1,
      1.854243,
      3,
      1.081782,
      2,
      NULL,
      4.688305,
      1,
      3,
      3.769122,
      3,
      1,
      0,
      NULL,
      NULL,
      3,
      1.708740,
      1.781987,
      0,
      NULL,
      1,
      7.876055,
      2.518410,
      NULL,
      2,
      7.355968,
      4.951535,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.480147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.526756,
      3.121276,
      1,
      1,
      0.185676,
      2.034733,
      NULL,
      NULL,
      NULL,
      29.129445,
      NULL,
      NULL,
      NULL,
      1.218084,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.713802,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.674017,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.619679,
      NULL,
      NULL,
      NULL,
      1.654849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.235869,
      NULL,
      NULL,
      NULL,
      2.540817,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707812,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      1.182622,
      NULL,
      0.894021,
      NULL,
      NULL,
      NULL,
      1.291761,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901770,
      NULL,
      NULL,
      0,
      NULL,
      0,
      135.316399,
      1.878287,
      NULL,
      0,
      0,
      1.372947,
      NULL,
      3.581130,
      1.386288,
      1,
      1,
      0.201808,
      0.700683,
      1.487056,
      0,
      NULL,
      0,
      NULL,
      0.015085,
      2,
      NULL,
      0.565193,
      NULL,
      2.594646,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.520687,
      NULL,
      88,
      NULL,
      0.369839,
      4,
      35,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746198,
      NULL,
      1.120193,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.306648,
      NULL,
      1.034306,
      2.670284,
      1.431805,
      1.482776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.576901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382364,
      1.248533,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.425417,
      NULL,
      0.993395,
      NULL,
      1,
      NULL,
      0,
      1.729414,
      3.411846,
      NULL,
      0.375421,
      NULL,
      0.767634,
      NULL,
      NULL,
      NULL,
      0.970538,
      NULL,
      0.499762,
      NULL,
      0.798613,
      NULL,
      1,
      0.783404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599561,
      0.777071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      297,
      NULL,
      3.810835,
      NULL,
      NULL,
      NULL,
      1.977836,
      1,
      3,
      NULL,
      17.090227,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      4,
      NULL,
      3.335228,
      2,
      7.924426,
      2.676412,
      2.220276,
      NULL,
      NULL,
      3.396900,
      NULL,
      0,
      1.517739,
      NULL,
      1.478611,
      NULL,
      2.027258,
      NULL,
      1,
      0,
      3.202433,
      1,
      1,
      0.437373,
      0.452896,
      NULL,
      1,
      1,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.154988,
      1.840408,
      0.146612,
      NULL,
      1,
      2.040549,
      3,
      2.941572,
      3.085972,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.977125,
      NULL,
      NULL,
      0,
      1.816829,
      2,
      1,
      5,
      NULL,
      NULL,
      NULL,
      10.893024,
      28,
      5,
      2.770006,
      7,
      NULL,
      '41201',
      '22200',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


