set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9136650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      2.960969,
      1,
      NULL,
      NULL,
      ' 4-28-1991',
      17.214948,
      NULL,
      4,
      NULL,
      6.957558,
      ' 0- 7-1996',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-13-1987',
      ' 8-25-1999',
      NULL,
      2,
      2.405070,
      3.549449,
      1.372972,
      1,
      0.492454,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.419188,
      NULL,
      NULL,
      23.154489,
      1,
      NULL,
      2,
      3,
      6.842798,
      1,
      3,
      1,
      0.277360,
      1.683337,
      0.323426,
      0.364130,
      0,
      4,
      0.152033,
      0.338927,
      0,
      0,
      0,
      2.685876,
      1,
      0,
      3,
      NULL,
      1,
      0,
      2,
      3,
      NULL,
      2,
      2,
      NULL,
      2.347713,
      0,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      0.091710,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.760655,
      NULL,
      0,
      2.348866,
      3,
      2.380417,
      1.984176,
      3,
      1.033523,
      0.746751,
      NULL,
      2,
      0,
      NULL,
      0,
      3,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      1,
      1,
      4,
      0,
      NULL,
      0,
      3,
      0,
      0,
      1,
      1,
      0.286471,
      1,
      0,
      0,
      1,
      1.670702,
      NULL,
      1,
      1,
      3,
      NULL,
      2,
      1,
      1,
      2,
      NULL,
      2,
      0,
      5,
      5,
      1,
      4,
      0,
      2,
      1,
      2,
      0,
      3,
      0,
      1,
      5,
      NULL,
      3,
      4,
      NULL,
      ' 2- 5-1981',
      1407.470163,
      ' 0-19-1999',
      1370,
      0.480292,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1730.815292,
      1,
      2.149568,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403062,
      1,
      NULL,
      1,
      6,
      2,
      2.536094,
      0.822249,
      NULL,
      NULL,
      0,
      3.986993,
      1.928182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674121,
      0.762913,
      1.149179,
      1,
      1.459955,
      NULL,
      1.258392,
      24,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480666,
      3,
      1,
      3,
      1,
      2,
      NULL,
      3,
      3,
      NULL,
      2,
      3,
      NULL,
      1.988605,
      NULL,
      0,
      1,
      0.267331,
      0.780983,
      NULL,
      2,
      1.049809,
      0,
      0,
      1,
      NULL,
      1.868418,
      1,
      0.605318,
      NULL,
      1.033480,
      NULL,
      NULL,
      NULL,
      4,
      0.699890,
      4.675129,
      5,
      3.708539,
      4.812227,
      3.791794,
      1,
      3.712660,
      64,
      3,
      2,
      NULL,
      32,
      6,
      0,
      5,
      0.115319,
      3.306465,
      NULL,
      '42214',
      '00212',
      0.322366,
      NULL,
      '',
      '',
      0.596082,
      '',
      '',
      '',
      3,
      25.306957,
      107.347730,
      NULL,
      0.209980,
      NULL,
      NULL,
      NULL,
      NULL,
      0.251611,
      0.311672,
      3.917675,
      0.900218,
      NULL,
      NULL,
      2,
      0.244622,
      0.200606,
      1,
      1.354225,
      2.202508,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.544231,
      2.638639,
      1,
      0.085321,
      NULL,
      NULL,
      0,
      0.361032,
      1.625440,
      NULL,
      0.332140,
      2.294774,
      0.108306,
      0.823280,
      0.986336,
      0,
      NULL,
      3,
      4.015010,
      NULL,
      1,
      1.070100,
      NULL,
      NULL,
      NULL,
      NULL,
      3.380128,
      3.234940,
      NULL,
      3.216925,
      1.214877,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.325651,
      0,
      0.330987,
      3,
      NULL,
      2,
      1.589304,
      0.941206,
      1.137836,
      NULL,
      0.241556,
      1,
      NULL,
      3.306044,
      3,
      NULL,
      1.640062,
      1.105045,
      1.626213,
      1.673017,
      NULL,
      NULL,
      1.133808,
      2,
      3.775863,
      2,
      0,
      6,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.131444,
      2,
      2.288309,
      0.136845,
      NULL,
      NULL,
      NULL,
      1.190308,
      NULL,
      NULL,
      0.680114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.521394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.272624,
      NULL,
      NULL,
      0.727502,
      NULL,
      NULL,
      0.769030,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.686305,
      NULL,
      NULL,
      1.144264,
      2,
      1.638813,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0.573426,
      NULL,
      1.028431,
      4,
      NULL,
      0,
      3.566864,
      0,
      0.406852,
      1.107675,
      NULL,
      NULL,
      0.934872,
      NULL,
      NULL,
      NULL,
      1.090638,
      1,
      0,
      0.229504,
      0,
      NULL,
      0.749128,
      3.823692,
      2,
      2,
      1.046386,
      1,
      1,
      NULL,
      5.741678,
      2,
      2,
      1,
      NULL,
      NULL,
      3.960349,
      1,
      2,
      NULL,
      0.690188,
      1,
      1,
      1.790147,
      1.943911,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351786,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.677680,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371471,
      1.628330,
      1.922296,
      2,
      NULL,
      1,
      1,
      8.181065,
      3,
      0.816798,
      NULL,
      81.237369,
      4,
      549,
      NULL,
      0.821359,
      0,
      NULL,
      NULL,
      2,
      3.660064,
      0,
      NULL,
      2.717865,
      3.827210,
      1,
      NULL,
      0.783531,
      NULL,
      NULL,
      NULL,
      3,
      2.917050,
      NULL,
      NULL,
      NULL,
      3,
      0.118382,
      NULL,
      3,
      1,
      NULL,
      NULL,
      3.133681,
      3.127708,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.436604,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990110,
      1.078718,
      NULL,
      1,
      1.706498,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.431500,
      NULL,
      1,
      NULL,
      1,
      3.806305,
      2.897284,
      NULL,
      1,
      1.980499,
      2.430198,
      NULL,
      1.223019,
      0.935389,
      1,
      NULL,
      3,
      6,
      NULL,
      NULL,
      3.943204,
      2,
      0,
      5.256896,
      6,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.563519,
      NULL,
      NULL,
      1.236742,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.969623,
      1462.563281,
      NULL,
      0.350922,
      1.196454,
      NULL,
      1.831172,
      0,
      3.975268,
      0,
      0,
      0.050991,
      1.455350,
      NULL,
      NULL,
      NULL,
      0.111837,
      1,
      NULL,
      1,
      2.986719,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.716221,
      NULL,
      0.397001,
      NULL,
      1,
      NULL,
      1.453029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.201302,
      0.744844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085406,
      0.607555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356656,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.773721,
      NULL,
      2,
      NULL,
      391.445780,
      NULL,
      1,
      1.396066,
      2,
      0,
      1,
      1,
      1.051935,
      0.225216,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398982,
      1.818095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.833890,
      NULL,
      3.046535,
      NULL,
      1.116749,
      NULL,
      182,
      NULL,
      3.746110,
      NULL,
      0.350053,
      NULL,
      2.313869,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608391,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      7.121011,
      NULL,
      0,
      5,
      0,
      5,
      NULL,
      0.072217,
      1,
      3,
      NULL,
      NULL,
      0.012233,
      1,
      NULL,
      2.536173,
      2.818478,
      NULL,
      1,
      NULL,
      NULL,
      3.005144,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.080711,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.787666,
      NULL,
      2,
      0.669760,
      NULL,
      1,
      0,
      NULL,
      2.722385,
      1.536740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      2.037842,
      NULL,
      2,
      NULL,
      1.730645,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118830,
      NULL,
      1.036695,
      NULL,
      1,
      NULL,
      12.665468,
      3.782566,
      NULL,
      1.246543,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      6,
      6,
      0,
      NULL,
      NULL,
      43,
      130.072040,
      NULL,
      0,
      5.716634,
      '33231',
      '02002',
      '22424',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


