set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517294';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '0103100',
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      15.928761,
      NULL,
      1,
      0,
      2,
      ' 2-17-1981',
      NULL,
      0.342334,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '10- 5-1993',
      1.602299,
      0,
      1.763085,
      3,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      6,
      3.226348,
      41,
      15,
      1,
      30,
      0,
      1,
      1.631285,
      0,
      0,
      0,
      0.107837,
      1,
      0,
      0,
      0.676089,
      0.890204,
      3.261033,
      0,
      0,
      2,
      5,
      NULL,
      3,
      1,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      3.959083,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.836687,
      1.003246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      2,
      4,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      0,
      0,
      1,
      0.355609,
      NULL,
      1,
      3,
      5,
      0,
      5,
      NULL,
      0,
      3,
      4,
      NULL,
      2,
      1,
      5,
      NULL,
      1,
      0,
      3,
      4,
      1,
      NULL,
      0,
      5,
      NULL,
      5,
      4,
      1,
      2,
      0,
      ' 5-21-2000',
      20,
      NULL,
      38.998948,
      1.066723,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.981849,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.088245,
      0.778488,
      0.315210,
      7.900312,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.313657,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.733126,
      0.186863,
      0,
      1.693738,
      1.283735,
      1.111628,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.369185,
      2,
      2,
      3,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      NULL,
      1,
      2,
      0,
      1.910886,
      0,
      4,
      0,
      1,
      0.899317,
      0,
      1.871568,
      0.623897,
      NULL,
      1,
      0,
      2,
      0.194017,
      0.397788,
      6,
      0,
      0,
      NULL,
      9.441204,
      2.993732,
      NULL,
      3,
      NULL,
      0.319217,
      NULL,
      3.370651,
      40.336769,
      2,
      NULL,
      35,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.862768,
      '44444',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      6,
      6,
      3,
      1.715014,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.837133,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.567797,
      1.093215,
      0.019480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.508914,
      NULL,
      NULL,
      3.650757,
      3.662130,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.598380,
      NULL,
      NULL,
      0.821642,
      NULL,
      NULL,
      1.633708,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752839,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.350499,
      NULL,
      NULL,
      1.424557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372501,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558032,
      NULL,
      NULL,
      1,
      0.944071,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3.034563,
      0,
      NULL,
      NULL,
      1.314588,
      NULL,
      NULL,
      1.105048,
      NULL,
      NULL,
      0.161449,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.017020,
      NULL,
      NULL,
      1.106482,
      1,
      0,
      NULL,
      1.884518,
      2.977643,
      4.012300,
      NULL,
      4,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3.357237,
      0,
      3,
      1,
      4,
      4.534669,
      1.252421,
      NULL,
      3.359059,
      3,
      NULL,
      0.916929,
      3.281570,
      3,
      NULL,
      0,
      1,
      0.424261,
      2.933198,
      NULL,
      5.046531,
      1.762419,
      2,
      5,
      3,
      3.306622,
      NULL,
      2,
      1,
      1,
      0,
      1.462101,
      NULL,
      1,
      NULL,
      NULL,
      0.891842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344364,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.493598,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      3.055756,
      NULL,
      NULL,
      NULL,
      2.136457,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.913660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136804,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.180026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      51,
      0,
      NULL,
      1,
      NULL,
      1,
      0.361414,
      0,
      0.202590,
      0.774720,
      0,
      0.235303,
      0,
      NULL,
      0,
      1.312144,
      NULL,
      1.467044,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638338,
      0.336755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483749,
      2,
      NULL,
      0.741459,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212884,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.798475,
      NULL,
      1.778253,
      NULL,
      0,
      1.271195,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0.732304,
      3.314277,
      0,
      0,
      0,
      3.257009,
      0.247664,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.111466,
      0,
      NULL,
      1,
      3,
      NULL,
      1.830047,
      0,
      NULL,
      0,
      3.579967,
      NULL,
      0.923459,
      3.377298,
      NULL,
      0.394538,
      2.537537,
      NULL,
      0.693888,
      0.367647,
      NULL,
      0,
      1.733374,
      NULL,
      1,
      0.544643,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.899975,
      NULL,
      NULL,
      NULL,
      57,
      1,
      2.413371,
      2,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      0.904128,
      '',
      '',
      '');
commit;
end;
/


