set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03',
      '13',
      9.363985,
      NULL,
      '0320234',
      0,
      0,
      0,
      NULL,
      '2421',
      NULL,
      0,
      NULL,
      NULL,
      ' 6- 3-1996',
      NULL,
      NULL,
      NULL,
      2.341247,
      0.876348,
      ' 2- 4-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-27-1983',
      ' 2- 1-1980',
      ' 3-14-1992',
      NULL,
      NULL,
      NULL,
      3.134817,
      1.022943,
      0,
      NULL,
      0.513274,
      1.459039,
      NULL,
      0,
      NULL,
      7.523961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.298542,
      2,
      1,
      0,
      0.152479,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3,
      4,
      NULL,
      3,
      NULL,
      0,
      0,
      2,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.451177,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      0,
      1,
      0.053350,
      3.056298,
      3,
      0,
      1.093037,
      NULL,
      0.821622,
      1,
      NULL,
      1.928299,
      0.652885,
      1,
      NULL,
      NULL,
      NULL,
      0,
      8.234714,
      NULL,
      1,
      1.621765,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1.081910,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      2,
      0,
      1,
      0,
      NULL,
      0,
      4,
      5,
      0,
      NULL,
      1,
      0,
      5,
      2,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      162,
      NULL,
      5.825195,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.253722,
      1,
      NULL,
      NULL,
      2,
      4,
      2,
      1.570572,
      NULL,
      NULL,
      NULL,
      0,
      5,
      6,
      NULL,
      0,
      3.583843,
      0.766819,
      NULL,
      NULL,
      NULL,
      0,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.371239,
      0,
      NULL,
      1.661933,
      1,
      0,
      NULL,
      2,
      NULL,
      2.327721,
      0.702996,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      3,
      3,
      1,
      0,
      2,
      1,
      NULL,
      2,
      3,
      0.744468,
      NULL,
      NULL,
      0.974951,
      NULL,
      0,
      NULL,
      NULL,
      0.466867,
      1.366403,
      1.598092,
      1.789223,
      0,
      NULL,
      0,
      1.721407,
      1,
      1.110473,
      6,
      8.944892,
      1.638692,
      3,
      9,
      NULL,
      NULL,
      0,
      4.982853,
      1,
      NULL,
      1,
      0.956706,
      0,
      0,
      26,
      NULL,
      5,
      31.385531,
      NULL,
      2,
      0.063012,
      '22042',
      '',
      '',
      0.397362,
      '',
      '',
      '',
      0.023882,
      '',
      '',
      '',
      0.134229,
      NULL,
      NULL,
      31.497346,
      3,
      37,
      0.142540,
      0,
      0,
      3,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.825102,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.416412,
      1.137139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.789370,
      NULL,
      1.258519,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.120118,
      NULL,
      NULL,
      NULL,
      1.101466,
      1.627224,
      1.379148,
      3.748166,
      NULL,
      NULL,
      0,
      1.632929,
      3.981047,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      1.775762,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.032628,
      NULL,
      NULL,
      9,
      2.128324,
      5,
      0,
      0.621947,
      NULL,
      NULL,
      NULL,
      3,
      1.090707,
      NULL,
      3.725016,
      0.278570,
      NULL,
      NULL,
      0.806650,
      NULL,
      1,
      2.495494,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.630197,
      NULL,
      NULL,
      1.807281,
      NULL,
      NULL,
      1.782424,
      NULL,
      NULL,
      NULL,
      1.318897,
      3,
      0,
      NULL,
      NULL,
      1.277860,
      7,
      5.146922,
      6.240287,
      1,
      5.174543,
      NULL,
      0,
      NULL,
      1.690336,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      3,
      6,
      5,
      0.739211,
      1,
      1,
      1,
      3,
      1,
      0,
      3.751544,
      1,
      3.339649,
      0.687195,
      NULL,
      3.845968,
      NULL,
      5.809924,
      1.812720,
      NULL,
      2.256913,
      0,
      2,
      0,
      1,
      1,
      0.807259,
      1,
      0.359983,
      3.771899,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556004,
      NULL,
      NULL,
      1.139138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303970,
      NULL,
      NULL,
      0.655125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      1.629903,
      2,
      NULL,
      NULL,
      5.999611,
      NULL,
      NULL,
      NULL,
      2.301185,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      3.771442,
      1,
      NULL,
      NULL,
      1.386866,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.283547,
      NULL,
      NULL,
      3.367957,
      1.443347,
      NULL,
      NULL,
      NULL,
      0.825752,
      NULL,
      NULL,
      3.269697,
      0.432608,
      NULL,
      NULL,
      2.699395,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      6.594778,
      NULL,
      NULL,
      NULL,
      1,
      3.932926,
      NULL,
      4,
      0,
      0,
      11.183921,
      2534.996936,
      NULL,
      NULL,
      1253,
      NULL,
      NULL,
      NULL,
      2.971080,
      NULL,
      95,
      1.261880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079773,
      NULL,
      1,
      0,
      1371,
      0.544354,
      0,
      1,
      0.719554,
      0,
      0.715997,
      0,
      1.734093,
      NULL,
      1.805906,
      0.647756,
      0,
      1,
      1.409920,
      0.333083,
      NULL,
      1,
      1.664744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738503,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.095259,
      NULL,
      1.180814,
      NULL,
      1.271319,
      0,
      1.980901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1.654623,
      1.103260,
      3,
      1,
      2,
      0.663656,
      3,
      3.272877,
      NULL,
      1.461975,
      1.436935,
      NULL,
      0.569807,
      1.483164,
      NULL,
      0,
      3,
      NULL,
      0,
      1.599735,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2.023831,
      NULL,
      1,
      1.681097,
      NULL,
      0,
      2,
      NULL,
      0.514380,
      1,
      NULL,
      3.079232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.114966,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.491516,
      1,
      NULL,
      NULL,
      NULL,
      3.446147,
      NULL,
      '03203',
      '20140',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


