set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9211089';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.282067,
      2.272255,
      3,
      NULL,
      3,
      NULL,
      2.517576,
      3,
      '301',
      '32121441',
      89,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.302638,
      0.224353,
      NULL,
      NULL,
      NULL,
      124.213300,
      NULL,
      NULL,
      NULL,
      1.740944,
      ' 8- 6-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      1.878963,
      3,
      0.098803,
      3.082442,
      NULL,
      0,
      3.291283,
      NULL,
      NULL,
      NULL,
      4.635069,
      0.677508,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      2,
      0,
      NULL,
      0,
      0,
      1,
      2.780209,
      0,
      NULL,
      NULL,
      1,
      1.785085,
      NULL,
      NULL,
      1.709930,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1.870260,
      NULL,
      NULL,
      0,
      1,
      1.347052,
      1.996025,
      5.389136,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      0,
      4,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0.359110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0.283765,
      1,
      3.218036,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133922,
      0.930117,
      6,
      6,
      0,
      5,
      1.649631,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465570,
      0.763747,
      NULL,
      NULL,
      0,
      1,
      0.529383,
      1,
      NULL,
      0.468007,
      0.739541,
      46,
      NULL,
      34,
      NULL,
      1,
      1.818592,
      0,
      1,
      2,
      1,
      2,
      0,
      0,
      NULL,
      3,
      2,
      1,
      0,
      0,
      1.477980,
      0,
      0,
      NULL,
      1.584034,
      0,
      0,
      0.836036,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.233413,
      1.408085,
      NULL,
      NULL,
      6.441588,
      NULL,
      10.668265,
      NULL,
      0,
      1.040234,
      5.361485,
      1,
      0,
      1.299316,
      NULL,
      3,
      1,
      38,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      '04223',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.815736,
      '',
      NULL,
      '',
      2,
      29.395365,
      NULL,
      42,
      1.017688,
      20.853592,
      0,
      2.288462,
      1,
      3,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.821591,
      NULL,
      0.053071,
      2.867440,
      NULL,
      0,
      NULL,
      3,
      0.599653,
      NULL,
      2.445361,
      3,
      0.783309,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.869147,
      2.060359,
      NULL,
      0.651604,
      NULL,
      NULL,
      0.529806,
      NULL,
      NULL,
      5.887266,
      3.341279,
      1.262146,
      0,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.343313,
      0,
      1.460034,
      NULL,
      NULL,
      2.789348,
      3,
      1.333550,
      1,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      1,
      0,
      0.712936,
      3,
      1,
      0,
      2.819749,
      NULL,
      0,
      3,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      6,
      1,
      0,
      NULL,
      0,
      2,
      2.299397,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.704970,
      NULL,
      NULL,
      1.875682,
      NULL,
      0.775873,
      0.324116,
      1.543200,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088476,
      3,
      1,
      1,
      NULL,
      1.182310,
      NULL,
      5.985825,
      1,
      3.892307,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.903773,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.258281,
      NULL,
      1,
      NULL,
      1,
      1.308500,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.147218,
      NULL,
      NULL,
      5,
      5,
      NULL,
      8.567809,
      7,
      0,
      1.784506,
      1.992756,
      NULL,
      3,
      3,
      0,
      0,
      NULL,
      NULL,
      6.263287,
      0,
      1,
      2.643753,
      1,
      0,
      1,
      1.019966,
      3,
      3,
      2,
      NULL,
      1,
      0.655685,
      0.706892,
      6,
      4,
      4,
      9.103484,
      6,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      3.412685,
      1,
      3.685090,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.478796,
      1,
      NULL,
      1.484747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.527856,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.640590,
      NULL,
      3.364011,
      0,
      NULL,
      9.077391,
      8.226387,
      NULL,
      3,
      0.644474,
      1.723971,
      0.460074,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      1,
      1.627124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.922305,
      0.710992,
      NULL,
      NULL,
      0.556870,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.040093,
      NULL,
      NULL,
      1.652422,
      0,
      NULL,
      NULL,
      NULL,
      3.657686,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480745,
      NULL,
      NULL,
      1.617039,
      1,
      NULL,
      NULL,
      1.293115,
      0,
      NULL,
      NULL,
      2,
      0.418867,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      11,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      41,
      8,
      3.037200,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.741530,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.388681,
      1.828380,
      0.940758,
      0,
      0,
      1.535201,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1.083453,
      0,
      0.898435,
      0,
      0.665881,
      1.154814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      7,
      0,
      0.647022,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796353,
      1,
      0.448385,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1.229721,
      0,
      0,
      NULL,
      0,
      1,
      2,
      3.372586,
      1,
      1.773612,
      1.501240,
      1.562210,
      3.269639,
      1,
      0.655139,
      1,
      2,
      0,
      1.589061,
      1,
      0,
      0.373750,
      NULL,
      1,
      1,
      1.191076,
      2,
      2.319701,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.470088,
      0,
      0,
      1,
      1,
      NULL,
      6,
      0.043944,
      NULL,
      NULL,
      NULL,
      141.939436,
      2,
      NULL,
      3,
      '32110',
      NULL,
      '',
      0.270640,
      '',
      '',
      NULL,
      1.576520,
      '',
      NULL,
      '');
commit;
end;
/


