set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614546';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.304023,
      1.557287,
      NULL,
      3.050029,
      NULL,
      NULL,
      3,
      1.767493,
      '040',
      '10411132',
      NULL,
      8,
      '3211332',
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.024096,
      1.260911,
      NULL,
      NULL,
      ' 8-24-1994',
      12.593056,
      59.774447,
      NULL,
      1.937894,
      1.215297,
      '11-12-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 1- 0-1998',
      ' 4- 6-1990',
      ' 6-10-2000',
      2,
      NULL,
      3,
      1,
      1.348577,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.187292,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      1,
      1,
      1,
      5,
      NULL,
      NULL,
      0,
      0,
      1,
      11.354195,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      7,
      1,
      1,
      1.057233,
      3.588944,
      0,
      0.486942,
      0,
      1,
      0,
      1,
      0,
      0.363716,
      NULL,
      1.437024,
      0.233988,
      0.649885,
      0,
      1,
      NULL,
      2,
      NULL,
      0,
      1.148401,
      0,
      NULL,
      NULL,
      1.646506,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0,
      2,
      NULL,
      0,
      0,
      4,
      NULL,
      0,
      5,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      3,
      3,
      2,
      1,
      0,
      5,
      0,
      2,
      4,
      1,
      4,
      0,
      3,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      0,
      ' 0- 2-1977',
      336,
      ' 0-20-1976',
      536,
      3.130309,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      1.309534,
      5,
      4.657080,
      1.740098,
      3.568081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.960021,
      1,
      1.738840,
      NULL,
      1.513551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      3,
      0,
      2,
      3,
      3,
      3,
      1,
      NULL,
      NULL,
      3.356208,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.455718,
      NULL,
      0,
      0,
      1,
      1.829897,
      0.292786,
      0,
      0,
      4,
      0,
      2,
      NULL,
      4,
      NULL,
      8,
      1,
      4,
      1,
      7.336493,
      2,
      NULL,
      0.902991,
      14,
      2,
      1.050070,
      59,
      NULL,
      43,
      48,
      1,
      2,
      2,
      '20422',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.341623,
      '',
      '',
      '',
      NULL,
      NULL,
      75.779881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.047916,
      1.236457,
      NULL,
      1.006169,
      NULL,
      NULL,
      0.197737,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.523059,
      NULL,
      NULL,
      1.242813,
      NULL,
      NULL,
      2.296969,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.716103,
      NULL,
      NULL,
      0.146286,
      NULL,
      NULL,
      1.281506,
      NULL,
      NULL,
      0,
      7,
      3,
      1,
      0.040888,
      NULL,
      NULL,
      NULL,
      0.681624,
      NULL,
      NULL,
      NULL,
      0.069064,
      1.676580,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.930874,
      3.346141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584768,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.833203,
      NULL,
      NULL,
      9,
      4,
      4.116762,
      0,
      0.510442,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.582935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.860192,
      1,
      0.345527,
      0.660701,
      1,
      0.318462,
      1.182191,
      0.185111,
      0.633516,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.988563,
      NULL,
      NULL,
      0.497180,
      NULL,
      NULL,
      1.349386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590260,
      NULL,
      NULL,
      0.740765,
      NULL,
      NULL,
      0.525737,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      0.093153,
      NULL,
      NULL,
      1.085637,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.930595,
      NULL,
      1,
      0,
      3,
      2,
      0,
      1.235247,
      NULL,
      0.394056,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.537005,
      NULL,
      NULL,
      0.714853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975382,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.081423,
      1,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.261634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488298,
      NULL,
      NULL,
      NULL,
      0.264808,
      NULL,
      NULL,
      NULL,
      0.217107,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.315765,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.207986,
      0.922673,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150278,
      NULL,
      NULL,
      0.977783,
      NULL,
      NULL,
      0.553762,
      NULL,
      NULL,
      160,
      1.355588,
      NULL,
      1,
      NULL,
      1,
      1.062049,
      NULL,
      0.360111,
      0,
      NULL,
      0.473835,
      0,
      1,
      NULL,
      NULL,
      1.969879,
      1,
      0,
      0.259037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3,
      0,
      3,
      4.960501,
      1.864355,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851152,
      NULL,
      0.242620,
      NULL,
      NULL,
      0.567973,
      1.056650,
      NULL,
      0.518172,
      1,
      NULL,
      0,
      0,
      NULL,
      1.274023,
      1,
      NULL,
      0,
      1.882336,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.345050,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751022,
      NULL,
      1.895785,
      NULL,
      0.847623,
      NULL,
      1,
      3,
      4,
      NULL,
      NULL,
      NULL,
      54,
      NULL,
      0,
      4,
      1.552613,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


