set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7302006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.722388,
      2,
      0,
      1,
      2.667835,
      0,
      3,
      '120',
      '34002121',
      57.640068,
      68,
      '2000243',
      1.790681,
      NULL,
      5,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 6-11-1975',
      69,
      133.056575,
      NULL,
      NULL,
      1.816758,
      ' 4- 2-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.088598,
      NULL,
      NULL,
      3.164106,
      0.570843,
      1,
      NULL,
      1.810622,
      1,
      4.359489,
      6,
      10.519316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      1.998330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2.596722,
      NULL,
      0,
      3,
      1,
      0,
      3,
      4,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      0.566462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.453123,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      5.966811,
      1,
      2,
      0.151485,
      0,
      NULL,
      NULL,
      0.240773,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      4,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      2,
      NULL,
      3,
      3,
      5,
      3,
      1,
      3,
      0,
      1,
      1,
      NULL,
      '11- 4-1978',
      428.087653,
      ' 4-20-1990',
      1,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      0,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      1,
      3.448874,
      0.889726,
      3.230308,
      4.668998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642662,
      NULL,
      0.051732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.395180,
      0.920375,
      1.064166,
      0,
      1,
      1,
      NULL,
      1.419814,
      NULL,
      0.203444,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.601493,
      0,
      0,
      0,
      2,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      0,
      0,
      0.737509,
      0.708195,
      NULL,
      1,
      1,
      0,
      0.765657,
      NULL,
      1,
      1,
      1.734845,
      1,
      10,
      7,
      2.143458,
      7,
      3.903568,
      3.251765,
      2.814492,
      0.509031,
      3.508073,
      1,
      0.280363,
      3,
      69.767515,
      1,
      2.805923,
      4,
      NULL,
      NULL,
      64,
      2,
      2.426776,
      0,
      '01334',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2.410997,
      NULL,
      NULL,
      4,
      0.120640,
      86.616164,
      2,
      NULL,
      1,
      3,
      0,
      0.859583,
      1,
      NULL,
      NULL,
      0.530599,
      NULL,
      NULL,
      1.097007,
      NULL,
      NULL,
      NULL,
      0.201644,
      1,
      NULL,
      1.710855,
      1,
      0,
      1,
      NULL,
      3.886244,
      NULL,
      0.756807,
      NULL,
      NULL,
      NULL,
      0.100565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.301753,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.978201,
      1.422669,
      NULL,
      NULL,
      1.120633,
      NULL,
      NULL,
      0,
      NULL,
      1.427204,
      3.756538,
      1.486542,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      2,
      1.263711,
      2.802562,
      NULL,
      0.952440,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.046442,
      NULL,
      NULL,
      0.207716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.133214,
      NULL,
      NULL,
      1.961546,
      0,
      0.362602,
      0,
      NULL,
      NULL,
      2.832254,
      NULL,
      1.977064,
      3.451405,
      NULL,
      1.554061,
      3.265604,
      NULL,
      0,
      4,
      1.164199,
      0.536270,
      0,
      NULL,
      NULL,
      0.605614,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.217465,
      NULL,
      NULL,
      0.393167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.103576,
      NULL,
      1,
      3.582781,
      0,
      1.513257,
      0.355294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538800,
      NULL,
      NULL,
      0.826045,
      2,
      0.424139,
      3.495600,
      3.213582,
      2,
      NULL,
      0.341715,
      NULL,
      2,
      1.209800,
      0,
      2.840357,
      NULL,
      2,
      0,
      3.427553,
      NULL,
      2.193334,
      0.500580,
      0.694168,
      5.949202,
      0,
      2,
      3.349606,
      NULL,
      NULL,
      1.121392,
      2,
      1,
      1,
      1.545147,
      0.633724,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800109,
      NULL,
      NULL,
      3.921858,
      NULL,
      NULL,
      1.799863,
      NULL,
      NULL,
      0.645702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647170,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      1,
      1.578123,
      0.060306,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      69,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184622,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.968636,
      NULL,
      NULL,
      NULL,
      3.102467,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.325310,
      NULL,
      NULL,
      NULL,
      0.188052,
      NULL,
      NULL,
      NULL,
      2.251120,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.720908,
      NULL,
      0.643027,
      0.053504,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.667498,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.958608,
      NULL,
      0.065608,
      0,
      NULL,
      1,
      0.363393,
      1,
      0,
      0.272708,
      0,
      0,
      1.264324,
      0,
      1.162683,
      0.890149,
      0,
      1.566261,
      1.262663,
      NULL,
      1,
      0.390396,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      1,
      2,
      0.503741,
      NULL,
      1,
      3.673242,
      1.592227,
      1.859974,
      1,
      1.746191,
      NULL,
      0.239651,
      2,
      NULL,
      1.837017,
      1.171151,
      NULL,
      0,
      2.034301,
      NULL,
      1.369236,
      2.566891,
      NULL,
      1.154725,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.715983,
      1.479116,
      NULL,
      0,
      1,
      NULL,
      0,
      0.680072,
      NULL,
      0.395796,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220059,
      NULL,
      1.085018,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      0.782461,
      NULL,
      NULL,
      NULL,
      74,
      1,
      1.591394,
      0.693835,
      '30140',
      '',
      '',
      1,
      '',
      '',
      '',
      0.716330,
      '',
      NULL,
      '');
commit;
end;
/


