set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9511616';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '4420310',
      3,
      0,
      6,
      3,
      '1103',
      0.268699,
      1,
      NULL,
      NULL,
      ' 9- 0-1991',
      60.452055,
      NULL,
      2,
      1,
      2.064668,
      ' 5- 3-1996',
      0.106644,
      5,
      4,
      20.339042,
      1,
      ' 5- 4-1988',
      ' 5-22-1994',
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.609079,
      5.969719,
      NULL,
      29.625135,
      NULL,
      3.494093,
      0,
      0,
      1,
      0,
      0,
      0,
      0.239653,
      1,
      1.201349,
      0,
      NULL,
      1,
      NULL,
      0.600504,
      5,
      2,
      1,
      2,
      1,
      1,
      0,
      0,
      3,
      1,
      4,
      1,
      NULL,
      0,
      0,
      1,
      2.429099,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0.239647,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      2.514470,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1.114029,
      0,
      1,
      1,
      NULL,
      1,
      0,
      3,
      1,
      0,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      0,
      3,
      2,
      2,
      0,
      0,
      1,
      1,
      5,
      1.547249,
      1.882438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      3,
      1,
      NULL,
      0.143246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      128,
      2,
      0,
      1,
      0.706218,
      0,
      1,
      0,
      1.083980,
      4,
      1,
      3.744384,
      0,
      0,
      1,
      0,
      0.550268,
      3.895365,
      NULL,
      0.467370,
      2.944699,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147755,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1.773326,
      1.423313,
      2,
      10.804504,
      2.457660,
      0.248954,
      NULL,
      NULL,
      NULL,
      2,
      0.290717,
      1.902944,
      1,
      1,
      0,
      3,
      0,
      0,
      NULL,
      3,
      3,
      2,
      NULL,
      0,
      2,
      NULL,
      1,
      0.512579,
      5.416712,
      NULL,
      NULL,
      1.404852,
      NULL,
      0,
      1,
      NULL,
      1.886679,
      1,
      1,
      1,
      1,
      1,
      2,
      NULL,
      11,
      3.934142,
      NULL,
      NULL,
      0.038772,
      7.799030,
      NULL,
      2.827802,
      2.836098,
      6.134108,
      3,
      1.849735,
      NULL,
      41,
      13,
      46,
      4,
      NULL,
      NULL,
      '14430',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.908843,
      NULL,
      '',
      '',
      2.596490,
      6,
      25.583276,
      40,
      0.125644,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.098894,
      1,
      2.763412,
      0.449766,
      NULL,
      2.742384,
      1.707633,
      NULL,
      NULL,
      NULL,
      0.169107,
      0.598469,
      1,
      NULL,
      NULL,
      1.697611,
      0.332260,
      3.206118,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735623,
      1.897336,
      NULL,
      1,
      1.331856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.723097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.588181,
      NULL,
      NULL,
      1.927800,
      NULL,
      NULL,
      1.243206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.459268,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.567463,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.568754,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.307085,
      NULL,
      NULL,
      0.561562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.341695,
      0.502233,
      NULL,
      NULL,
      1.102811,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.610957,
      NULL,
      NULL,
      0.558104,
      1.531547,
      0,
      1.174363,
      1,
      0.225310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245972,
      1.373505,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586493,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.229123,
      0,
      1.626915,
      1.220309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967556,
      NULL,
      1.349433,
      49,
      1.348395,
      1,
      1,
      0.647794,
      0.162726,
      0,
      1.735999,
      0,
      NULL,
      1,
      0.735325,
      0,
      NULL,
      1,
      1.117970,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      4.535338,
      1.172237,
      0.140152,
      NULL,
      1,
      0,
      2.989937,
      0,
      1,
      1.904021,
      0.629297,
      NULL,
      2,
      2.515776,
      NULL,
      0.231050,
      1,
      NULL,
      1.130837,
      1.754511,
      NULL,
      0,
      1.943281,
      NULL,
      1.055360,
      1.308499,
      NULL,
      0.844126,
      1.069184,
      NULL,
      0.925040,
      0.026588,
      NULL,
      0,
      1,
      NULL,
      1.706795,
      0.292881,
      NULL,
      0,
      0,
      NULL,
      2.691884,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.654451,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.026628,
      NULL,
      NULL,
      NULL,
      1.705543,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.377107,
      NULL,
      5.501307,
      0,
      27,
      1,
      NULL,
      0,
      NULL,
      1.956159,
      NULL,
      NULL,
      2,
      2,
      0.899625,
      NULL,
      NULL,
      23.366942,
      NULL,
      3,
      5.026808,
      NULL,
      '30432',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.488295,
      NULL,
      '',
      '');
commit;
end;
/


