set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5601823';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '3422022',
      NULL,
      1,
      0,
      NULL,
      '4204',
      2.800244,
      0.860729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.935376,
      0.059503,
      NULL,
      52.307864,
      0,
      NULL,
      149.798943,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      4.323729,
      2,
      15,
      NULL,
      NULL,
      19.061027,
      5,
      1,
      7,
      0.881974,
      0,
      NULL,
      0,
      0,
      1.637202,
      1,
      NULL,
      1.083322,
      0.566772,
      0.579877,
      0,
      NULL,
      3,
      0,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.574507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      NULL,
      0,
      1,
      1,
      1,
      0,
      2,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1.625481,
      NULL,
      1.545157,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      3,
      4,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      NULL,
      3,
      1,
      0,
      1,
      3.805694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1.391688,
      0.264735,
      1.254970,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.902665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.771039,
      1,
      1,
      0,
      1,
      0,
      0,
      0.120443,
      NULL,
      NULL,
      1.158671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562716,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      '04020',
      '',
      '',
      0.354708,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      151,
      32.780919,
      3.635670,
      35.857615,
      11,
      24.436486,
      2,
      NULL,
      NULL,
      0.258941,
      1.857214,
      NULL,
      NULL,
      0,
      NULL,
      1.971081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539709,
      NULL,
      NULL,
      1.179449,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.470224,
      NULL,
      NULL,
      3,
      2.194617,
      0.093225,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.458606,
      NULL,
      2.924102,
      10,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      3.701543,
      1.578202,
      0.204540,
      0.069546,
      0.896720,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.639544,
      0,
      1.420151,
      0.682094,
      NULL,
      NULL,
      NULL,
      1.930209,
      NULL,
      NULL,
      0.543312,
      NULL,
      NULL,
      1.645270,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.868234,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.311261,
      NULL,
      NULL,
      NULL,
      1.383342,
      NULL,
      0,
      NULL,
      NULL,
      4.494135,
      11.110629,
      0,
      0.346307,
      0.977484,
      1.683457,
      2,
      NULL,
      1,
      5.320128,
      1.838941,
      0.811220,
      1,
      1,
      1,
      4.317167,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.912559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.128734,
      3.650926,
      0,
      3,
      2.696936,
      NULL,
      2,
      2,
      0,
      6.095224,
      7,
      0,
      1.726532,
      NULL,
      0,
      2.546688,
      NULL,
      NULL,
      3,
      2.225319,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      9,
      NULL,
      3,
      0,
      0,
      0,
      3,
      1.334853,
      0.209091,
      NULL,
      NULL,
      3,
      3.768575,
      1,
      1,
      6.590747,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1.648788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.399202,
      0,
      0.958461,
      0,
      NULL,
      NULL,
      NULL,
      3.631088,
      NULL,
      NULL,
      NULL,
      19.885694,
      NULL,
      NULL,
      NULL,
      3.753873,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.930504,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.035630,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.539998,
      NULL,
      NULL,
      NULL,
      3.315348,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11.524754,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936727,
      699.080027,
      NULL,
      1.532889,
      460,
      861.045254,
      0.771082,
      NULL,
      NULL,
      0.322047,
      175.169577,
      87.967653,
      0.061123,
      1977,
      1784,
      0,
      NULL,
      NULL,
      3.883048,
      12.108001,
      1,
      304.846744,
      7,
      1,
      1.491206,
      1.115270,
      1.242004,
      1.902102,
      1,
      0.125890,
      1,
      1.999239,
      0,
      0.614025,
      1,
      NULL,
      1.146742,
      0.107044,
      NULL,
      0.998918,
      1.244249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.719857,
      5,
      3.294581,
      NULL,
      3,
      11.494726,
      1,
      NULL,
      2,
      1,
      0,
      1.145335,
      0.287720,
      1.730454,
      0.035350,
      0.370771,
      1,
      0.245557,
      0.162033,
      0.809414,
      1.594926,
      NULL,
      NULL,
      NULL,
      1.549742,
      3.862064,
      1,
      1,
      0.650223,
      1.651114,
      0,
      3,
      1.603440,
      1.995355,
      1.270548,
      1.186882,
      0,
      NULL,
      1.368733,
      0,
      0,
      0.837936,
      0.720689,
      1.484085,
      3.723860,
      1,
      0,
      NULL,
      0.407202,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.430017,
      NULL,
      NULL,
      NULL,
      0.382812,
      NULL,
      1.678947,
      NULL,
      3.038289,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822447,
      1,
      0.544249,
      NULL,
      0,
      0.273653,
      0,
      NULL,
      NULL,
      2.482837,
      1,
      2,
      140.658783,
      125.346285,
      3,
      0.521962,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


