set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6109422';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '0044022',
      2.090060,
      NULL,
      0,
      2,
      '0013',
      3,
      NULL,
      NULL,
      NULL,
      ' 9-22-1979',
      43.159557,
      NULL,
      0,
      0.409111,
      1,
      ' 4- 3-2003',
      1.184358,
      NULL,
      255.420236,
      116,
      3,
      '10- 3-1976',
      ' 0-15-1976',
      ' 9-27-2003',
      NULL,
      1,
      3.743070,
      NULL,
      0.870953,
      NULL,
      NULL,
      0,
      0,
      27,
      2,
      14,
      0.710466,
      21,
      NULL,
      3,
      NULL,
      2,
      1,
      6,
      NULL,
      0,
      NULL,
      0.737152,
      1,
      1.033904,
      0.806985,
      0,
      NULL,
      1,
      73.220103,
      5,
      2,
      5,
      3,
      2,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      2,
      0,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.040595,
      1.332567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2.540796,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1.702164,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      5,
      NULL,
      1,
      5,
      NULL,
      5,
      4,
      5,
      0,
      4,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1,
      0,
      2,
      2,
      2,
      4,
      3,
      NULL,
      1,
      0,
      0.233260,
      NULL,
      NULL,
      NULL,
      ' 6- 1-2003',
      333.350486,
      0,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1.262636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412338,
      1,
      9,
      3.260449,
      NULL,
      NULL,
      1.784509,
      NULL,
      NULL,
      NULL,
      1.682954,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322144,
      NULL,
      0,
      0.461388,
      NULL,
      NULL,
      1.249838,
      2.524024,
      2162.868187,
      1.845189,
      0.000666,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.457361,
      0,
      1,
      3,
      2,
      0,
      3,
      NULL,
      3,
      1,
      NULL,
      0.167396,
      3,
      0.892254,
      0.820737,
      NULL,
      0.040956,
      3,
      1,
      NULL,
      NULL,
      1.799334,
      1,
      0,
      0.086651,
      1,
      1,
      8,
      3,
      1,
      2.430607,
      1,
      0,
      1,
      10.277276,
      4,
      4.766992,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      22.687429,
      1,
      3.596712,
      NULL,
      31,
      5,
      57.041158,
      0,
      0,
      1.019128,
      '14321',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.795326,
      '',
      '',
      '',
      3.678882,
      10.791608,
      126,
      32.771995,
      1.594468,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306254,
      2,
      NULL,
      1.420696,
      NULL,
      NULL,
      1.608019,
      NULL,
      NULL,
      2,
      NULL,
      0.971439,
      3.755670,
      0.473833,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.879497,
      NULL,
      NULL,
      0.209278,
      NULL,
      NULL,
      1.418447,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.498456,
      NULL,
      NULL,
      8,
      7,
      0,
      NULL,
      NULL,
      1,
      1.729039,
      0,
      1.091210,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.369740,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782385,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.402848,
      2,
      0.520702,
      2,
      0,
      0.802092,
      NULL,
      3,
      1.839965,
      NULL,
      2.672238,
      NULL,
      0.472536,
      3,
      1.799803,
      0.079751,
      2,
      0.665807,
      1,
      5,
      0.655471,
      1.608304,
      NULL,
      NULL,
      1.900400,
      NULL,
      NULL,
      1.153847,
      NULL,
      NULL,
      1.003592,
      NULL,
      NULL,
      1,
      NULL,
      0,
      5,
      0.052680,
      0.113189,
      3,
      3,
      NULL,
      3.091774,
      2,
      3,
      NULL,
      1.319776,
      3.734195,
      NULL,
      0.915865,
      6.263640,
      8.871101,
      9.963884,
      2.060674,
      0.358185,
      3.012171,
      NULL,
      1,
      1.140378,
      NULL,
      0,
      NULL,
      0,
      4.056038,
      7.575332,
      1,
      0,
      0,
      1.264235,
      1,
      NULL,
      NULL,
      1.734737,
      2,
      0.533713,
      2,
      3.980095,
      1,
      4,
      1.297071,
      10.366462,
      NULL,
      6.893722,
      NULL,
      3,
      2,
      2,
      0.305525,
      2.440516,
      0,
      0.696176,
      0,
      3.221551,
      NULL,
      6.607973,
      2.325109,
      NULL,
      6.658537,
      NULL,
      NULL,
      0.685521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.535079,
      NULL,
      NULL,
      3.150873,
      NULL,
      NULL,
      1.390528,
      1.104775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.363176,
      0,
      NULL,
      2.657757,
      0.517158,
      NULL,
      NULL,
      1.554449,
      NULL,
      2,
      0,
      NULL,
      4.692275,
      0.668489,
      NULL,
      1,
      1.450272,
      0.743330,
      1.731318,
      2,
      NULL,
      0.174808,
      0,
      2,
      NULL,
      0.281803,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806953,
      NULL,
      1,
      NULL,
      0.906542,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.333580,
      NULL,
      NULL,
      NULL,
      0.774328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.591145,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.495148,
      NULL,
      3.565827,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.575855,
      NULL,
      4.068176,
      NULL,
      2.178334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.150020,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.566966,
      NULL,
      NULL,
      3.206518,
      34.512799,
      NULL,
      0,
      12.449849,
      NULL,
      3.411248,
      25.111918,
      0.654494,
      5917,
      1712.107402,
      NULL,
      0.807403,
      0,
      0.789524,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.655039,
      0,
      1,
      1,
      1.766236,
      0,
      1,
      0.922401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.521954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979017,
      0.487436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439001,
      1.690022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136187,
      3.504236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646554,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.766119,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.283605,
      2,
      2.292611,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.058640,
      0.685173,
      NULL,
      NULL,
      2.313537,
      NULL,
      0,
      0,
      NULL,
      0,
      1.970453,
      NULL,
      0,
      1.216129,
      NULL,
      NULL,
      1.144221,
      NULL,
      0.262446,
      2.396878,
      NULL,
      1,
      1.735226,
      NULL,
      1.334855,
      2,
      NULL,
      1.733244,
      0.320517,
      NULL,
      1.130018,
      0.830190,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.713109,
      NULL,
      0,
      NULL,
      4,
      3,
      7,
      3,
      0,
      0.094336,
      24,
      110.005016,
      5,
      0,
      2,
      NULL,
      '12401',
      '',
      NULL,
      '',
      '',
      '',
      0.028210,
      '',
      '',
      '');
commit;
end;
/


