set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6109422';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '0013404',
      NULL,
      0,
      2,
      1,
      '2243',
      3.715993,
      1.422802,
      NULL,
      NULL,
      '11- 4-1974',
      NULL,
      NULL,
      NULL,
      2,
      0.586714,
      ' 8-15-1986',
      28,
      2.662523,
      19,
      140.441173,
      3,
      ' 4- 4-1994',
      ' 3-29-1999',
      ' 0-12-1990',
      1,
      0,
      2,
      1,
      1.962586,
      NULL,
      NULL,
      NULL,
      NULL,
      101,
      1,
      5,
      0.444617,
      32.253014,
      NULL,
      NULL,
      9.126126,
      0,
      0,
      4.021837,
      1,
      1,
      0,
      0,
      NULL,
      1.411957,
      0.050821,
      1,
      1,
      1,
      NULL,
      8,
      3,
      2,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      0.946399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.130755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.536118,
      NULL,
      1,
      1,
      NULL,
      0,
      5,
      4,
      1,
      0,
      4,
      NULL,
      1,
      3,
      NULL,
      3,
      4,
      0,
      0,
      NULL,
      1,
      5,
      NULL,
      3,
      1,
      5,
      0,
      NULL,
      ' 7- 5-1979',
      533.983730,
      ' 5-28-1981',
      11,
      1,
      2,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1.447070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.445801,
      0.694407,
      0.331641,
      0.727752,
      1,
      0.952634,
      0,
      NULL,
      NULL,
      NULL,
      0.262420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.325332,
      0,
      0,
      1,
      0,
      2,
      NULL,
      1.018767,
      1.476246,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      2,
      0,
      1,
      2,
      3,
      2,
      3,
      2,
      3.559744,
      NULL,
      NULL,
      4.202377,
      0,
      1.789138,
      NULL,
      NULL,
      NULL,
      1.826459,
      NULL,
      0.563525,
      1.802343,
      0.495913,
      NULL,
      NULL,
      1.024084,
      0.296543,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.292536,
      NULL,
      25,
      57,
      NULL,
      NULL,
      1.005602,
      1.485643,
      '32223',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      67.229341,
      NULL,
      1.705578,
      NULL,
      NULL,
      NULL,
      NULL,
      3.171605,
      3.121270,
      NULL,
      1.808609,
      NULL,
      NULL,
      1.504910,
      NULL,
      NULL,
      1.037227,
      3.725844,
      NULL,
      1,
      2.030145,
      0.640248,
      1.580143,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.565999,
      NULL,
      NULL,
      3,
      0.547667,
      1,
      3,
      1.457436,
      1,
      NULL,
      0.405438,
      NULL,
      1,
      NULL,
      NULL,
      1,
      8,
      6,
      1,
      2.786536,
      1.439913,
      1,
      1.908155,
      0.974424,
      1.813446,
      1.944331,
      2,
      NULL,
      1,
      0,
      0.493811,
      NULL,
      NULL,
      0.753223,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      0.158725,
      0,
      0,
      0.900189,
      0.637216,
      1,
      1.131978,
      1,
      3,
      1.622307,
      0,
      0.300064,
      0,
      NULL,
      NULL,
      0.354395,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2.182555,
      NULL,
      2,
      3,
      12.009814,
      NULL,
      17,
      1.102447,
      NULL,
      NULL,
      NULL,
      0.263757,
      NULL,
      NULL,
      3,
      1,
      0.915669,
      0.404766,
      0.571139,
      1.120137,
      NULL,
      NULL,
      NULL,
      3,
      2.536884,
      1.413776,
      3.010820,
      3.106379,
      1,
      3,
      2,
      0.020785,
      2.172447,
      5,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.577730,
      NULL,
      0.652662,
      3.721088,
      NULL,
      0,
      2,
      3,
      3,
      0.595858,
      NULL,
      NULL,
      5,
      0.707603,
      5,
      3.330202,
      1,
      3,
      3.284002,
      NULL,
      NULL,
      0,
      3.573155,
      0.227284,
      1,
      NULL,
      2,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.871203,
      0,
      NULL,
      NULL,
      2.922353,
      NULL,
      3.384199,
      2.978815,
      0.003653,
      NULL,
      8.749139,
      3,
      7.664436,
      6.172785,
      7,
      NULL,
      2,
      2,
      4,
      3,
      0.120393,
      3.618806,
      0.364224,
      3,
      2.562562,
      NULL,
      5.443723,
      2.387198,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.753596,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      17,
      NULL,
      1.164561,
      18.360848,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      7,
      NULL,
      0.232453,
      12,
      NULL,
      2,
      10.601306,
      NULL,
      3.349847,
      NULL,
      NULL,
      9.206014,
      17,
      NULL,
      1.592412,
      0.156215,
      3.897620,
      2,
      0,
      NULL,
      0,
      0.290531,
      NULL,
      0.304263,
      1,
      NULL,
      NULL,
      8.131915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      12.490009,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.977598,
      NULL,
      NULL,
      NULL,
      2.338711,
      13,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.888229,
      8,
      NULL,
      NULL,
      1.519232,
      15.164312,
      NULL,
      NULL,
      1.678997,
      5.876870,
      NULL,
      NULL,
      0,
      2.004723,
      NULL,
      NULL,
      15,
      16.760186,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      16.190345,
      NULL,
      0.871116,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      8.037146,
      NULL,
      0.837556,
      NULL,
      NULL,
      2.368978,
      9.197791,
      NULL,
      16927,
      1181,
      1,
      0.291511,
      1.311934,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.006683,
      0,
      0.287143,
      NULL,
      0.392136,
      0.309637,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.663850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1.857084,
      NULL,
      NULL,
      NULL,
      0.648551,
      NULL,
      1.764669,
      NULL,
      1.716889,
      NULL,
      1.166477,
      0,
      0.395105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.522607,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.610311,
      0.078609,
      0.662150,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.743661,
      0.211742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0.225312,
      0,
      2,
      1,
      2.843991,
      1,
      NULL,
      1.310276,
      1.236880,
      NULL,
      0.912512,
      0.112650,
      NULL,
      0,
      1.073585,
      NULL,
      1,
      1.641210,
      NULL,
      NULL,
      1,
      NULL,
      0.869517,
      NULL,
      NULL,
      0,
      1.976273,
      NULL,
      0,
      1,
      NULL,
      1.762414,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.296353,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315857,
      NULL,
      1.892306,
      NULL,
      1.921268,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.266260,
      35,
      2,
      0.053085,
      0.623006,
      '42023',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.725938,
      '',
      NULL,
      '');
commit;
end;
/


