set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6109422';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3211334',
      0,
      1.908972,
      4,
      3,
      '1132',
      2,
      0,
      NULL,
      NULL,
      ' 8- 5-1988',
      37.986872,
      NULL,
      4,
      NULL,
      3,
      '11- 3-2000',
      8,
      NULL,
      NULL,
      NULL,
      1,
      ' 3-26-1994',
      ' 7- 2-1977',
      NULL,
      NULL,
      NULL,
      3.425976,
      1.903164,
      1,
      NULL,
      NULL,
      1,
      1.406842,
      NULL,
      5,
      8,
      NULL,
      NULL,
      22,
      NULL,
      7,
      1,
      NULL,
      5.588356,
      NULL,
      1,
      0,
      0,
      0.073303,
      0.163146,
      0.767410,
      0,
      0,
      0,
      165,
      1,
      5,
      6,
      1.993148,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      1.315192,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      5.677004,
      0,
      1,
      0.998910,
      0.516768,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      5,
      1,
      3,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0.957365,
      NULL,
      0,
      1,
      3,
      1,
      4,
      0,
      0,
      NULL,
      NULL,
      5,
      0,
      5,
      5,
      4,
      0,
      3,
      1,
      4,
      1,
      2,
      0,
      NULL,
      3,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      401.135011,
      NULL,
      202.701304,
      0.377862,
      2,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183239,
      0.016169,
      6,
      1.345240,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.204545,
      0.079080,
      1.908273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076542,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      0.749165,
      2160,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      3,
      NULL,
      3,
      1,
      NULL,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385768,
      2.101893,
      1,
      2.980157,
      0,
      0,
      0,
      0.881400,
      0,
      0.700451,
      1,
      0.116738,
      6.670537,
      NULL,
      7.983787,
      10,
      6,
      8,
      NULL,
      7.125971,
      4.877951,
      2.963569,
      NULL,
      1,
      0,
      1,
      49,
      3,
      2.608894,
      NULL,
      12,
      2,
      NULL,
      NULL,
      1.910276,
      1,
      '31324',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0.124552,
      NULL,
      NULL,
      21.033197,
      1.370400,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.452686,
      1.102438,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0.217359,
      NULL,
      1.742131,
      0.608463,
      1.655230,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.655685,
      0.558501,
      0.494083,
      NULL,
      2,
      0.472224,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.885361,
      NULL,
      NULL,
      NULL,
      4.736977,
      6.157671,
      1,
      0,
      0.532240,
      3,
      1,
      1.983022,
      NULL,
      NULL,
      NULL,
      1,
      0.821974,
      0,
      0.944118,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.509169,
      0,
      1.193947,
      1.306652,
      1.159767,
      NULL,
      0,
      0.468197,
      0.025769,
      1,
      NULL,
      0.698011,
      0.222602,
      1,
      NULL,
      0,
      0.870065,
      NULL,
      NULL,
      1.720507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.129755,
      4,
      3.128117,
      2,
      1,
      5.378875,
      NULL,
      10.118726,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.713050,
      0.866521,
      NULL,
      3,
      1.864785,
      2.278082,
      NULL,
      1.659856,
      NULL,
      NULL,
      0.589687,
      3,
      2.549252,
      0,
      0,
      0,
      1.898436,
      0,
      11.374345,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517329,
      NULL,
      NULL,
      1.426597,
      NULL,
      NULL,
      1.651494,
      NULL,
      NULL,
      1,
      3,
      1,
      3.576322,
      NULL,
      1.841730,
      0.626142,
      NULL,
      NULL,
      2.718643,
      2.432291,
      1,
      1.955008,
      1,
      8,
      4,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      3,
      2.517085,
      3,
      NULL,
      3.015846,
      0.249689,
      2,
      3.699538,
      8,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      2.288255,
      2,
      NULL,
      3,
      0,
      NULL,
      NULL,
      6.766235,
      0,
      NULL,
      3.745476,
      2,
      0,
      NULL,
      0,
      1,
      3,
      2.796441,
      0,
      2.584750,
      0,
      NULL,
      3.495751,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254862,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.886985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381984,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.996520,
      1.849356,
      NULL,
      0,
      0.227207,
      NULL,
      NULL,
      0.917505,
      NULL,
      1,
      1,
      NULL,
      1.258754,
      1,
      NULL,
      4.780735,
      1,
      NULL,
      1.392632,
      NULL,
      NULL,
      0.445726,
      2,
      1,
      2.958360,
      1,
      5.532250,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.115520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.902400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.445942,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.830925,
      NULL,
      0.825556,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.664776,
      NULL,
      NULL,
      NULL,
      1.020496,
      NULL,
      2.598435,
      NULL,
      0.071626,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.794498,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.222701,
      NULL,
      NULL,
      NULL,
      0.382613,
      NULL,
      0.930156,
      NULL,
      1.030899,
      NULL,
      12.089601,
      NULL,
      NULL,
      NULL,
      3.313871,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      62,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058068,
      NULL,
      NULL,
      0.051680,
      NULL,
      NULL,
      2.134791,
      NULL,
      11,
      1,
      4,
      5,
      1.082208,
      1.515962,
      1.907545,
      13228,
      1541,
      1.916542,
      NULL,
      0.487101,
      0.617547,
      0,
      1.601956,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0.382249,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.756995,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.284951,
      NULL,
      0,
      NULL,
      1.241670,
      NULL,
      NULL,
      NULL,
      0.818583,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.331865,
      0,
      0.608560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321361,
      2,
      NULL,
      NULL,
      NULL,
      0.000141,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      0.492456,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.424926,
      NULL,
      0.957224,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.904695,
      NULL,
      NULL,
      3,
      1,
      0,
      2.846990,
      3,
      0,
      1.619569,
      NULL,
      NULL,
      0.992815,
      0,
      NULL,
      0.518829,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.721771,
      NULL,
      NULL,
      1.862319,
      3.972832,
      NULL,
      1.480342,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.235872,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951062,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      78,
      47.440679,
      1,
      1.858339,
      3,
      '13142',
      '22133',
      NULL,
      1.040319,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


