set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8220268';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      '2402',
      1,
      NULL,
      NULL,
      NULL,
      ' 7- 2-1988',
      41.168580,
      NULL,
      NULL,
      2,
      0,
      ' 9- 2-1990',
      26.055317,
      NULL,
      258,
      57,
      0,
      ' 5- 7-1994',
      ' 9- 0-1990',
      '11-26-1983',
      NULL,
      2.839519,
      3.470477,
      1,
      NULL,
      3.507612,
      1,
      NULL,
      1,
      329.753837,
      2,
      16,
      NULL,
      169.984321,
      167.890090,
      1,
      NULL,
      0,
      2,
      10.705683,
      0,
      1,
      1,
      0.188411,
      1,
      1,
      0,
      NULL,
      0.398484,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      1,
      2,
      1,
      1,
      5,
      1,
      NULL,
      NULL,
      0,
      1,
      6.262334,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      4,
      3.817043,
      1,
      0.843157,
      2,
      3.429655,
      1,
      3,
      0,
      NULL,
      1.375496,
      1,
      0.261556,
      1,
      0.805119,
      2.561722,
      1.409644,
      2.020036,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.121878,
      NULL,
      NULL,
      0.810719,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      1,
      1,
      1,
      1,
      1,
      NULL,
      4,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      4.915575,
      NULL,
      2,
      2,
      5,
      1,
      NULL,
      1,
      0,
      4,
      1,
      4,
      NULL,
      NULL,
      0,
      3,
      0,
      4,
      5,
      0,
      NULL,
      0,
      3,
      1,
      5,
      1,
      2,
      3,
      NULL,
      1,
      ' 4-28-1993',
      248,
      ' 1-17-1995',
      318,
      2,
      NULL,
      1,
      4,
      4,
      2,
      NULL,
      1,
      2,
      1,
      0,
      2,
      NULL,
      0,
      1,
      1,
      1,
      1.816635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3,
      0.305141,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2,
      1,
      1.901686,
      3,
      1.918538,
      1,
      6.395488,
      0,
      NULL,
      6.355715,
      4.809080,
      NULL,
      NULL,
      NULL,
      NULL,
      7.490146,
      0.241743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909768,
      0.678319,
      2.089518,
      NULL,
      1,
      0,
      2.364760,
      58,
      2,
      2,
      NULL,
      105,
      4.409277,
      3,
      0,
      3.499220,
      3,
      2,
      1,
      NULL,
      2,
      3,
      NULL,
      3,
      3,
      1,
      0.415909,
      4,
      2.026893,
      46,
      75.145039,
      158.995447,
      NULL,
      60,
      61,
      0.306107,
      1,
      1.961070,
      1.073877,
      0.663693,
      0,
      NULL,
      0.082157,
      1.606090,
      0,
      3,
      10.122105,
      NULL,
      4,
      10.548675,
      3,
      0,
      1,
      6,
      0.551169,
      0,
      1,
      16.902189,
      2,
      0.640647,
      NULL,
      46,
      5,
      71.222616,
      4,
      NULL,
      3,
      '10041',
      '',
      '',
      0,
      '',
      NULL,
      '',
      3.397358,
      '12041',
      '',
      '',
      NULL,
      20,
      391.654979,
      6,
      2.955137,
      21.535008,
      NULL,
      97.309393,
      3,
      1.169681,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.070203,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.072340,
      1.102425,
      NULL,
      NULL,
      0.285288,
      NULL,
      NULL,
      1.639001,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      9.191403,
      NULL,
      1,
      1.857632,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.199946,
      0,
      0.653309,
      3.665740,
      1,
      NULL,
      NULL,
      1.450243,
      3.907191,
      0.183673,
      0.417508,
      NULL,
      0.683518,
      3.198696,
      3.096592,
      2.135391,
      1.821330,
      0.944292,
      1,
      NULL,
      0.800130,
      3.306230,
      1.122550,
      0.097626,
      NULL,
      NULL,
      1.808431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4.979616,
      5.873515,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.727781,
      3.992720,
      NULL,
      2,
      0.991058,
      1.997108,
      NULL,
      NULL,
      5.988207,
      4,
      1,
      1.457523,
      0,
      NULL,
      NULL,
      0.774234,
      0,
      2.813470,
      4,
      1,
      1.323377,
      NULL,
      NULL,
      1.289929,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.328920,
      0.862146,
      7,
      NULL,
      NULL,
      0,
      2.516075,
      0.108775,
      0,
      5,
      1.006162,
      NULL,
      5.965495,
      1,
      4,
      7.808421,
      0,
      2.704657,
      NULL,
      0,
      1,
      0,
      0.740736,
      3,
      0.272315,
      0,
      NULL,
      NULL,
      0.339599,
      6,
      NULL,
      3,
      0.422025,
      NULL,
      3,
      3,
      0,
      2,
      2.507403,
      3.342534,
      2.856426,
      0,
      NULL,
      NULL,
      8.995257,
      NULL,
      0.226681,
      1.416036,
      3.493701,
      NULL,
      0,
      0.102348,
      1,
      NULL,
      0,
      0.618240,
      2,
      NULL,
      NULL,
      2.949329,
      NULL,
      NULL,
      0.336390,
      NULL,
      NULL,
      1.268655,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.614360,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.082986,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726636,
      NULL,
      0,
      1,
      1.487292,
      1.348898,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.428530,
      NULL,
      NULL,
      NULL,
      2.460176,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.074526,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274789,
      NULL,
      NULL,
      NULL,
      0.942845,
      NULL,
      NULL,
      NULL,
      1.467630,
      0.693041,
      NULL,
      NULL,
      0,
      1.556687,
      NULL,
      NULL,
      1.203347,
      2.013442,
      NULL,
      NULL,
      3,
      0.075683,
      NULL,
      NULL,
      0.823583,
      1.444697,
      NULL,
      NULL,
      NULL,
      0.716222,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      7,
      2.374111,
      NULL,
      NULL,
      0,
      1,
      8,
      3,
      0.256667,
      NULL,
      NULL,
      0.195611,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      19.190021,
      2.965195,
      0,
      NULL,
      NULL,
      3,
      15,
      NULL,
      0.114310,
      NULL,
      1.493267,
      NULL,
      17,
      1,
      0,
      0.479028,
      NULL,
      1.143611,
      0.063634,
      NULL,
      0.151932,
      NULL,
      0.455386,
      0.060744,
      NULL,
      0,
      NULL,
      0,
      1,
      1.329264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881244,
      0.414594,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.135302,
      0.502308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370315,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989695,
      0.087188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.992113,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0.385819,
      NULL,
      NULL,
      NULL,
      0.415753,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      0.989001,
      0,
      NULL,
      3,
      15,
      1,
      NULL,
      2,
      NULL,
      0,
      0,
      0.153016,
      1,
      0.703297,
      0,
      3,
      1.260721,
      1.341523,
      1.845543,
      0.089879,
      0,
      2.996008,
      0,
      1,
      1,
      NULL,
      1.861394,
      1.967883,
      1.261125,
      0.275784,
      NULL,
      1,
      1.631653,
      NULL,
      1.134718,
      NULL,
      1.516624,
      1,
      1,
      0,
      1,
      0,
      2,
      1.633983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.283509,
      0.256631,
      NULL,
      1.330846,
      NULL,
      5,
      NULL,
      2.877500,
      0.151309,
      NULL,
      NULL,
      47,
      2,
      1.182835,
      NULL,
      '13404',
      '',
      '',
      1.950525,
      NULL,
      '',
      '',
      2,
      '03013',
      NULL,
      '');
commit;
end;
/


