set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '12',
      '22',
      21.269339,
      14.190394,
      '2314020',
      NULL,
      1,
      4,
      1,
      '0004',
      2.873749,
      1,
      NULL,
      NULL,
      NULL,
      9.886095,
      46.295627,
      NULL,
      NULL,
      14,
      '10-18-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 8-15-1996',
      ' 7-16-1982',
      ' 3-26-2002',
      2,
      0,
      1.092422,
      2,
      NULL,
      1.879782,
      1,
      NULL,
      NULL,
      10,
      0,
      18,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0.593258,
      NULL,
      NULL,
      3,
      1,
      1,
      2.018375,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1.995549,
      0,
      0,
      NULL,
      1,
      1.380042,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      0.738958,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.790380,
      1.787350,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.496404,
      NULL,
      0.241490,
      1,
      0,
      NULL,
      3.407435,
      0,
      1,
      1.220387,
      1.395093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1.460093,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      2,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      4,
      4,
      0,
      3,
      2,
      3,
      NULL,
      0,
      0,
      1,
      ' 7-19-1992',
      NULL,
      ' 6- 1-2002',
      NULL,
      3,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5,
      3.486285,
      0,
      4,
      1,
      1.616061,
      3.470480,
      NULL,
      0,
      NULL,
      0.415529,
      1.953953,
      1.232028,
      0,
      1,
      4,
      1.607550,
      10.166125,
      2,
      NULL,
      5.847457,
      1.241938,
      NULL,
      NULL,
      NULL,
      0.164675,
      6.688317,
      1.316606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032381,
      1.800845,
      1,
      1,
      1,
      0.656720,
      0.875091,
      NULL,
      12,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.334051,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2,
      1,
      1,
      NULL,
      3,
      3.401335,
      2.080994,
      2,
      6,
      0,
      NULL,
      NULL,
      1.624708,
      NULL,
      5.573900,
      NULL,
      0.106702,
      0,
      1,
      1,
      1,
      1,
      5.341851,
      1.479153,
      8,
      1.966818,
      2,
      8.759211,
      NULL,
      4.387668,
      0,
      1.857134,
      4.419470,
      0,
      3,
      1.000390,
      8,
      0,
      0.933659,
      48,
      NULL,
      9,
      33,
      NULL,
      0.340200,
      1,
      '41120',
      '',
      '',
      1.942522,
      '',
      '',
      NULL,
      0.620237,
      '',
      '',
      '',
      3.256309,
      9,
      184,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.525430,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.570754,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.244572,
      NULL,
      NULL,
      0.132520,
      NULL,
      NULL,
      1.157134,
      NULL,
      NULL,
      1.611106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457180,
      NULL,
      NULL,
      3,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.740592,
      NULL,
      NULL,
      NULL,
      1.540316,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692897,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.731727,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.518502,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.756742,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.658561,
      NULL,
      NULL,
      0.423211,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.106510,
      1.757791,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0.049835,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358223,
      NULL,
      NULL,
      NULL,
      2.899953,
      1.377925,
      2,
      0.169595,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.944009,
      0.298548,
      NULL,
      0.715992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.845867,
      484.983429,
      1,
      NULL,
      NULL,
      1,
      0.752692,
      1.522211,
      NULL,
      0.914348,
      0.316498,
      NULL,
      0,
      1.358510,
      1,
      0,
      0.707186,
      0,
      1.085399,
      1.346046,
      0.359594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      7,
      NULL,
      1.457398,
      0.986673,
      0,
      NULL,
      1,
      NULL,
      0.351445,
      0,
      1.427069,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.254203,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.193144,
      NULL,
      NULL,
      1,
      NULL,
      0.787806,
      0,
      NULL,
      1.243613,
      1.302241,
      NULL,
      NULL,
      0,
      NULL,
      1.682737,
      0.670073,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.375354,
      NULL,
      0,
      NULL,
      0.028999,
      NULL,
      1,
      2,
      5,
      0.800108,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      1,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0.075693,
      '',
      '',
      NULL);
commit;
end;
/


