set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      '033',
      '10311011',
      45.891072,
      4.455862,
      '0141441',
      1,
      1,
      2,
      1,
      NULL,
      5.121145,
      0,
      NULL,
      NULL,
      ' 1-26-1983',
      NULL,
      54,
      NULL,
      3.609404,
      1.686120,
      ' 4-26-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 7- 1-1977',
      NULL,
      ' 2-23-1997',
      0.253562,
      2,
      3.707880,
      1.124515,
      1,
      0.750559,
      3,
      NULL,
      1.337161,
      1,
      3,
      13.827970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0,
      0,
      0,
      1,
      0.985601,
      0.998433,
      0,
      0,
      1.226758,
      0.559817,
      1.509664,
      2,
      2,
      NULL,
      1.959398,
      2,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      5.930295,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.271833,
      NULL,
      1.036075,
      1.480272,
      0,
      3.755248,
      1,
      0,
      0.097655,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.235347,
      2,
      2,
      NULL,
      0,
      NULL,
      11.272124,
      1,
      0,
      0.299002,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      1,
      1,
      5,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.010212,
      NULL,
      4,
      1,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      1,
      0,
      2,
      1,
      0,
      1,
      1,
      5,
      4,
      5,
      1,
      2,
      0,
      1,
      1,
      0,
      5,
      NULL,
      ' 5-27-1983',
      972,
      ' 5- 7-1988',
      9.902858,
      2,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      1.506934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.322459,
      1.282052,
      2.600115,
      2.175999,
      4.191934,
      1.209612,
      NULL,
      NULL,
      NULL,
      0.757558,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577428,
      1.587288,
      0,
      1.498164,
      1,
      1,
      0,
      3.189194,
      NULL,
      0.082455,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      2,
      3,
      0,
      2,
      3,
      2,
      0,
      1,
      2.513365,
      0.978438,
      1.219961,
      4,
      NULL,
      0.329147,
      NULL,
      0.984891,
      NULL,
      3.294145,
      1.202052,
      NULL,
      0.922936,
      NULL,
      0,
      1,
      1.666380,
      NULL,
      1.525616,
      6.934117,
      5.442169,
      3,
      4,
      1.646330,
      0.378455,
      2.649658,
      0,
      4,
      2.886546,
      0,
      1,
      NULL,
      2,
      3,
      45,
      NULL,
      25,
      54.941519,
      4,
      3.562600,
      2,
      '33420',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.243225,
      '',
      '',
      NULL,
      1.915250,
      38,
      192,
      NULL,
      1,
      30.371800,
      NULL,
      0,
      2,
      0,
      NULL,
      0.622917,
      0,
      NULL,
      NULL,
      1.196237,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.300249,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      0.807631,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547533,
      NULL,
      NULL,
      9.499180,
      3.093932,
      1.930217,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.266541,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.377704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.911087,
      2,
      2,
      2,
      NULL,
      0,
      0.736573,
      0.051064,
      NULL,
      NULL,
      1.599537,
      NULL,
      2.336921,
      1.108236,
      0.667785,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.098596,
      NULL,
      NULL,
      NULL,
      1.358966,
      1,
      NULL,
      0.254251,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.515765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.093004,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.086700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.753353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.567009,
      0,
      NULL,
      2.276849,
      NULL,
      1,
      9.954260,
      1,
      NULL,
      4.267216,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584001,
      NULL,
      NULL,
      1,
      1.178095,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.535845,
      1,
      NULL,
      NULL,
      1,
      1.792743,
      NULL,
      0,
      0.917611,
      2,
      0.461777,
      NULL,
      3,
      NULL,
      NULL,
      1.012079,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1,
      NULL,
      0.616550,
      1,
      1.646323,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.230479,
      NULL,
      NULL,
      1.993293,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.809579,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.532921,
      1,
      NULL,
      0,
      0.508152,
      1,
      NULL,
      NULL,
      1.861373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.476111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153251,
      NULL,
      NULL,
      NULL,
      3.137959,
      NULL,
      NULL,
      NULL,
      0.299138,
      NULL,
      NULL,
      NULL,
      1.454892,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.636803,
      0.241410,
      NULL,
      NULL,
      1.219338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.779273,
      NULL,
      0,
      NULL,
      0.348277,
      1.844793,
      1,
      0.109191,
      1.990022,
      0.078700,
      NULL,
      0.509857,
      0,
      NULL,
      NULL,
      1,
      1.142850,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      0,
      1.332665,
      3,
      5.733504,
      2.049448,
      0,
      1.380048,
      0.173801,
      0.031816,
      NULL,
      NULL,
      0,
      1.590833,
      1,
      1,
      1,
      0.773638,
      NULL,
      0.707031,
      0.760891,
      1,
      2,
      0.726834,
      1,
      NULL,
      1.649877,
      0,
      0.448758,
      0.069755,
      1.342093,
      NULL,
      1,
      1.261103,
      NULL,
      1,
      1,
      3,
      1,
      0.348438,
      0.374703,
      0,
      3.208688,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860897,
      0,
      0,
      0,
      0.153343,
      1,
      4,
      5,
      1,
      0,
      1.635868,
      NULL,
      5,
      14.158123,
      NULL,
      4.574122,
      3.609971,
      '13410',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.782252,
      '',
      '',
      '');
commit;
end;
/


