set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6802799';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '0233444',
      0,
      0.147568,
      NULL,
      NULL,
      '4440',
      3,
      NULL,
      4.562549,
      9,
      ' 6- 0-2000',
      51,
      NULL,
      3,
      0.306184,
      0,
      ' 7- 3-1983',
      7.658832,
      2,
      124,
      143.597017,
      4,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      0,
      0.034090,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4.769815,
      21,
      23,
      4,
      NULL,
      2,
      1,
      2.156947,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      0.611613,
      1.649893,
      0.054971,
      0,
      5,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      4,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0.338932,
      NULL,
      NULL,
      1,
      NULL,
      0.228481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.821552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1.786996,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      2,
      0,
      0,
      0,
      0,
      NULL,
      3,
      0,
      4,
      4,
      5,
      5,
      1,
      0,
      NULL,
      0.569335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0.929511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662012,
      0,
      1,
      0.538486,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290600,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2,
      3,
      3,
      NULL,
      0,
      2,
      0,
      1,
      1,
      3,
      3,
      NULL,
      0.221537,
      1.083907,
      1.643847,
      3.770503,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      0.327269,
      0.499877,
      NULL,
      NULL,
      1.450923,
      0,
      1.165170,
      4,
      NULL,
      7.963427,
      6.674943,
      3.483750,
      7.362804,
      0.487944,
      0,
      5,
      0.536190,
      NULL,
      1.344521,
      NULL,
      3,
      1,
      58,
      NULL,
      NULL,
      NULL,
      4,
      1.604267,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '02113',
      '',
      '',
      NULL,
      '12221',
      '1213',
      '',
      0.521513,
      4,
      151.047179,
      23,
      1.034453,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.921363,
      NULL,
      NULL,
      0.388701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698317,
      0,
      3.355038,
      NULL,
      1.039919,
      1.458474,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.258418,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171907,
      5.294586,
      3,
      1,
      0,
      1.316605,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.781777,
      NULL,
      NULL,
      1.846729,
      NULL,
      NULL,
      0.761156,
      NULL,
      NULL,
      0.106673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925172,
      NULL,
      NULL,
      1.885587,
      1,
      1,
      NULL,
      NULL,
      NULL,
      5.989828,
      1,
      NULL,
      1,
      0.079163,
      NULL,
      NULL,
      NULL,
      1.540409,
      NULL,
      NULL,
      NULL,
      0.714366,
      NULL,
      NULL,
      1.762858,
      NULL,
      NULL,
      3.347313,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.423875,
      0,
      3.008200,
      9.611634,
      11,
      1.584936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416383,
      NULL,
      NULL,
      0.508637,
      NULL,
      NULL,
      1.590395,
      NULL,
      NULL,
      0.960194,
      NULL,
      NULL,
      3.419188,
      2,
      2.430335,
      0,
      NULL,
      0,
      6,
      3.093826,
      1,
      4.819267,
      2,
      0,
      1.445894,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.986957,
      1.084344,
      0.421097,
      3,
      1,
      NULL,
      0.321665,
      2,
      1,
      2,
      0,
      1,
      2.041847,
      3,
      1.326123,
      2.115412,
      NULL,
      0.787944,
      0.342705,
      NULL,
      7,
      0.660299,
      0.393799,
      NULL,
      0.237797,
      NULL,
      NULL,
      1,
      0.895599,
      NULL,
      0.119738,
      0.305131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.060133,
      0,
      0,
      0.624367,
      1.513772,
      NULL,
      0.874245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.995267,
      0.801157,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807182,
      NULL,
      0.136930,
      1.760940,
      NULL,
      0,
      NULL,
      1.053962,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.599750,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2,
      1.304345,
      5,
      1,
      7.030723,
      0,
      0.591957,
      0.016178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754377,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.253578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.504047,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.152349,
      1,
      NULL,
      3.817714,
      NULL,
      1.616688,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.710655,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.352448,
      NULL,
      3,
      NULL,
      2.550231,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      51,
      NULL,
      6,
      0.124450,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.071994,
      NULL,
      115,
      0,
      0.009277,
      NULL,
      '13034',
      '',
      '',
      2.526257,
      '40014',
      '',
      '',
      4.642007,
      '10334',
      '1213',
      '');
commit;
end;
/


