set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106245';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '3010420',
      2.604507,
      1,
      0,
      3,
      NULL,
      2,
      1.118987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.776953,
      NULL,
      ' 1-22-1996',
      43,
      3.970043,
      75,
      NULL,
      1,
      ' 3-14-1974',
      '11-23-1975',
      NULL,
      2.656495,
      NULL,
      1,
      NULL,
      NULL,
      1.694382,
      0,
      1.039157,
      1.812669,
      154.780968,
      5,
      NULL,
      6,
      13.641212,
      8,
      NULL,
      5,
      2,
      2,
      0.585407,
      0,
      1,
      1,
      1.039337,
      0,
      0,
      0,
      1,
      1.207973,
      NULL,
      134,
      8,
      NULL,
      1,
      0.155350,
      NULL,
      0,
      1,
      5,
      NULL,
      4,
      NULL,
      1,
      2,
      1,
      NULL,
      1,
      2.240968,
      0,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      4,
      1,
      4,
      0,
      NULL,
      0,
      0,
      5,
      0,
      7.272762,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      2,
      0,
      1,
      0,
      4,
      NULL,
      2,
      NULL,
      4,
      0,
      1,
      NULL,
      2,
      2,
      0,
      0,
      0,
      3,
      5,
      1,
      4,
      0,
      2,
      5,
      0.913639,
      0,
      '10-27-1978',
      738,
      ' 1-10-1978',
      652,
      2,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961680,
      NULL,
      0,
      0.548151,
      1.496545,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657781,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.512071,
      NULL,
      2,
      NULL,
      NULL,
      0.725109,
      0.014635,
      22.519999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      2,
      3,
      3,
      0,
      3,
      3,
      1,
      2,
      NULL,
      NULL,
      2,
      3,
      0,
      0.069978,
      0.354222,
      NULL,
      1,
      0,
      1.212714,
      NULL,
      NULL,
      0.957523,
      1.317684,
      NULL,
      0,
      NULL,
      0.413499,
      1.317585,
      11,
      3.686910,
      4,
      5.439269,
      11.803992,
      4,
      0.698626,
      2,
      3,
      0,
      2.153937,
      NULL,
      19,
      NULL,
      1,
      NULL,
      45,
      NULL,
      NULL,
      NULL,
      1.170141,
      4.317639,
      NULL,
      '2313',
      '',
      0.369315,
      '',
      '',
      '',
      0.868655,
      NULL,
      '',
      '',
      0,
      6.024731,
      NULL,
      14,
      NULL,
      12,
      2.287983,
      50.172469,
      NULL,
      0.415493,
      NULL,
      2,
      0.739568,
      NULL,
      NULL,
      1.127319,
      NULL,
      NULL,
      0,
      0.111866,
      NULL,
      0.553789,
      NULL,
      NULL,
      1.846940,
      1,
      2.777928,
      0,
      NULL,
      NULL,
      0.600007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973882,
      NULL,
      NULL,
      1.460037,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.349859,
      7.956019,
      6.242969,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.722308,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.762950,
      NULL,
      NULL,
      0.212081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490581,
      NULL,
      NULL,
      0.812113,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.617250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683992,
      NULL,
      NULL,
      3.911445,
      NULL,
      2,
      3,
      3.198474,
      2,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      1.911150,
      NULL,
      2.094535,
      2,
      3,
      NULL,
      NULL,
      2.813575,
      NULL,
      NULL,
      NULL,
      1.107241,
      NULL,
      NULL,
      1.302304,
      NULL,
      NULL,
      0.450456,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.560382,
      2.231209,
      2.088601,
      NULL,
      1.986643,
      NULL,
      NULL,
      NULL,
      4,
      1.627386,
      5,
      0.820281,
      NULL,
      NULL,
      3.472621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      6,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      2.857101,
      3,
      1,
      NULL,
      3.412417,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521176,
      1,
      1,
      1.273753,
      1,
      0,
      0.019790,
      0.775186,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.489620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.300375,
      NULL,
      NULL,
      1.210485,
      NULL,
      NULL,
      1.265139,
      NULL,
      NULL,
      1,
      1,
      0.414267,
      NULL,
      1.870954,
      1.287205,
      0,
      NULL,
      NULL,
      1.953937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.823973,
      NULL,
      NULL,
      NULL,
      0.628478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.574403,
      NULL,
      NULL,
      NULL,
      2.206276,
      223,
      46.869668,
      0,
      NULL,
      NULL,
      0.421039,
      NULL,
      NULL,
      3.111427,
      NULL,
      0,
      1.674157,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      181,
      NULL,
      1.673477,
      1,
      0.312565,
      0.533375,
      0.010205,
      1.839077,
      0,
      0.509224,
      0,
      1,
      0,
      0.418991,
      1.113716,
      NULL,
      1.495151,
      0.445679,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      0.041563,
      NULL,
      3,
      9,
      3,
      NULL,
      1,
      0,
      1.147487,
      NULL,
      1,
      0.449594,
      NULL,
      1,
      1,
      NULL,
      1.408993,
      1,
      NULL,
      NULL,
      2.628456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109563,
      NULL,
      1.831304,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.071096,
      1,
      NULL,
      3,
      0,
      1.611608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175555,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4,
      6,
      5,
      0,
      1.914763,
      0.403456,
      75,
      8,
      5,
      0.989546,
      2,
      '40212',
      '4324',
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


