set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655289';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.896739,
      0,
      1,
      2,
      NULL,
      3.628556,
      2,
      NULL,
      '02314030',
      29,
      NULL,
      '1000220',
      1,
      0.667448,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-17-1980',
      216,
      19.532960,
      NULL,
      2.727127,
      2.781539,
      ' 3-20-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 5-11-1979',
      '11- 2-2001',
      NULL,
      NULL,
      1,
      1.216328,
      1.788734,
      NULL,
      0.148441,
      4,
      NULL,
      NULL,
      9.374863,
      6,
      12.717340,
      4.212287,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.882941,
      0,
      0,
      1.131525,
      1.046294,
      NULL,
      1,
      2.331094,
      1.027397,
      0,
      NULL,
      0,
      3,
      5,
      1,
      2,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1.821127,
      NULL,
      NULL,
      1,
      NULL,
      9.716018,
      0.984237,
      0.535101,
      NULL,
      0.648004,
      3.796290,
      0,
      3.355294,
      3.019677,
      0.006806,
      0.458567,
      1,
      0.452085,
      2,
      3,
      0,
      1.831663,
      1,
      1,
      1,
      8,
      0,
      1,
      1.246132,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      4,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0.002648,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      5,
      1,
      5,
      NULL,
      1,
      5,
      NULL,
      5,
      1.073394,
      3.321047,
      NULL,
      355.005180,
      NULL,
      365,
      3.480479,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.962627,
      2,
      NULL,
      NULL,
      NULL,
      3,
      7,
      3.626436,
      0.265171,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.352605,
      1.439242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.765046,
      1,
      1.230201,
      NULL,
      0,
      1.912022,
      1,
      1,
      21,
      1.644629,
      0.064030,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.813351,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2,
      3,
      2,
      0,
      NULL,
      1.896432,
      NULL,
      NULL,
      NULL,
      0.307668,
      NULL,
      0,
      0.176496,
      0,
      1,
      1,
      1.602600,
      0,
      NULL,
      0,
      1,
      0.966055,
      0,
      NULL,
      7,
      5.008233,
      6,
      NULL,
      4,
      4.212532,
      3.229762,
      5.025503,
      0,
      3.086178,
      2,
      NULL,
      0,
      3,
      6,
      NULL,
      NULL,
      6,
      NULL,
      3,
      NULL,
      '11214',
      '20240',
      '40132',
      0,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.464222,
      11.349154,
      NULL,
      15.095771,
      1,
      20,
      18.431180,
      3.638862,
      1,
      0.678838,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.323129,
      NULL,
      NULL,
      2,
      1.882766,
      1,
      1,
      NULL,
      NULL,
      0.424637,
      NULL,
      NULL,
      2.042010,
      3.832140,
      2,
      0.512349,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.084765,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.588666,
      NULL,
      NULL,
      3.739797,
      3,
      5,
      NULL,
      0.358206,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.263475,
      NULL,
      NULL,
      NULL,
      1,
      0.651489,
      NULL,
      3,
      2,
      2,
      1.111937,
      0.801918,
      0,
      0.298655,
      3.265992,
      NULL,
      0,
      NULL,
      2.877363,
      1,
      0.947639,
      NULL,
      NULL,
      1.438947,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      6,
      1.378253,
      3,
      3,
      1.129082,
      NULL,
      NULL,
      NULL,
      1.666501,
      NULL,
      NULL,
      NULL,
      2,
      1.069433,
      1.812446,
      0.823092,
      0,
      1.121797,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.291432,
      2,
      NULL,
      2.690489,
      1,
      NULL,
      NULL,
      3.412828,
      0.380087,
      0,
      1,
      NULL,
      NULL,
      1.297005,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293445,
      NULL,
      NULL,
      0.762059,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      0.228835,
      5.052222,
      0,
      NULL,
      6,
      1,
      NULL,
      6,
      0.109792,
      0,
      1.409214,
      3.052882,
      1,
      NULL,
      3,
      NULL,
      2.364124,
      1.677673,
      0.078345,
      2,
      4,
      0,
      3,
      1,
      0.639748,
      NULL,
      1.113022,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      2,
      5,
      5,
      NULL,
      0,
      0,
      1.269720,
      2.177229,
      2,
      4,
      NULL,
      1.475988,
      1,
      0,
      0.841534,
      2.209617,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.055936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.536599,
      NULL,
      NULL,
      7.759851,
      NULL,
      NULL,
      0,
      0,
      0.866348,
      1,
      1.513088,
      1.902566,
      0.744663,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.447703,
      NULL,
      NULL,
      NULL,
      0.671792,
      NULL,
      NULL,
      NULL,
      0.027301,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.104465,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.683494,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.605516,
      NULL,
      NULL,
      NULL,
      1.026253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      2,
      2,
      60.144195,
      23,
      1,
      NULL,
      NULL,
      0.510061,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      1.303939,
      NULL,
      NULL,
      1.980509,
      23,
      1,
      90.386355,
      11,
      3.224379,
      1.787225,
      3,
      0,
      0,
      0,
      0,
      1,
      1.470507,
      1,
      NULL,
      0,
      NULL,
      1.251434,
      0,
      0.570138,
      2,
      0.715213,
      0.913316,
      NULL,
      3.967146,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      74.372048,
      NULL,
      3.635961,
      NULL,
      15,
      NULL,
      0,
      3.491167,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304404,
      NULL,
      0.741240,
      NULL,
      1.296496,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.458136,
      NULL,
      2.043517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.492531,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776188,
      1.703898,
      0,
      NULL,
      0,
      NULL,
      0.725348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885571,
      NULL,
      1,
      0.577723,
      0.769937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.149194,
      NULL,
      1,
      NULL,
      0.528290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.431404,
      0.371037,
      NULL,
      2,
      NULL,
      494.383470,
      NULL,
      3.339240,
      NULL,
      1.969926,
      NULL,
      2,
      NULL,
      2,
      NULL,
      37.156566,
      NULL,
      NULL,
      0,
      3.607831,
      1,
      3,
      3,
      1,
      4.136723,
      2.745897,
      0,
      0,
      NULL,
      5.661777,
      NULL,
      2,
      0.430155,
      1.580150,
      0.166957,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2.081082,
      NULL,
      0,
      0.772284,
      NULL,
      0.596839,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.453136,
      NULL,
      3,
      2.892590,
      NULL,
      0,
      1.926196,
      NULL,
      1.168692,
      0.651321,
      NULL,
      1.790513,
      2.610024,
      NULL,
      2.942432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274123,
      NULL,
      0,
      NULL,
      1.863208,
      NULL,
      4,
      6,
      1,
      NULL,
      NULL,
      NULL,
      30,
      24,
      4,
      0.306394,
      NULL,
      NULL,
      '21002',
      '43120',
      0.584510,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


