set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8724508';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1133041',
      3,
      1.494679,
      NULL,
      2,
      '4041',
      NULL,
      1.379766,
      NULL,
      NULL,
      ' 5-21-1994',
      23,
      NULL,
      2,
      NULL,
      0.050141,
      '11-26-2001',
      12,
      NULL,
      108.330429,
      141,
      3,
      ' 2-19-1989',
      ' 6-23-1992',
      NULL,
      1,
      0.115361,
      0,
      3,
      0,
      1.125360,
      3,
      0,
      NULL,
      9,
      0,
      12.839057,
      6,
      33.521648,
      NULL,
      5,
      0,
      5,
      3,
      NULL,
      0.097432,
      1,
      2,
      0.497240,
      1.486144,
      0,
      0,
      0.820433,
      NULL,
      0.304199,
      0,
      5,
      NULL,
      3,
      NULL,
      2,
      0,
      1,
      0,
      2,
      NULL,
      4,
      1,
      1,
      3,
      0,
      5,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1.646070,
      NULL,
      NULL,
      0.250794,
      2,
      1,
      1,
      1,
      1,
      1.106934,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629216,
      0,
      0.370095,
      1.136608,
      0,
      0.544607,
      3.326204,
      2.447332,
      NULL,
      0,
      0,
      3.674838,
      1,
      NULL,
      0,
      0.978344,
      NULL,
      NULL,
      0.494663,
      2,
      1,
      1,
      0,
      2,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      3.491477,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      0,
      0,
      1,
      4,
      1,
      1,
      1,
      0,
      3,
      2,
      1,
      5,
      NULL,
      NULL,
      0,
      NULL,
      3,
      5,
      NULL,
      NULL,
      889,
      '10-28-1979',
      59,
      NULL,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0.219941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.644745,
      7,
      1.894302,
      NULL,
      5.433995,
      4,
      1.309918,
      NULL,
      NULL,
      0,
      6.665061,
      0.222253,
      1,
      1,
      1,
      4.232055,
      ' 5-18-1988',
      10.698049,
      ' 0- 1-1980',
      NULL,
      0.958095,
      0,
      1,
      0,
      NULL,
      0.401123,
      1.301876,
      0,
      0.591530,
      0.686378,
      NULL,
      NULL,
      NULL,
      1.418525,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.573894,
      0,
      3,
      3,
      2,
      0,
      0,
      3,
      NULL,
      2,
      3,
      2,
      12.811277,
      1,
      0,
      0.477398,
      0,
      2,
      NULL,
      1.753815,
      1.214927,
      1,
      0.891255,
      0.481744,
      1,
      NULL,
      1,
      1.857722,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      10,
      2,
      0,
      NULL,
      1,
      1,
      1,
      1,
      25.404236,
      1,
      3.838639,
      NULL,
      41,
      47,
      55.980996,
      4,
      1.612557,
      1,
      '44144',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.326345,
      '',
      NULL,
      '',
      1.582302,
      31.068326,
      NULL,
      28,
      1.993190,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695591,
      0.699170,
      NULL,
      1.163502,
      NULL,
      NULL,
      1.462377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.122592,
      NULL,
      0.332453,
      0.571453,
      NULL,
      3.416697,
      1.266178,
      1,
      3,
      1,
      2.510114,
      NULL,
      2.182562,
      3,
      0,
      1,
      1.842433,
      2.329261,
      4.776075,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.163090,
      2.369324,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.657097,
      NULL,
      0.909282,
      0,
      NULL,
      1.498868,
      2.612150,
      0,
      1,
      NULL,
      0,
      3.447913,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.315539,
      NULL,
      NULL,
      0,
      3,
      0,
      6.955140,
      2.056809,
      3,
      2,
      1.187967,
      NULL,
      NULL,
      NULL,
      0.543851,
      NULL,
      NULL,
      NULL,
      3,
      1.531075,
      0.080730,
      NULL,
      0.920515,
      0,
      2.396843,
      1.312042,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031967,
      NULL,
      NULL,
      1.776694,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.404797,
      NULL,
      NULL,
      0.012228,
      NULL,
      NULL,
      0.865505,
      NULL,
      NULL,
      NULL,
      1,
      0.883643,
      0.823475,
      1.184864,
      0,
      6.471776,
      NULL,
      1.226181,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.086139,
      1.398832,
      3,
      3,
      NULL,
      0.307682,
      4,
      3.086131,
      0,
      0.358573,
      0,
      NULL,
      NULL,
      NULL,
      1.042321,
      NULL,
      1.675285,
      2.102740,
      0.377906,
      NULL,
      0.081903,
      NULL,
      1.218678,
      9.840237,
      NULL,
      3.768198,
      4,
      0.220610,
      0,
      NULL,
      0,
      0.254566,
      NULL,
      1,
      0.440333,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3.893233,
      NULL,
      NULL,
      1.414868,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.994531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.600142,
      NULL,
      NULL,
      0.783816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521978,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717313,
      0.264406,
      0.914207,
      0.810828,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.969809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.408715,
      NULL,
      NULL,
      NULL,
      0.485310,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0.086816,
      NULL,
      NULL,
      NULL,
      2.381832,
      0.418351,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.356602,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.914651,
      NULL,
      NULL,
      1,
      1.864823,
      1,
      0.397358,
      1,
      NULL,
      NULL,
      1.441237,
      1.992447,
      0.847838,
      1.416095,
      NULL,
      0.497070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      4.714272,
      2,
      2,
      2.216756,
      3,
      3.445965,
      1,
      0.944529,
      1,
      0,
      1.159071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045736,
      0,
      NULL,
      0.589353,
      0.369240,
      NULL,
      2.960132,
      3.110559,
      NULL,
      NULL,
      0,
      NULL,
      1.450329,
      NULL,
      NULL,
      1,
      0.581412,
      NULL,
      1.485715,
      1,
      NULL,
      0,
      0.895198,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.558915,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.247678,
      NULL,
      0,
      NULL,
      0.464421,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.911356,
      NULL,
      75,
      0.321065,
      984,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.487801,
      0.800612,
      2,
      87.194181,
      NULL,
      5,
      1.588715,
      2.287094,
      '43031',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


