set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8724508';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '1443201',
      0,
      0,
      2,
      NULL,
      '2411',
      3,
      NULL,
      NULL,
      NULL,
      ' 0-17-1974',
      12.085967,
      NULL,
      5,
      1,
      NULL,
      '11-22-1974',
      44.034939,
      1.532030,
      131,
      66.640946,
      3,
      NULL,
      ' 1- 0-1975',
      ' 8-27-1997',
      3,
      0.511782,
      2.090556,
      NULL,
      0,
      0,
      5,
      1,
      0,
      6,
      8,
      4,
      1,
      25.851884,
      1.810349,
      3,
      25.414353,
      3,
      4,
      6,
      0.735840,
      1,
      1,
      0.026261,
      0.648753,
      0,
      0.031662,
      NULL,
      1.136037,
      1,
      1.904091,
      5,
      2,
      2,
      NULL,
      NULL,
      0,
      2,
      2,
      4,
      4,
      0,
      1,
      0,
      5,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      5,
      1.315608,
      1,
      1,
      1,
      0,
      0.698944,
      1,
      NULL,
      1,
      0.096883,
      0.395370,
      1,
      0.887810,
      1.521008,
      2.512139,
      3,
      NULL,
      1,
      0,
      0,
      6.462876,
      3,
      2,
      0,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      2,
      4,
      3,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      7.524382,
      0,
      1,
      1,
      1,
      0.527370,
      NULL,
      1,
      2,
      4,
      1,
      4,
      0,
      1,
      2,
      0,
      0,
      NULL,
      1,
      4,
      3,
      NULL,
      1,
      0,
      4,
      4,
      2,
      5,
      3,
      1,
      2,
      5,
      4,
      4.873273,
      2,
      ' 8-13-1997',
      926,
      ' 6-26-1999',
      33.783407,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      1,
      4,
      NULL,
      1.461007,
      1.265846,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.746404,
      NULL,
      NULL,
      5.442103,
      6.662573,
      5,
      0.035691,
      NULL,
      NULL,
      2.535824,
      2.815690,
      1.089468,
      NULL,
      5,
      2,
      6.283264,
      ' 2-12-1995',
      15.197518,
      '10- 8-2001',
      NULL,
      1,
      1,
      0.023502,
      3.697529,
      1.613372,
      0.340424,
      0.510526,
      1,
      0,
      1.322708,
      2.226959,
      13.109059,
      2.561766,
      1.253084,
      NULL,
      NULL,
      NULL,
      1,
      1.662560,
      NULL,
      1,
      2,
      3,
      1,
      NULL,
      3,
      3,
      3,
      NULL,
      3,
      NULL,
      2.379415,
      0.804747,
      3,
      0.200466,
      0.152162,
      3,
      1.369231,
      NULL,
      0.590152,
      0.497282,
      0.183211,
      1.882971,
      1.547512,
      0.186593,
      0,
      1.380006,
      0.202281,
      NULL,
      3.159709,
      1.836762,
      5,
      4,
      NULL,
      3.530919,
      3,
      0,
      3.290458,
      3.604167,
      3.351227,
      3,
      30.671454,
      NULL,
      2.211603,
      NULL,
      23,
      14,
      38.722367,
      2,
      1,
      0,
      NULL,
      '',
      '',
      0.701936,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.711379,
      20.093840,
      218.163857,
      43.602867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.358110,
      0,
      0,
      NULL,
      NULL,
      3.116352,
      1,
      NULL,
      2,
      1.656907,
      1.910957,
      3.660791,
      1,
      0.990661,
      NULL,
      3,
      0,
      NULL,
      1.116401,
      0.688789,
      0.018325,
      1.688847,
      NULL,
      0,
      0.878293,
      NULL,
      2,
      NULL,
      5.083259,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508532,
      1,
      1.520182,
      3,
      1.935784,
      1,
      0.515231,
      NULL,
      NULL,
      3.136153,
      1.889032,
      0,
      0,
      NULL,
      0.397834,
      0,
      3.202353,
      0.375566,
      1.981834,
      0,
      2,
      NULL,
      1,
      1.592729,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.728295,
      1,
      4,
      NULL,
      2,
      3,
      1.977768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747166,
      NULL,
      NULL,
      1,
      0.139470,
      NULL,
      1.618057,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.695705,
      1,
      0.090991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730995,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      0.648041,
      9,
      0.704812,
      7,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.525466,
      NULL,
      0.638180,
      NULL,
      0.686884,
      3,
      0,
      NULL,
      9.365378,
      0,
      NULL,
      2.780050,
      0,
      0,
      1,
      1,
      NULL,
      1.744995,
      NULL,
      0,
      1.623041,
      0,
      3,
      NULL,
      1,
      NULL,
      8.808246,
      0,
      5.144625,
      1.402062,
      3,
      1,
      0.943613,
      1,
      0.837719,
      1,
      0.799178,
      3,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.313145,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.961370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.440330,
      1.606893,
      0.609678,
      3.348379,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.131107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026133,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.397353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.137970,
      1.635700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.833768,
      NULL,
      1.825528,
      NULL,
      NULL,
      NULL,
      1.822305,
      NULL,
      1,
      NULL,
      1,
      1.440048,
      1,
      0.424571,
      1,
      0,
      NULL,
      0.380116,
      1.452904,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      3.705445,
      3.421485,
      2.806656,
      2,
      3,
      9,
      2,
      1.425576,
      NULL,
      0.771656,
      NULL,
      NULL,
      NULL,
      1.096288,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      1.229385,
      0,
      NULL,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.228315,
      1.605937,
      NULL,
      1,
      0,
      NULL,
      1,
      1.700602,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.951368,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4,
      0,
      NULL,
      NULL,
      76,
      64,
      NULL,
      1,
      3.351105,
      '44424',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


