set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8724508';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '4104230',
      1.605207,
      1,
      4,
      1,
      '0040',
      0.171366,
      0.849914,
      NULL,
      NULL,
      ' 0-13-1985',
      44.797686,
      NULL,
      2,
      0.871416,
      3,
      ' 4-23-2000',
      NULL,
      3.385184,
      150,
      106,
      0,
      ' 2-20-1975',
      NULL,
      ' 6- 1-2003',
      1.118732,
      1,
      1.458696,
      1.380914,
      0,
      0.673231,
      1,
      0.441911,
      0,
      NULL,
      0,
      17.304255,
      4,
      6.275210,
      14,
      3,
      19.141713,
      3,
      1,
      6.074374,
      NULL,
      0,
      NULL,
      7,
      0.398561,
      NULL,
      0.190513,
      1,
      0,
      1.192106,
      NULL,
      NULL,
      2,
      0,
      0.299608,
      1,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      1,
      1,
      0,
      0,
      4,
      3.332718,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.454157,
      0.833657,
      0.497331,
      1.766420,
      0.977220,
      0,
      0,
      1,
      1.799354,
      1.122113,
      0.637721,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      3,
      1,
      2.208552,
      1.885202,
      NULL,
      NULL,
      0.387215,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      5,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      5,
      1,
      1,
      NULL,
      1,
      1.895790,
      NULL,
      1,
      4,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      0,
      5,
      0,
      NULL,
      1,
      1,
      1,
      2,
      1,
      3,
      NULL,
      2,
      4,
      1,
      NULL,
      1,
      1,
      NULL,
      4.639914,
      NULL,
      ' 8-22-1998',
      513,
      ' 3-18-1999',
      73.905320,
      0,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      0,
      NULL,
      1.117767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2.415724,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.928434,
      NULL,
      NULL,
      1.772023,
      2.012818,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.244530,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.192443,
      1.002343,
      1,
      NULL,
      1,
      3,
      33.967255,
      0.332653,
      0.570855,
      NULL,
      NULL,
      NULL,
      3,
      0.474099,
      3.822124,
      1,
      2,
      3,
      3,
      0,
      1,
      1,
      0,
      3,
      0,
      1.217722,
      3,
      3.054093,
      0,
      0.395003,
      1,
      0.856244,
      112.705079,
      NULL,
      1,
      1.266875,
      1,
      149,
      8.585607,
      102,
      NULL,
      0.932190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      48,
      28,
      65,
      3,
      1,
      0,
      '02303',
      NULL,
      NULL,
      1.765587,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.987478,
      4.018016,
      134.557161,
      50,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.429993,
      NULL,
      NULL,
      1,
      1.899427,
      1.255511,
      1.327201,
      NULL,
      NULL,
      2,
      1.932823,
      1.306809,
      1.220829,
      0,
      0.136778,
      2.648546,
      0,
      1,
      3,
      1.804661,
      0,
      0,
      NULL,
      NULL,
      2.762919,
      1,
      NULL,
      0.914028,
      NULL,
      0.113876,
      NULL,
      NULL,
      0.782979,
      NULL,
      5,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.313336,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1.784683,
      NULL,
      NULL,
      1.257249,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.407840,
      1.547641,
      1,
      0,
      0,
      0,
      0,
      1.219798,
      0.398317,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.077603,
      NULL,
      NULL,
      2.061867,
      1,
      0,
      6.064877,
      4.947221,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.204533,
      0,
      0.263019,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0.379323,
      NULL,
      NULL,
      0.410536,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.225508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970126,
      NULL,
      NULL,
      1.810350,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.687043,
      NULL,
      NULL,
      1.658729,
      0,
      1.333916,
      2.710477,
      3.532635,
      NULL,
      1,
      0,
      2.731066,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961851,
      0.243486,
      0.647960,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3.044181,
      0,
      NULL,
      1,
      0,
      NULL,
      3,
      1,
      3,
      2.150670,
      0.634621,
      0,
      7,
      1.826139,
      7,
      9.829954,
      0,
      NULL,
      3.926477,
      4,
      4,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.468010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.778394,
      NULL,
      NULL,
      0.756310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.131116,
      NULL,
      NULL,
      1.321137,
      0.956858,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.248190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.433509,
      1,
      NULL,
      1.332745,
      NULL,
      NULL,
      0.523488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018784,
      NULL,
      NULL,
      8911,
      NULL,
      NULL,
      NULL,
      1.256443,
      1.606465,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.096950,
      1,
      0,
      1,
      0,
      1.832860,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      4.515001,
      2,
      0.929209,
      3,
      0,
      10,
      1.458398,
      NULL,
      0,
      0.903040,
      1.864267,
      NULL,
      2,
      0.404254,
      NULL,
      1.987300,
      0,
      NULL,
      1.332295,
      1.036915,
      NULL,
      2,
      NULL,
      NULL,
      1,
      2.283460,
      NULL,
      NULL,
      1.077681,
      NULL,
      3,
      0,
      NULL,
      0.240250,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.179920,
      NULL,
      NULL,
      2,
      1,
      1.732139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      1.735974,
      0.169144,
      1,
      14,
      76,
      2,
      NULL,
      NULL,
      '12114',
      '',
      NULL,
      0.829544,
      NULL,
      '',
      '',
      0.316310,
      '',
      '',
      '');
commit;
end;
/


