set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7919207';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      3.227404,
      1,
      3,
      3,
      '1302',
      3,
      1.386886,
      NULL,
      NULL,
      '10-19-2003',
      NULL,
      NULL,
      4,
      1,
      1.550073,
      '10-13-1996',
      53.541456,
      1.728829,
      296,
      NULL,
      3,
      '11- 4-1987',
      ' 5-29-1992',
      ' 4-12-1977',
      1.250167,
      3,
      1.172812,
      0,
      0.831458,
      3,
      2,
      0.665541,
      NULL,
      401.163307,
      5,
      NULL,
      NULL,
      10.721632,
      5,
      3,
      15,
      5,
      NULL,
      7.602345,
      1,
      0,
      NULL,
      NULL,
      0.208449,
      NULL,
      0,
      0.721487,
      NULL,
      NULL,
      130.743162,
      NULL,
      NULL,
      3,
      0.905014,
      5,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      5,
      3,
      4,
      3,
      4,
      1,
      NULL,
      1,
      0,
      1.397295,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1.476378,
      NULL,
      1,
      1.407551,
      3.691865,
      2,
      NULL,
      NULL,
      3.430962,
      0.975127,
      1.976947,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      1.428706,
      NULL,
      NULL,
      0.418223,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      3,
      1,
      1,
      0,
      4,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.251211,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      3,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      2,
      2,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      3,
      7,
      3,
      ' 4-10-1984',
      NULL,
      NULL,
      1215,
      2.178338,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1.373895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121148,
      0.159923,
      NULL,
      0.288358,
      0.318287,
      1.454622,
      NULL,
      NULL,
      NULL,
      NULL,
      0.227994,
      0.091016,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.422411,
      0.981067,
      0.478255,
      0.068047,
      0,
      2.351251,
      NULL,
      1.577694,
      1.988666,
      164.152926,
      NULL,
      NULL,
      0,
      0,
      2.652641,
      NULL,
      2,
      1,
      1,
      3,
      0,
      3,
      0,
      2,
      1,
      0.994898,
      2,
      2.676798,
      2.164992,
      1.376726,
      0,
      1,
      NULL,
      1.666255,
      0,
      0,
      0,
      0.690332,
      NULL,
      1.994116,
      0,
      0,
      0,
      0,
      6.189717,
      0.155788,
      0.346304,
      6,
      6.513517,
      0.166473,
      0.703163,
      0.844757,
      5,
      NULL,
      NULL,
      3.722292,
      5.764544,
      0,
      2,
      NULL,
      39,
      32,
      2.318045,
      3,
      0.886661,
      3,
      '11120',
      '12044',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      '33421',
      2.811795,
      11.898120,
      NULL,
      NULL,
      1,
      55,
      2.576924,
      1038.843500,
      4,
      2.887783,
      2.291486,
      3.551479,
      1,
      NULL,
      NULL,
      1.786619,
      NULL,
      NULL,
      1.363929,
      NULL,
      NULL,
      1.257705,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.770415,
      2.581669,
      2.924104,
      1,
      NULL,
      NULL,
      1.931630,
      NULL,
      0.937403,
      2,
      0.243731,
      1,
      2,
      0,
      0,
      0,
      1,
      1.166836,
      8.995638,
      1.623426,
      3.223185,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.818000,
      2.079166,
      NULL,
      1,
      3.862456,
      1.684068,
      NULL,
      NULL,
      1,
      1,
      1,
      0.503002,
      3,
      NULL,
      2.434240,
      0.304811,
      0,
      0,
      NULL,
      1,
      1.344876,
      1.501561,
      0,
      1.565818,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      1.181331,
      7,
      3,
      0.638827,
      NULL,
      NULL,
      NULL,
      1.917783,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.979137,
      NULL,
      3,
      2.171186,
      0,
      1,
      1,
      NULL,
      NULL,
      3.058926,
      NULL,
      6,
      NULL,
      0.280842,
      1,
      0.503925,
      NULL,
      NULL,
      NULL,
      1,
      4.750190,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.575583,
      NULL,
      NULL,
      0.269583,
      1.018848,
      2,
      6,
      0.168541,
      5,
      6,
      1,
      3.512410,
      NULL,
      4.108643,
      9.167128,
      NULL,
      1.490659,
      1.762066,
      3,
      1,
      1.647889,
      3.625913,
      0,
      3,
      3,
      3.428837,
      7.656402,
      0,
      1,
      1.489466,
      1.651187,
      NULL,
      NULL,
      NULL,
      2,
      0.125641,
      3,
      2,
      NULL,
      NULL,
      0,
      7,
      7.051580,
      0,
      2,
      1,
      0,
      4,
      NULL,
      1.428926,
      0,
      0,
      0,
      0.652834,
      NULL,
      NULL,
      0.661876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572948,
      NULL,
      NULL,
      1.978507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760220,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.093611,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.805978,
      NULL,
      NULL,
      1.583767,
      0,
      0,
      NULL,
      0,
      1,
      0.673088,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.880495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.913942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      99,
      34.222026,
      1.233648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      115,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419898,
      0.310795,
      0,
      0.839429,
      NULL,
      NULL,
      1.206185,
      0.200215,
      0.868789,
      1,
      NULL,
      1,
      0.822187,
      0.044710,
      1,
      0.837800,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      3.420802,
      0.511600,
      1,
      14,
      1.857789,
      2.508236,
      0.512500,
      NULL,
      NULL,
      NULL,
      0,
      2.554334,
      NULL,
      0,
      1.556782,
      NULL,
      1,
      0.156959,
      NULL,
      1,
      1,
      NULL,
      0,
      1.900776,
      NULL,
      3.837869,
      NULL,
      NULL,
      0.054625,
      3.938817,
      NULL,
      2,
      3.824734,
      NULL,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      3.072958,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.580283,
      NULL,
      0.458256,
      NULL,
      NULL,
      5,
      0,
      3.043077,
      2,
      2,
      NULL,
      1,
      2,
      0.732759,
      3,
      '43230',
      '41024',
      '',
      0,
      '',
      NULL,
      '',
      3.249993,
      '10020',
      '11131',
      NULL);
commit;
end;
/


