set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0100555';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      3.239426,
      NULL,
      3.961588,
      3,
      2.546352,
      NULL,
      1.251297,
      '210',
      NULL,
      84.098962,
      54,
      '1214001',
      2,
      1.353836,
      4,
      1,
      '1233',
      2,
      1.407585,
      NULL,
      NULL,
      '10- 0-2003',
      29.965320,
      30.099113,
      NULL,
      2,
      1,
      '11-10-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 9-24-1985',
      ' 4- 1-1988',
      ' 8-11-1988',
      0.649298,
      2,
      0,
      1,
      1.607795,
      2.607979,
      2,
      0,
      NULL,
      16,
      1,
      11.370695,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      2,
      NULL,
      1,
      1.585440,
      0,
      0.648023,
      NULL,
      1,
      1,
      1.136591,
      2,
      3,
      NULL,
      2,
      4,
      1,
      0,
      5,
      1,
      3,
      1,
      0,
      NULL,
      1,
      1,
      0,
      7,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3.195659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      4,
      0,
      5,
      NULL,
      4,
      0,
      5,
      NULL,
      0,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.979133,
      NULL,
      0.581983,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      3,
      5,
      4,
      2,
      NULL,
      1,
      NULL,
      2,
      2,
      1,
      3,
      NULL,
      ' 7- 5-1976',
      132,
      ' 0-22-2001',
      220,
      0.570552,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.768829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.896952,
      NULL,
      NULL,
      NULL,
      6,
      0.284157,
      7.859354,
      1,
      1.137713,
      0.954220,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.925421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2.222772,
      NULL,
      1.218726,
      0,
      3,
      4,
      2.738625,
      0.070856,
      NULL,
      NULL,
      NULL,
      2,
      1.743319,
      2,
      3,
      0,
      NULL,
      1,
      2,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      4.856372,
      1.073067,
      1.044222,
      1,
      0,
      1.484439,
      1,
      1.486271,
      0.644574,
      NULL,
      1.632003,
      1.870030,
      1.728740,
      NULL,
      7,
      7.491270,
      2.789450,
      11,
      NULL,
      5,
      0,
      3.308288,
      1,
      NULL,
      2,
      5.021460,
      3,
      1,
      NULL,
      NULL,
      20,
      39.288684,
      4,
      3,
      3,
      '04301',
      '14240',
      NULL,
      0,
      '0233',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      4.060452,
      2,
      NULL,
      1.510128,
      16,
      6,
      5,
      NULL,
      1.624213,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.670382,
      0.046581,
      1,
      NULL,
      NULL,
      1,
      3.711650,
      NULL,
      3,
      3,
      1,
      0.650927,
      NULL,
      NULL,
      2,
      0.804608,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.641209,
      NULL,
      NULL,
      3,
      2,
      5,
      2,
      0.689813,
      NULL,
      NULL,
      NULL,
      1.595508,
      NULL,
      NULL,
      NULL,
      NULL,
      3.435465,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.009054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.159205,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      NULL,
      1,
      NULL,
      2,
      0.698161,
      2,
      NULL,
      NULL,
      NULL,
      4.853237,
      5.718403,
      5.837793,
      2.096077,
      0.124196,
      0.761402,
      0.240168,
      NULL,
      NULL,
      NULL,
      2.992714,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362307,
      NULL,
      NULL,
      0.450085,
      NULL,
      NULL,
      0.655535,
      NULL,
      NULL,
      1.704218,
      NULL,
      3.464217,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.316160,
      NULL,
      NULL,
      3,
      2,
      3,
      NULL,
      2.422127,
      3.034923,
      0,
      2.191614,
      NULL,
      8,
      6.626081,
      0.830618,
      3,
      1,
      3.844641,
      NULL,
      2.081875,
      2.099215,
      NULL,
      0,
      1,
      2.964635,
      NULL,
      1,
      6,
      6.631691,
      2.998639,
      2,
      3.849407,
      4.038036,
      2,
      NULL,
      3,
      0.156952,
      0,
      1.582757,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.203368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.406863,
      1,
      1.440652,
      2.203978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.599253,
      NULL,
      NULL,
      NULL,
      1.831259,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.633975,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.680658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.871915,
      8,
      1,
      0.501679,
      1,
      0.469433,
      NULL,
      NULL,
      2.177771,
      1.154045,
      0,
      1.085008,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.695264,
      NULL,
      0,
      NULL,
      0,
      0,
      1.415903,
      0,
      1,
      NULL,
      1.018402,
      1,
      1,
      3.244395,
      0,
      2,
      NULL,
      0.350380,
      0.836728,
      NULL,
      0.729884,
      3.793651,
      NULL,
      1,
      NULL,
      0.338661,
      NULL,
      1,
      NULL,
      0.454843,
      NULL,
      0.203308,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      27.997393,
      NULL,
      0.286849,
      3,
      5.242161,
      1,
      NULL,
      1.489066,
      NULL,
      0,
      NULL,
      1.925917,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.589588,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.333776,
      NULL,
      0.161182,
      NULL,
      3.134025,
      0.639750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.851270,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.512933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.688171,
      NULL,
      NULL,
      NULL,
      1.615453,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      50,
      NULL,
      3.998870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.802246,
      3.234192,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      6.719714,
      3,
      3,
      0,
      3,
      NULL,
      NULL,
      0.641774,
      1.472557,
      0.145774,
      0.528136,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.291818,
      NULL,
      1.760668,
      0.564258,
      NULL,
      1,
      1,
      NULL,
      0.109457,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.972102,
      0.397756,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.866198,
      0.940409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      5,
      2,
      3.968715,
      2,
      NULL,
      24,
      1,
      3,
      5,
      NULL,
      NULL,
      '',
      NULL,
      '4024',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


