set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232933';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      '4132',
      2.594549,
      NULL,
      NULL,
      NULL,
      '11-12-1988',
      7,
      NULL,
      1,
      NULL,
      NULL,
      ' 7- 1-1998',
      1.622765,
      0,
      284.683774,
      39.467987,
      0,
      NULL,
      '10-10-1977',
      ' 6-21-1997',
      NULL,
      1.602160,
      0,
      3,
      0.872387,
      NULL,
      3,
      1,
      1,
      29.927939,
      6,
      1,
      3,
      11,
      9,
      NULL,
      6.327748,
      3,
      NULL,
      9.701169,
      0,
      1,
      1,
      1,
      0.764363,
      1,
      0,
      NULL,
      1,
      NULL,
      1.121063,
      2,
      6,
      1,
      1.599567,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      4,
      1,
      0,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.972649,
      NULL,
      NULL,
      4,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1.720479,
      NULL,
      0.657264,
      1.066522,
      1.813708,
      5,
      0,
      2,
      3,
      1,
      NULL,
      1,
      0.624848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      5,
      NULL,
      0,
      2,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      2,
      1.893845,
      3,
      5,
      4,
      3,
      4,
      0,
      4,
      NULL,
      4,
      2,
      5,
      3,
      5,
      2,
      0,
      NULL,
      5,
      5,
      0,
      1,
      2,
      1,
      0,
      0,
      2,
      NULL,
      0,
      3,
      '11-23-1987',
      NULL,
      ' 8-10-2000',
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      1,
      4,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.238586,
      1,
      1.734260,
      3,
      5,
      5,
      0,
      0.096925,
      3,
      3.409647,
      NULL,
      1,
      NULL,
      2,
      4.107185,
      1.610122,
      NULL,
      1.443527,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.087627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228336,
      0.955401,
      0.235938,
      1,
      1,
      0,
      0.946926,
      1.543668,
      28,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.922424,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      0.358906,
      NULL,
      0.959659,
      0.268026,
      NULL,
      NULL,
      0.980199,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.078788,
      NULL,
      22,
      NULL,
      28.125480,
      NULL,
      1,
      NULL,
      '34103',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      1,
      27,
      48.169998,
      1.264349,
      3.375659,
      24,
      2,
      NULL,
      2,
      2,
      2.145872,
      1,
      1.312801,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      15.207896,
      15,
      0,
      NULL,
      NULL,
      2.705023,
      NULL,
      NULL,
      0,
      3.006996,
      3.357768,
      NULL,
      NULL,
      NULL,
      0.773893,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      2,
      0.237707,
      NULL,
      NULL,
      3,
      3.387264,
      2.894846,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.938123,
      NULL,
      NULL,
      NULL,
      2,
      4,
      19.490061,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.528736,
      1,
      1.839437,
      1,
      1.022738,
      NULL,
      1,
      0.814703,
      1,
      0.451817,
      0,
      0.250076,
      0,
      0,
      1,
      1,
      0,
      10,
      13.456011,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.575555,
      NULL,
      NULL,
      NULL,
      NULL,
      3.863730,
      NULL,
      0,
      0,
      NULL,
      12,
      NULL,
      NULL,
      2.197426,
      3.507729,
      NULL,
      14,
      2,
      3,
      9,
      NULL,
      2,
      3,
      1.256424,
      0.174445,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.828721,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.915035,
      0,
      3,
      0,
      3,
      1.364731,
      2.766259,
      NULL,
      5.651531,
      6,
      6,
      4.576441,
      0.907858,
      NULL,
      0,
      0.036157,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.950300,
      NULL,
      2,
      5.077625,
      6.917506,
      9.057375,
      NULL,
      2,
      0,
      1.681947,
      NULL,
      1.087794,
      1,
      3.906636,
      0.384399,
      0.247559,
      2,
      1.606146,
      NULL,
      1,
      4.820233,
      6,
      NULL,
      NULL,
      1.274654,
      1,
      0,
      0.050609,
      1,
      1,
      1.943004,
      0,
      2.107931,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460890,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.676548,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2.273410,
      1.019506,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.808890,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.169410,
      NULL,
      NULL,
      NULL,
      0.067739,
      NULL,
      NULL,
      NULL,
      1.785169,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0.061754,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522971,
      NULL,
      NULL,
      NULL,
      3.770267,
      0,
      3,
      3.531183,
      1,
      0,
      1.753041,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.028730,
      NULL,
      NULL,
      1.639531,
      NULL,
      1.397181,
      12195,
      1.974003,
      NULL,
      1,
      0.555076,
      0.242593,
      1,
      1.687550,
      0.452917,
      NULL,
      NULL,
      1,
      0.940872,
      NULL,
      1,
      1.017972,
      1.103122,
      0.854474,
      0.413257,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.375950,
      1.783794,
      3.437883,
      5.679533,
      1,
      13.956569,
      3,
      3,
      1,
      0,
      0.183856,
      NULL,
      1,
      NULL,
      NULL,
      0.462315,
      3.563224,
      NULL,
      0.374268,
      NULL,
      NULL,
      1.322161,
      2.947578,
      NULL,
      1.851411,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.122015,
      NULL,
      NULL,
      3.166436,
      NULL,
      0.995528,
      1,
      NULL,
      1.028286,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805710,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      4,
      4,
      0,
      NULL,
      NULL,
      7,
      51.849126,
      2,
      NULL,
      3.771387,
      '30100',
      '',
      '',
      0.539227,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


