set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7837432';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32',
      26,
      NULL,
      '0034420',
      3.756280,
      NULL,
      6,
      2,
      '2004',
      0,
      1,
      NULL,
      NULL,
      ' 5-22-1992',
      14,
      39,
      NULL,
      3.945796,
      3.949222,
      ' 9-26-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8- 8-1988',
      NULL,
      ' 6-21-1976',
      2.703213,
      0,
      1,
      NULL,
      0,
      1.402566,
      3,
      3,
      NULL,
      NULL,
      NULL,
      5.629081,
      2.103574,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1.041559,
      1,
      1,
      0.603337,
      0,
      0,
      1.074079,
      0.607988,
      0.812109,
      9.853628,
      1.843764,
      0,
      2,
      0,
      3,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      3,
      3,
      1,
      NULL,
      0.715164,
      1,
      2,
      0,
      1,
      1.306020,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1.902165,
      0,
      0,
      3,
      NULL,
      0.488332,
      NULL,
      2,
      1,
      1.949683,
      3.355983,
      1,
      1,
      1,
      0,
      1,
      3,
      1,
      NULL,
      6,
      0,
      2,
      1,
      1.610060,
      NULL,
      NULL,
      1.196611,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      2,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0.439377,
      0,
      0,
      0,
      0,
      0.992664,
      NULL,
      0.080303,
      0,
      1,
      5,
      5,
      1,
      3,
      4,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      2,
      1,
      1,
      4,
      5,
      2,
      0,
      NULL,
      4,
      NULL,
      NULL,
      0,
      2,
      ' 2-27-2001',
      0,
      ' 3-24-1995',
      3.543484,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      5,
      0,
      0,
      2.591158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2,
      NULL,
      NULL,
      NULL,
      7.187652,
      NULL,
      NULL,
      0.231818,
      NULL,
      2.058270,
      2.745173,
      0,
      NULL,
      NULL,
      1.768035,
      8.717254,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.909608,
      0.808925,
      0.198032,
      1,
      0.890333,
      0.811465,
      0,
      3,
      1,
      1.738630,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2,
      0,
      1,
      3,
      0,
      3,
      1,
      3,
      1,
      2,
      0,
      2.448319,
      1.390144,
      1,
      1.389096,
      0.828359,
      0,
      0,
      1.045605,
      1.080566,
      1,
      1.079007,
      0.905796,
      0.670881,
      NULL,
      1,
      3,
      NULL,
      0.364406,
      NULL,
      7,
      2.371130,
      9.281007,
      9,
      1.634514,
      1.313229,
      0.195768,
      3.885804,
      1,
      1.817283,
      3.829536,
      43.667335,
      3,
      NULL,
      36,
      NULL,
      27,
      35,
      0,
      4,
      3.151698,
      '20044',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.690913,
      '',
      '',
      NULL,
      0,
      14,
      15.640926,
      20.861041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639056,
      NULL,
      NULL,
      0.847135,
      NULL,
      NULL,
      1.558393,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.965952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.223668,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445597,
      NULL,
      NULL,
      1.504823,
      NULL,
      NULL,
      0.783623,
      NULL,
      NULL,
      0.339800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.867904,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.710245,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.479668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704945,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043905,
      NULL,
      NULL,
      1.684161,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.896601,
      NULL,
      NULL,
      1.571821,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.551363,
      NULL,
      NULL,
      1.790655,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.097441,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337585,
      NULL,
      NULL,
      1.613883,
      3,
      0.535576,
      2.310734,
      7.804981,
      1.923976,
      0.252999,
      0,
      0.244236,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778667,
      0.086560,
      0.308447,
      0.637155,
      0.631360,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1.995405,
      1.943009,
      1.494083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689784,
      NULL,
      NULL,
      NULL,
      0.894909,
      1.716893,
      1,
      0.818159,
      3,
      1.841797,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      506.179411,
      4,
      0,
      1.954410,
      1.159130,
      NULL,
      NULL,
      1,
      1.362228,
      1,
      3.247942,
      0.605541,
      0.442837,
      NULL,
      NULL,
      1.115388,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1.282096,
      NULL,
      NULL,
      NULL,
      1.831034,
      NULL,
      NULL,
      NULL,
      1.168778,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452118,
      0.347418,
      1.196713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554999,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803462,
      0.232547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.399470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.082201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397161,
      3.533560,
      0.248335,
      1.384851,
      1.184579,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0.463640,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      1,
      NULL,
      1,
      5.664165,
      1.865794,
      2.812779,
      1.436769,
      1.816913,
      0,
      NULL,
      0,
      1.799581,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.637788,
      NULL,
      NULL,
      0.411453,
      0,
      NULL,
      NULL,
      0.607556,
      NULL,
      NULL,
      0.999853,
      NULL,
      0,
      1.987561,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661677,
      NULL,
      1.478779,
      NULL,
      0.162771,
      NULL,
      NULL,
      5,
      3,
      1,
      NULL,
      NULL,
      NULL,
      38.095367,
      2,
      3,
      3,
      '12144',
      '',
      '',
      1.061264,
      NULL,
      '',
      '',
      0.875256,
      '',
      NULL,
      '');
commit;
end;
/


