set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      '2432',
      0,
      1.402428,
      NULL,
      NULL,
      ' 0-12-1980',
      0.237867,
      NULL,
      NULL,
      0,
      1.568342,
      '11-12-1975',
      NULL,
      NULL,
      339,
      NULL,
      3,
      ' 3-21-1987',
      NULL,
      NULL,
      NULL,
      0,
      3.717075,
      2,
      0.013802,
      NULL,
      2,
      0,
      0,
      2,
      NULL,
      2,
      3.147876,
      6,
      11.342266,
      1,
      31.118865,
      1,
      5,
      3.844391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      4,
      1,
      NULL,
      3,
      NULL,
      1,
      5,
      1,
      NULL,
      2,
      5,
      4,
      3,
      NULL,
      1,
      1,
      NULL,
      1.655082,
      NULL,
      NULL,
      1.816339,
      NULL,
      NULL,
      4,
      3,
      0,
      2.758250,
      1,
      1.247272,
      1,
      NULL,
      3,
      1,
      0.023681,
      1.097142,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076906,
      0.174985,
      NULL,
      1,
      NULL,
      5,
      10.329534,
      0,
      0,
      1.479612,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      1,
      1,
      5,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.023915,
      1,
      1,
      0,
      0,
      0,
      4,
      4,
      1,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      4,
      2,
      NULL,
      1,
      3,
      0,
      4.194646,
      3,
      ' 1-18-1975',
      10.327996,
      ' 1-27-1980',
      12,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      2,
      0.686553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.703339,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.376718,
      3.800210,
      1,
      1.432759,
      0,
      0,
      1,
      6.070281,
      3.834225,
      NULL,
      2,
      6,
      1.417817,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.068167,
      0,
      0,
      1.561595,
      0.958730,
      2,
      3,
      0.846552,
      1.471999,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      2,
      0,
      3,
      3,
      NULL,
      2,
      0,
      NULL,
      3,
      3.781264,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1.060707,
      0.026630,
      0.074273,
      NULL,
      0.973593,
      0.683302,
      1,
      NULL,
      3.720691,
      1.648723,
      NULL,
      10,
      7,
      0.861813,
      2,
      0,
      3,
      2.255042,
      NULL,
      0,
      2.647224,
      2,
      26,
      3,
      0.434392,
      NULL,
      11,
      21,
      83,
      NULL,
      1,
      NULL,
      '10143',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.224913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.289550,
      0.226227,
      NULL,
      1.049129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220009,
      NULL,
      NULL,
      0.380983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304200,
      NULL,
      0,
      828.715083,
      7.888088,
      NULL,
      1.286015,
      1.104274,
      0,
      NULL,
      0,
      1,
      0.435736,
      0.695360,
      NULL,
      0.780647,
      0.843382,
      0.817900,
      0,
      0.635882,
      0.798790,
      0,
      2,
      NULL,
      0,
      NULL,
      1.840362,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.398072,
      0.374441,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647982,
      NULL,
      0.444008,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.833417,
      NULL,
      1,
      NULL,
      1.381486,
      NULL,
      NULL,
      NULL,
      1.226262,
      NULL,
      0.737529,
      0.240248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.396479,
      NULL,
      NULL,
      NULL,
      0.429454,
      NULL,
      1,
      0.739885,
      1.612422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.727751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523070,
      0.728395,
      NULL,
      1.409521,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.632635,
      NULL,
      1.014665,
      NULL,
      1.216957,
      NULL,
      0,
      NULL,
      52.070780,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.827234,
      1.656794,
      0.887497,
      NULL,
      10.468789,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      4,
      0,
      1,
      1,
      1,
      NULL,
      3.457216,
      0.193660,
      1,
      3.859484,
      0.887924,
      NULL,
      3,
      1,
      NULL,
      1.621819,
      1.943522,
      NULL,
      0,
      0.130228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.338977,
      NULL,
      1,
      3.529760,
      NULL,
      1,
      NULL,
      NULL,
      2.578623,
      2.166779,
      NULL,
      0.595113,
      0,
      NULL,
      3.224582,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.091761,
      NULL,
      0.040436,
      NULL,
      0,
      NULL,
      2,
      1.231037,
      NULL,
      NULL,
      73,
      48,
      2,
      2,
      3,
      NULL,
      '24300',
      '41133',
      0,
      '21002',
      '',
      NULL,
      1.328163,
      '',
      '',
      '');
commit;
end;
/


