set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829512';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      NULL,
      NULL,
      NULL,
      '3403244',
      2.441914,
      1.759419,
      2,
      2,
      '0303',
      NULL,
      0.041657,
      NULL,
      NULL,
      ' 9-13-1996',
      42.279677,
      6.707631,
      NULL,
      3.816459,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 0-13-1990',
      NULL,
      0,
      2,
      NULL,
      1.334940,
      1.668288,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0.939309,
      NULL,
      1.961728,
      NULL,
      0,
      3,
      0.321045,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      5,
      5,
      NULL,
      2,
      4,
      4,
      6,
      NULL,
      0,
      NULL,
      0,
      0.469134,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0,
      0.189896,
      NULL,
      3.614668,
      0,
      2,
      NULL,
      1,
      2.936406,
      NULL,
      1.076945,
      1.551536,
      2.967732,
      1.258417,
      NULL,
      1,
      1,
      0,
      5,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      1.607566,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575582,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      1,
      1,
      NULL,
      1,
      1,
      5,
      1,
      5,
      2,
      2,
      1,
      4,
      2,
      NULL,
      3,
      5,
      NULL,
      5,
      5,
      1.908884,
      NULL,
      19,
      ' 7- 6-1977',
      4,
      1,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.818947,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.938870,
      0,
      2,
      NULL,
      4.060625,
      1.584489,
      0.766591,
      NULL,
      NULL,
      1.677384,
      1.271294,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.379031,
      1.682765,
      1.450664,
      0.534232,
      0,
      NULL,
      NULL,
      1,
      0.553721,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      3,
      2,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      3,
      3.824083,
      NULL,
      NULL,
      2,
      1.260687,
      NULL,
      1.883795,
      0.064604,
      1.833360,
      0,
      0,
      0.032197,
      1.611635,
      0,
      1,
      1,
      1.107512,
      0.484212,
      1.422952,
      0.499058,
      NULL,
      2.420518,
      NULL,
      5.424560,
      1,
      1,
      NULL,
      5,
      3.786746,
      3.215168,
      3,
      NULL,
      0,
      0,
      60,
      NULL,
      36,
      20.915036,
      4,
      0.235148,
      3.430450,
      '10322',
      '2041',
      '',
      0.890792,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.318907,
      30,
      22,
      18,
      1.994646,
      4.302295,
      9,
      0,
      2,
      2.341893,
      2.124379,
      2.577155,
      0.718795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      3.807193,
      NULL,
      1.808894,
      0,
      NULL,
      NULL,
      3.443278,
      1.208112,
      NULL,
      1,
      NULL,
      0,
      5,
      3.071728,
      2.495658,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.335031,
      1,
      3,
      NULL,
      3,
      1,
      NULL,
      0.913853,
      0,
      1.664458,
      1,
      1.363691,
      2.375903,
      NULL,
      1.993084,
      1.638111,
      1,
      0,
      2,
      0.545177,
      1.164837,
      2,
      NULL,
      1,
      1.493066,
      0,
      NULL,
      NULL,
      1.640457,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      8,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172446,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.033658,
      NULL,
      NULL,
      0.408599,
      NULL,
      NULL,
      1.443027,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.611198,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317619,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.731058,
      NULL,
      0.767608,
      NULL,
      NULL,
      3,
      2,
      1.186488,
      2.582044,
      3,
      3.516660,
      2,
      1.642500,
      1.033842,
      0.767413,
      3,
      2,
      3.535293,
      3.745381,
      NULL,
      2,
      NULL,
      1,
      0.014699,
      2.658048,
      1.122709,
      0,
      NULL,
      1,
      2,
      7.064754,
      NULL,
      1,
      NULL,
      0.157370,
      3.720723,
      3,
      2,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.510521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.310743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.749577,
      1,
      0,
      3.492402,
      3.461743,
      NULL,
      NULL,
      4.018051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752726,
      NULL,
      NULL,
      0.780279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.452031,
      1,
      NULL,
      NULL,
      2.830498,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.503171,
      NULL,
      NULL,
      NULL,
      0.705586,
      0.969937,
      NULL,
      NULL,
      2.327055,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113084,
      NULL,
      NULL,
      NULL,
      3.080570,
      NULL,
      NULL,
      NULL,
      9,
      6,
      NULL,
      NULL,
      3,
      10.872845,
      NULL,
      2,
      2,
      4,
      1.948120,
      1,
      4,
      NULL,
      1.166348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.293346,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      15.717429,
      1,
      0,
      1.852451,
      1.782101,
      2,
      NULL,
      3,
      NULL,
      0.145541,
      0.363484,
      NULL,
      0.885384,
      1,
      0.966255,
      1.758651,
      0.086686,
      0.516212,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.191198,
      NULL,
      1.956244,
      NULL,
      NULL,
      NULL,
      108.813333,
      NULL,
      2,
      NULL,
      16.221434,
      NULL,
      0,
      1.930104,
      4.006196,
      0.035853,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.591178,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.095231,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.113717,
      NULL,
      1.509779,
      NULL,
      1.891155,
      NULL,
      3.943126,
      0,
      0.030386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514675,
      NULL,
      NULL,
      NULL,
      2.977070,
      NULL,
      2,
      NULL,
      3.031730,
      NULL,
      242,
      NULL,
      0,
      NULL,
      0.417096,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.496231,
      0.392806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184582,
      0,
      2,
      NULL,
      1,
      NULL,
      249,
      NULL,
      3.312078,
      NULL,
      2.461673,
      NULL,
      0.680071,
      NULL,
      NULL,
      1,
      4.642824,
      NULL,
      2,
      3,
      NULL,
      1.758843,
      0,
      3,
      NULL,
      5,
      2.766409,
      NULL,
      1.854750,
      NULL,
      11.550828,
      0.022068,
      0.634230,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      2,
      0,
      0,
      1,
      1,
      0.030110,
      NULL,
      NULL,
      1.132240,
      0.914438,
      1,
      1.571271,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.383463,
      NULL,
      NULL,
      1.229922,
      NULL,
      1.958664,
      0,
      NULL,
      3,
      NULL,
      1.241809,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.540173,
      0,
      0,
      NULL,
      5,
      7,
      0.927218,
      NULL,
      NULL,
      2,
      48,
      NULL,
      5,
      NULL,
      '2321',
      '01341',
      NULL,
      0,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


