set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659883';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      NULL,
      24,
      '3041412',
      2,
      NULL,
      4,
      1,
      '2003',
      3.847078,
      0,
      NULL,
      NULL,
      '11- 7-2003',
      48,
      14.997382,
      NULL,
      0,
      0.749141,
      ' 7- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 3- 5-1994',
      ' 0-12-1988',
      ' 5-16-1976',
      NULL,
      0,
      1,
      1.449574,
      0,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      7.709025,
      7.577872,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.025637,
      NULL,
      1.509669,
      1,
      NULL,
      1.502393,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.138247,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      4,
      0,
      3.838130,
      0,
      NULL,
      1,
      1,
      1.868073,
      NULL,
      NULL,
      1.144534,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      2.600600,
      2.375522,
      1,
      NULL,
      0,
      0.368745,
      1.971708,
      3,
      NULL,
      NULL,
      0.717278,
      NULL,
      3.219333,
      1,
      1.579098,
      NULL,
      0,
      3,
      6,
      1,
      1,
      0.774895,
      1.879488,
      NULL,
      NULL,
      1.145952,
      NULL,
      NULL,
      1,
      5,
      NULL,
      0,
      4,
      0,
      1,
      NULL,
      2,
      3,
      5,
      3,
      1,
      4.742718,
      0,
      1,
      1,
      1,
      1.790777,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      2,
      0,
      0,
      0,
      5,
      1,
      3,
      2,
      NULL,
      4,
      5.265905,
      3,
      NULL,
      242.747807,
      NULL,
      2.983348,
      3.147113,
      0,
      2,
      3,
      2,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1,
      4,
      1,
      3,
      NULL,
      1,
      8.597341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.990881,
      0.295380,
      0,
      0.702155,
      2.828858,
      NULL,
      0.756132,
      0.241873,
      0.265111,
      0,
      0.343872,
      0,
      NULL,
      NULL,
      NULL,
      1.214970,
      1,
      1.092336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607085,
      NULL,
      0,
      0.926459,
      1.954357,
      0,
      3,
      43.247914,
      1.572506,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      0,
      NULL,
      3,
      NULL,
      3,
      NULL,
      2,
      1,
      2,
      1,
      NULL,
      5,
      3,
      1,
      1.764419,
      NULL,
      NULL,
      1,
      1,
      1,
      0.141728,
      1,
      0.873345,
      0,
      1.710707,
      0,
      1.456030,
      4.441365,
      0,
      NULL,
      7,
      4,
      7.808307,
      NULL,
      7,
      2.628630,
      2,
      7.112930,
      0,
      2.637368,
      3,
      8.027820,
      3,
      2,
      26,
      NULL,
      10,
      18.117959,
      1,
      1.498059,
      0,
      '00404',
      '',
      '',
      1.581528,
      NULL,
      '',
      '',
      1.540590,
      NULL,
      NULL,
      NULL,
      3.374959,
      31.848948,
      42.293017,
      21.849544,
      1.515224,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.707769,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.627714,
      2,
      3,
      2.890079,
      0.961803,
      2,
      1,
      NULL,
      NULL,
      1.273201,
      1.125002,
      0.289101,
      NULL,
      NULL,
      NULL,
      1.384690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250664,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.490713,
      1.855204,
      0.865979,
      NULL,
      1.671895,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.753793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704567,
      NULL,
      NULL,
      1.358101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268720,
      NULL,
      NULL,
      2.497557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.447978,
      NULL,
      NULL,
      3,
      2.293071,
      NULL,
      1.333699,
      NULL,
      NULL,
      0.308232,
      NULL,
      NULL,
      NULL,
      5.134813,
      3,
      0,
      NULL,
      2,
      1.767791,
      NULL,
      NULL,
      3,
      2.736000,
      3.027870,
      0.923922,
      NULL,
      NULL,
      0.693122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.330685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673444,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      5.100161,
      1.597513,
      NULL,
      NULL,
      0.918109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433320,
      2,
      1.382502,
      4,
      3,
      0,
      2.274261,
      NULL,
      NULL,
      NULL,
      NULL,
      3.079944,
      1,
      0.243707,
      1.645439,
      0.856885,
      2,
      NULL,
      4,
      NULL,
      8.288754,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.700182,
      0.272668,
      1,
      NULL,
      0.284725,
      0.495941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642925,
      1,
      1,
      1.622756,
      NULL,
      0.353778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      326,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443948,
      NULL,
      NULL,
      0,
      NULL,
      0.055843,
      NULL,
      1.943675,
      0,
      0.658011,
      0,
      1,
      0,
      1.979563,
      0.506785,
      1,
      0,
      NULL,
      1.898044,
      NULL,
      0,
      1.617039,
      0,
      NULL,
      0.227690,
      0.351407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.767838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.928977,
      0.806968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430019,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.982818,
      NULL,
      1.824883,
      NULL,
      0.706067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.340498,
      1.413385,
      1.988126,
      1,
      3,
      2,
      1,
      1,
      0,
      0,
      0.230748,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1.039847,
      NULL,
      1.429750,
      1.837752,
      NULL,
      0.397973,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.564994,
      3.897546,
      NULL,
      0,
      3,
      NULL,
      0.902269,
      0,
      NULL,
      NULL,
      0.634776,
      NULL,
      0,
      1.880758,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.802800,
      NULL,
      NULL,
      29,
      8.029644,
      3,
      NULL,
      1.092902,
      NULL,
      '',
      NULL,
      1.022059,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


