set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7616175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.800900,
      1,
      0.728612,
      NULL,
      0,
      1,
      3,
      3.971174,
      '003',
      '24010141',
      4,
      37.922641,
      '0434111',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.631613,
      0.943890,
      NULL,
      NULL,
      ' 6- 8-1996',
      19,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '11- 0-1981',
      2.533405,
      1,
      NULL,
      NULL,
      NULL,
      2.920519,
      2,
      2.507174,
      NULL,
      NULL,
      NULL,
      1.953501,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      1.205763,
      1.742127,
      1.417994,
      1.393938,
      1.595111,
      1,
      0.703892,
      1,
      3,
      1,
      1.523670,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1.196614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.657078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1.710541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.101182,
      2,
      NULL,
      NULL,
      3.071391,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.259884,
      3,
      1.629749,
      NULL,
      1.998282,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.825693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406574,
      3,
      0,
      0,
      0,
      NULL,
      2.353400,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479912,
      2,
      0,
      NULL,
      1,
      2,
      2,
      2,
      NULL,
      NULL,
      3,
      1,
      0.119543,
      0.950268,
      1.622993,
      0,
      3.026032,
      NULL,
      1.276693,
      1.141816,
      0,
      0,
      1,
      1.546257,
      1,
      0.925275,
      1.831392,
      1,
      0.649840,
      3,
      1,
      11.758373,
      9.642029,
      NULL,
      3,
      NULL,
      6,
      NULL,
      0.547776,
      7.585681,
      0,
      NULL,
      NULL,
      30.054968,
      3,
      1.930544,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '23041',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      28,
      1.427566,
      62.847139,
      0.141958,
      44.602154,
      3.189455,
      3,
      5,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.924756,
      NULL,
      NULL,
      1.682449,
      NULL,
      NULL,
      0.430473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.441091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.631640,
      NULL,
      2,
      1,
      0.604721,
      0.727021,
      NULL,
      NULL,
      4.677419,
      0.982076,
      0,
      3,
      1.196556,
      1,
      NULL,
      0,
      1,
      2,
      0.632249,
      1.955211,
      0,
      NULL,
      NULL,
      1.120441,
      NULL,
      NULL,
      1.902202,
      NULL,
      NULL,
      0.017944,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.173600,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736163,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.278638,
      0,
      1,
      3.521612,
      NULL,
      1,
      7,
      0.855751,
      NULL,
      NULL,
      NULL,
      0,
      1.079134,
      1,
      1.736854,
      NULL,
      0,
      0.455652,
      NULL,
      1.525623,
      0.127515,
      NULL,
      NULL,
      1.838705,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.285870,
      NULL,
      0,
      0,
      1.661227,
      0.787882,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      21.236806,
      NULL,
      NULL,
      1.046613,
      0,
      NULL,
      0.794975,
      1.601490,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.174929,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      8.093532,
      NULL,
      7.576836,
      3,
      NULL,
      3,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      30.581392,
      NULL,
      NULL,
      NULL,
      0.773811,
      NULL,
      NULL,
      NULL,
      0.719517,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140315,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.301289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242222,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.039672,
      NULL,
      1,
      NULL,
      2.787306,
      NULL,
      1.492070,
      NULL,
      1,
      NULL,
      0.861937,
      NULL,
      3.051485,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.125916,
      NULL,
      0.498878,
      NULL,
      NULL,
      NULL,
      1.734689,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.409879,
      3,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.304144,
      3.132167,
      2.879490,
      0.591781,
      59,
      4,
      0,
      NULL,
      NULL,
      0.572583,
      NULL,
      0.740054,
      1268.972771,
      4.249479,
      0,
      NULL,
      1.562167,
      NULL,
      1.011150,
      NULL,
      1.664162,
      1.628239,
      NULL,
      1.212675,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.407313,
      1.137831,
      1.426585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.495640,
      NULL,
      NULL,
      0.984847,
      3,
      NULL,
      0.535793,
      1.820408,
      1.505395,
      0,
      0.622103,
      1.542462,
      0.160173,
      0.485757,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.206753,
      0.738414,
      0,
      NULL,
      NULL,
      0.406357,
      1.633930,
      0.099319,
      0,
      0.188493,
      0.215668,
      0,
      0,
      NULL,
      0,
      NULL,
      0.735730,
      1.182003,
      0,
      1,
      2,
      3.889651,
      3.304315,
      1,
      NULL,
      0.402972,
      1,
      0.643020,
      0,
      1.676377,
      1,
      NULL,
      0,
      1.544780,
      1,
      0.512108,
      0.275080,
      1,
      NULL,
      0.957151,
      0.490369,
      1.853549,
      1,
      0,
      0.491725,
      NULL,
      1.346478,
      0.890972,
      1,
      0,
      0,
      NULL,
      1.885253,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702568,
      0,
      0,
      1.231563,
      0.393021,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      8,
      127,
      NULL,
      1.267352,
      1.098912,
      '10032',
      NULL,
      '',
      0.239172,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


