set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9003431';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '0214014',
      NULL,
      0.784483,
      2,
      1,
      '0244',
      0.185382,
      NULL,
      NULL,
      NULL,
      ' 8- 5-1985',
      55,
      NULL,
      4,
      3.437833,
      0,
      ' 8-11-1975',
      NULL,
      1,
      348,
      123,
      1,
      ' 4- 2-1980',
      '10-17-1974',
      ' 0-27-1974',
      1,
      2,
      2,
      0.141263,
      1.879035,
      NULL,
      4,
      0,
      0.634006,
      242,
      7,
      14.405998,
      7.787908,
      166,
      183.307618,
      2,
      15,
      1,
      3,
      NULL,
      1,
      3,
      1,
      0,
      1.245615,
      NULL,
      1.091650,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      1,
      3,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      7,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.813915,
      1,
      1,
      1,
      3.818515,
      1.541841,
      1,
      1,
      2,
      3.869140,
      1,
      1,
      NULL,
      0.292329,
      NULL,
      NULL,
      0.085703,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      4,
      NULL,
      1,
      1,
      1,
      4,
      4,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      5,
      1,
      0,
      4,
      1,
      1,
      3,
      NULL,
      1,
      5,
      2,
      2,
      1,
      0,
      0,
      NULL,
      5,
      1,
      3,
      0,
      NULL,
      2,
      NULL,
      1,
      1.418418,
      0.448181,
      ' 1-19-1994',
      690,
      ' 6- 9-1998',
      432.939214,
      3,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      0,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330436,
      1.964352,
      3.375285,
      5.518072,
      1.317982,
      1.937097,
      3.084284,
      NULL,
      NULL,
      NULL,
      1,
      0.131012,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.757107,
      1.515162,
      3.361815,
      0.690691,
      0.175462,
      NULL,
      1.221156,
      1.881649,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.841154,
      3,
      3,
      0,
      1,
      0,
      2,
      3,
      3,
      1,
      NULL,
      3.466819,
      11.169852,
      3.502245,
      NULL,
      NULL,
      4.959559,
      NULL,
      159,
      93,
      176.499290,
      57,
      NULL,
      NULL,
      NULL,
      120.885062,
      1,
      5,
      17,
      0.499629,
      9,
      NULL,
      3,
      6,
      NULL,
      2.541359,
      3.286934,
      0,
      5,
      2.472757,
      1,
      2.388211,
      5,
      1,
      3,
      NULL,
      57,
      NULL,
      4.876106,
      0,
      1.554130,
      3,
      '40242',
      '',
      '',
      0,
      '',
      '',
      '',
      0.057293,
      '3132',
      NULL,
      NULL,
      1,
      16,
      238,
      NULL,
      0.621324,
      29,
      11.612940,
      46,
      1,
      2,
      14,
      3.988463,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.034887,
      0.446055,
      1.218415,
      4,
      0,
      0.854672,
      6.403204,
      11,
      1,
      NULL,
      NULL,
      3.737458,
      4,
      4,
      NULL,
      10,
      18,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      6.708078,
      3.708047,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.574797,
      1,
      NULL,
      NULL,
      3,
      9,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.693282,
      1,
      0.325754,
      0.065801,
      1,
      1.872699,
      NULL,
      1,
      0,
      2.984411,
      NULL,
      16.109788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.318915,
      NULL,
      NULL,
      2.282636,
      NULL,
      0.725700,
      0,
      0.118428,
      NULL,
      NULL,
      NULL,
      1.539632,
      NULL,
      NULL,
      13.857056,
      0,
      NULL,
      NULL,
      0,
      6.890970,
      0.363407,
      0.682917,
      NULL,
      0,
      1,
      NULL,
      NULL,
      4,
      2,
      0,
      15.546712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.082301,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110421,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.158655,
      NULL,
      NULL,
      11.668262,
      NULL,
      NULL,
      3.451551,
      NULL,
      NULL,
      0.489484,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      1.726008,
      0.950164,
      0,
      8.533636,
      14,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      6,
      1.235538,
      3,
      0.132624,
      1,
      0,
      12.387808,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      3.761074,
      1.727817,
      1,
      3.991883,
      2,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.048434,
      NULL,
      0.647203,
      1.745633,
      0,
      NULL,
      NULL,
      1.077110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.253782,
      NULL,
      NULL,
      7.694331,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524236,
      NULL,
      NULL,
      2.088789,
      3,
      3.195856,
      1,
      0,
      3.125734,
      1.308962,
      NULL,
      7.722287,
      0,
      NULL,
      NULL,
      NULL,
      5.595167,
      NULL,
      NULL,
      2.100403,
      2.301885,
      NULL,
      NULL,
      1.218160,
      NULL,
      NULL,
      NULL,
      18.157556,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.867011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.967703,
      0.318394,
      NULL,
      NULL,
      0.380457,
      3,
      NULL,
      NULL,
      0,
      2.196719,
      NULL,
      NULL,
      1.915704,
      0.774125,
      NULL,
      NULL,
      0.278387,
      2.086563,
      NULL,
      NULL,
      2,
      1.799928,
      NULL,
      NULL,
      0.292302,
      8.936842,
      NULL,
      NULL,
      0,
      0.827511,
      NULL,
      NULL,
      NULL,
      NULL,
      32.236781,
      14.134096,
      0,
      NULL,
      NULL,
      0.083823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      NULL,
      NULL,
      1,
      0.020875,
      0,
      0,
      1.708484,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.826328,
      1.231745,
      NULL,
      1.418702,
      0.601482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.243239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896056,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.930923,
      NULL,
      NULL,
      NULL,
      1.882547,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339024,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.388095,
      NULL,
      0,
      1,
      0.324317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.430942,
      NULL,
      3.478832,
      1,
      1,
      1,
      1.999275,
      NULL,
      1,
      10,
      NULL,
      NULL,
      15,
      0,
      NULL,
      16,
      3,
      NULL,
      19,
      7.344496,
      NULL,
      19.520546,
      14,
      NULL,
      10,
      NULL,
      NULL,
      14,
      0.015157,
      NULL,
      5,
      19.217902,
      NULL,
      0,
      NULL,
      NULL,
      3,
      11.178010,
      NULL,
      8,
      12.577107,
      NULL,
      2,
      0,
      0.807213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      0,
      6,
      1.767974,
      NULL,
      2,
      41,
      0,
      2,
      0.389678,
      0.687785,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0.657133,
      '4002',
      NULL,
      NULL);
commit;
end;
/


